/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.selection.statistic;

import com.sap.sse.datamining.shared.impl.dto.DataRetrieverChainDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import java.util.ArrayList;
import java.util.Collection;

abstract class ExtractionFunctionWithContext
implements Comparable<ExtractionFunctionWithContext> {
    private final DataRetrieverChainDefinitionDTO retrieverChain;
    private final FunctionDTO extractionFunction;
    private final Collection<String> matchingStrings;

    protected ExtractionFunctionWithContext(DataRetrieverChainDefinitionDTO retrieverChain, FunctionDTO extractionFunction) {
        this.retrieverChain = retrieverChain;
        this.extractionFunction = extractionFunction;
        this.matchingStrings = new ArrayList<String>(4);
    }

    public DataRetrieverChainDefinitionDTO getRetrieverChain() {
        return this.retrieverChain;
    }

    public FunctionDTO getExtractionFunction() {
        return this.extractionFunction;
    }

    public abstract String getDisplayString();

    public Iterable<String> getMatchingStrings() {
        return this.matchingStrings;
    }

    protected void addMatchingString(String matchingString) {
        this.matchingStrings.add(matchingString);
    }

    @Override
    public int compareTo(ExtractionFunctionWithContext o) {
        String otherDisplayName = o.getExtractionFunction().getDisplayName();
        int comparedDisplayName = this.extractionFunction.getDisplayName().compareToIgnoreCase(otherDisplayName);
        if (comparedDisplayName != 0) {
            return comparedDisplayName;
        }
        return this.retrieverChain.compareTo(o.getRetrieverChain());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.extractionFunction == null ? 0 : this.extractionFunction.hashCode());
        result = 31 * result + (this.retrieverChain == null ? 0 : this.retrieverChain.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtractionFunctionWithContext other = (ExtractionFunctionWithContext)obj;
        if (this.extractionFunction == null ? other.extractionFunction != null : !this.extractionFunction.equals((Object)other.extractionFunction)) {
            return false;
        }
        return !(this.retrieverChain == null ? other.retrieverChain != null : !this.retrieverChain.equals((Object)other.retrieverChain));
    }

    static class IdentityFunctionWithContext
    extends ExtractionFunctionWithContext {
        public IdentityFunctionWithContext(DataRetrieverChainDefinitionDTO retrieverChain, FunctionDTO identityFunction) {
            super(retrieverChain, identityFunction);
            this.addMatchingString(retrieverChain.getName());
        }

        @Override
        public String getDisplayString() {
            return this.getRetrieverChain().getName();
        }
    }

    static class StatisticWithContext
    extends ExtractionFunctionWithContext {
        public StatisticWithContext(DataRetrieverChainDefinitionDTO retrieverChain, FunctionDTO extractionFunction) {
            super(retrieverChain, extractionFunction);
            this.addMatchingString(retrieverChain.getName());
            this.addMatchingString(extractionFunction.getDisplayName());
        }

        @Override
        public String getDisplayString() {
            return this.getExtractionFunction().getDisplayName();
        }
    }
}

