/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation.dataproviders;

import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.AbstractNumericDataProviderWithStaticMappings;
import java.util.LinkedHashMap;
import java.util.function.Function;

public class NumberDataProvider
extends AbstractNumericDataProviderWithStaticMappings<Number> {
    private static final String FLOAT = "Float";
    private static final String INTEGER = "Integer";

    public NumberDataProvider() {
        super(Number.class, NumberDataProvider.getMappings());
    }

    private static LinkedHashMap<String, Function<Number, Number>> getMappings() {
        LinkedHashMap<String, Function<Number, Number>> mappings = new LinkedHashMap<String, Function<Number, Number>>();
        mappings.put(FLOAT, number -> number.doubleValue());
        mappings.put(INTEGER, number -> number.intValue());
        return mappings;
    }

    @Override
    public boolean acceptsResultsOfType(String type) {
        return type.equals(Number.class.getName()) || type.equals(Double.class.getName()) || type.equals(Float.class.getName()) || type.equals(Long.class.getName()) || type.equals(Integer.class.getName()) || type.equals(Short.class.getName()) || type.equals(Byte.class.getName()) || type.equals(Double.TYPE.getName()) || type.equals(Float.TYPE.getName()) || type.equals(Long.TYPE.getName()) || type.equals(Integer.TYPE.getName()) || type.equals(Short.TYPE.getName()) || type.equals(Byte.TYPE.getName());
    }

    @Override
    public String getDefaultDataKeyFor(QueryResultDTO<?> result) {
        return result.getValueDecimals() == 0 ? INTEGER : FLOAT;
    }

    @Override
    public String getLocalizedNameForDataKey(QueryResultDTO<?> result, StringMessages stringMessages, String dataKey) {
        switch (dataKey) {
            case "Float": {
                return stringMessages.floatNumber();
            }
            case "Integer": {
                return stringMessages.integer();
            }
        }
        throw new IllegalArgumentException("The given data key '" + dataKey + "' isn't valid");
    }
}

