/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation.dataproviders;

import com.sap.sse.common.Distance;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.AbstractNumericDataProviderWithStaticMappings;
import java.util.LinkedHashMap;
import java.util.function.Function;

public class DistanceDataProvider
extends AbstractNumericDataProviderWithStaticMappings<Distance> {
    private static final String CENTRAL_ANGLE_RADIAN = "CentralAngleRadian";
    private static final String CENTRAL_ANGLE_DEGREE = "CentralAngleDegree";
    private static final String KILOMETERS = "Kilometers";
    private static final String METERS = "Meters";
    private static final String NAUTICAL_MILES = "NauticalMiles";
    private static final String SEA_MILES = "SeaMiles";
    private static final String GEOGRAPHICAL_MILES = "GeographicalMiles";

    public DistanceDataProvider() {
        super(Distance.class, DistanceDataProvider.getMappings());
    }

    private static LinkedHashMap<String, Function<Distance, Number>> getMappings() {
        LinkedHashMap<String, Function<Distance, Number>> mappings = new LinkedHashMap<String, Function<Distance, Number>>();
        mappings.put(GEOGRAPHICAL_MILES, distance -> distance.getGeographicalMiles());
        mappings.put(SEA_MILES, distance -> distance.getSeaMiles());
        mappings.put(NAUTICAL_MILES, distance -> distance.getNauticalMiles());
        mappings.put(METERS, distance -> distance.getMeters());
        mappings.put(KILOMETERS, distance -> distance.getKilometers());
        mappings.put(CENTRAL_ANGLE_DEGREE, distance -> distance.getCentralAngleDeg());
        mappings.put(CENTRAL_ANGLE_RADIAN, distance -> distance.getCentralAngleRad());
        return mappings;
    }

    @Override
    public String getDefaultDataKeyFor(QueryResultDTO<?> result) {
        return METERS;
    }

    @Override
    public String getLocalizedNameForDataKey(QueryResultDTO<?> result, StringMessages stringMessages, String dataKey) {
        switch (dataKey) {
            case "CentralAngleRadian": {
                return stringMessages.centralAngleInRadian();
            }
            case "CentralAngleDegree": {
                return stringMessages.centralAngleInDegree();
            }
            case "Kilometers": {
                return stringMessages.kilometers();
            }
            case "Meters": {
                return stringMessages.meters();
            }
            case "NauticalMiles": {
                return stringMessages.nauticalMiles();
            }
            case "SeaMiles": {
                return stringMessages.seaMiles();
            }
            case "GeographicalMiles": {
                return stringMessages.geographicalMiles();
            }
        }
        throw new IllegalArgumentException("The given data key '" + dataKey + "' isn't valid");
    }
}

