/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation.dataproviders;

import com.sap.sse.common.Bearing;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.AbstractNumericDataProviderWithStaticMappings;
import java.util.LinkedHashMap;
import java.util.function.Function;

public class BearingDataProvider
extends AbstractNumericDataProviderWithStaticMappings<Bearing> {
    private static final String DEGREES = "Degrees";
    private static final String RADIANS = "Radians";

    public BearingDataProvider() {
        super(Bearing.class, BearingDataProvider.getMappings());
    }

    private static LinkedHashMap<String, Function<Bearing, Number>> getMappings() {
        LinkedHashMap<String, Function<Bearing, Number>> mappings = new LinkedHashMap<String, Function<Bearing, Number>>();
        mappings.put(DEGREES, bearing -> bearing.getDegrees());
        mappings.put(RADIANS, bearing -> bearing.getRadians());
        return mappings;
    }

    @Override
    public String getDefaultDataKeyFor(QueryResultDTO<?> result) {
        return DEGREES;
    }

    @Override
    public String getLocalizedNameForDataKey(QueryResultDTO<?> result, StringMessages stringMessages, String dataKey) {
        switch (dataKey) {
            case "Degrees": {
                return stringMessages.angleInDegree();
            }
            case "Radians": {
                return stringMessages.angleInRadian();
            }
        }
        throw new IllegalArgumentException("The given data key '" + dataKey + "' isn't valid");
    }
}

