/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.ui.ValueListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.presentation.AbstractResultsPresenter;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.AbstractNumericDataProvider;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.AverageWithStatsDataProvider;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.BearingDataProvider;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.DataProvidersPrecedenceList;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.DistanceDataProvider;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.DurationDataProvider;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.NumberDataProvider;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.SpeedDataProvider;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.controls.AbstractObjectRenderer;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractNumericResultsPresenter<SettingsType extends Settings>
extends AbstractResultsPresenter<Settings> {
    private final DataProvidersPrecedenceList dataProviders;
    private final ValueListBox<String> dataSelectionListBox;
    private AbstractNumericDataProvider<? extends Object> currentDataProvider;

    public AbstractNumericResultsPresenter(Component<?> parent, ComponentContext<?> context) {
        super(parent, context);
        List<AbstractNumericDataProvider<? extends Serializable>> basicProviders = Arrays.asList(new NumberDataProvider(), new DistanceDataProvider(), new DurationDataProvider(), new BearingDataProvider(), new SpeedDataProvider());
        ArrayList<AbstractNumericDataProvider<? extends Serializable>> allProviders = new ArrayList<AbstractNumericDataProvider<? extends Serializable>>(basicProviders);
        allProviders.add(new AverageWithStatsDataProvider(new DataProvidersPrecedenceList(basicProviders)));
        this.dataProviders = new DataProvidersPrecedenceList(allProviders);
        this.dataSelectionListBox = new ValueListBox((Renderer)new AbstractObjectRenderer<String>(){

            protected String convertObjectToString(String dataKey) {
                return AbstractNumericResultsPresenter.this.currentDataProvider.getLocalizedNameForDataKey(AbstractNumericResultsPresenter.this.getCurrentResult(), AbstractNumericResultsPresenter.this.getDataMiningStringMessages(), dataKey);
            }
        });
        this.dataSelectionListBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                Map<GroupKey, Number> resultValues = AbstractNumericResultsPresenter.this.currentDataProvider.getData(AbstractNumericResultsPresenter.this.getCurrentResult(), (String)AbstractNumericResultsPresenter.this.dataSelectionListBox.getValue());
                Map<GroupKey, Util.Triple<Number, Number, Long>> errorMargins = AbstractNumericResultsPresenter.this.currentDataProvider.getErrorData(AbstractNumericResultsPresenter.this.getCurrentResult(), (String)AbstractNumericResultsPresenter.this.dataSelectionListBox.getValue());
                AbstractNumericResultsPresenter.this.internalShowNumericResults(resultValues, errorMargins);
            }
        });
        this.addControl((Widget)this.dataSelectionListBox);
    }

    @Override
    protected void internalShowResults(StatisticQueryDefinitionDTO queryDefinition, QueryResultDTO<?> result) {
        this.currentDataProvider = this.dataProviders.selectCurrentDataProvider(result.getResultType());
        this.updateDataSelectionListBox();
        if (this.currentDataProvider != null) {
            Map<GroupKey, Number> resultValues = this.currentDataProvider.getData(this.getCurrentResult(), (String)this.dataSelectionListBox.getValue());
            Map<GroupKey, Util.Triple<Number, Number, Long>> errorMargins = this.currentDataProvider.getErrorData(this.getCurrentResult(), (String)this.dataSelectionListBox.getValue());
            this.internalShowNumericResults(resultValues, errorMargins);
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    AbstractNumericResultsPresenter.this.presentationPanel.onResize();
                }
            });
        } else {
            this.showError(queryDefinition, this.getDataMiningStringMessages().cantDisplayDataOfType(this.getCurrentResult().getResultType()));
        }
    }

    private void updateDataSelectionListBox() {
        if (this.currentDataProvider == null) {
            this.dataSelectionListBox.setAcceptableValues(Collections.emptyList());
        } else {
            Collection<String> dataKeys = this.currentDataProvider.getDataKeys(this.getCurrentResult());
            String keyToSelect = this.currentDataProvider.getDefaultDataKeyFor(this.getCurrentResult());
            this.dataSelectionListBox.setValue((Object)keyToSelect, false);
            this.dataSelectionListBox.setAcceptableValues(dataKeys);
        }
    }

    protected abstract void internalShowNumericResults(Map<GroupKey, Number> var1, Map<GroupKey, Util.Triple<Number, Number, Long>> var2);

    String getSelectedDataKey() {
        return (String)this.dataSelectionListBox.getValue();
    }

    void setSelectedDataKey(String dataKey) {
        if (!this.currentDataProvider.isValidDataKey(this.getCurrentResult(), dataKey)) {
            throw new IllegalArgumentException("The given data key '" + dataKey + "' isn't valid");
        }
        this.dataSelectionListBox.setValue((Object)dataKey, true);
    }
}

