/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.execution;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.datamining.shared.DataMiningSession;
import com.sap.sse.datamining.shared.data.ReportParameterToDimensionFilterBindings;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.ModifiableStatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.AbstractDataMiningComponent;
import com.sap.sse.datamining.ui.client.CompositeResultsPresenter;
import com.sap.sse.datamining.ui.client.DataMiningServiceAsync;
import com.sap.sse.datamining.ui.client.DataMiningSettingsControl;
import com.sap.sse.datamining.ui.client.QueryDefinitionProvider;
import com.sap.sse.datamining.ui.client.QueryRunner;
import com.sap.sse.datamining.ui.client.ReportProvider;
import com.sap.sse.datamining.ui.client.settings.QueryRunnerSettings;
import com.sap.sse.datamining.ui.client.settings.QueryRunnerSettingsDialogComponent;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SimpleQueryRunner
extends AbstractDataMiningComponent<QueryRunnerSettings>
implements QueryRunner {
    private static final int queryBufferTimeInMillis = 200;
    private final DataMiningSession session;
    private final DataMiningServiceAsync dataMiningService;
    private final ErrorReporter errorReporter;
    private final Timer queryReleaseTimer;
    private QueryRunnerSettings settings;
    private final QueryDefinitionProvider<?> queryDefinitionProvider;
    private final CompositeResultsPresenter<?> resultsPresenter;
    private final ReportProvider reportProvider;
    private final Button runButton;

    public SimpleQueryRunner(Component<?> parent, ComponentContext<?> context, DataMiningSession session, DataMiningServiceAsync dataMiningService, ErrorReporter errorReporter, DataMiningSettingsControl settingsControl, final QueryDefinitionProvider<?> queryDefinitionProvider, CompositeResultsPresenter<?> resultsPresenter, ReportProvider reportProvider) {
        super(parent, context);
        this.session = session;
        this.dataMiningService = dataMiningService;
        this.errorReporter = errorReporter;
        queryDefinitionProvider.addQueryDefinitionChangedListener(this);
        this.settings = new QueryRunnerSettings();
        this.queryDefinitionProvider = queryDefinitionProvider;
        this.resultsPresenter = resultsPresenter;
        this.reportProvider = reportProvider;
        this.runButton = new Button(this.getDataMiningStringMessages().run());
        this.runButton.ensureDebugId("RunDataminingQueryButton");
        this.runButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Map otherQueriesAlsoModifiedWithPresenterId;
                Map otherChangedQueriesToAlsoRunInBackground = SimpleQueryRunner.this.settings.getOtherChangedQueriesRunStrategy() == QueryRunnerSettings.OtherChangedQueriesRunStrategy.NO ? Collections.emptyMap() : (!(otherQueriesAlsoModifiedWithPresenterId = SimpleQueryRunner.this.getOtherQueriesAlsoModifiedWithPresenterId()).isEmpty() && (SimpleQueryRunner.this.settings.getOtherChangedQueriesRunStrategy() == QueryRunnerSettings.OtherChangedQueriesRunStrategy.AUTOMATICALLY || SimpleQueryRunner.this.settings.getOtherChangedQueriesRunStrategy() == QueryRunnerSettings.OtherChangedQueriesRunStrategy.ASK && Window.confirm((String)SimpleQueryRunner.this.getDataMiningStringMessages().runOtherChangedQueriesInBackground())) ? otherQueriesAlsoModifiedWithPresenterId : Collections.emptyMap());
                Util.Pair<ModifiableStatisticQueryDefinitionDTO, ReportParameterToDimensionFilterBindings> queryDefinitionAndParameterBindings = queryDefinitionProvider.getQueryDefinitionAndReportParameterBinding();
                SimpleQueryRunner.this.run((ModifiableStatisticQueryDefinitionDTO)queryDefinitionAndParameterBindings.getA(), (ReportParameterToDimensionFilterBindings)queryDefinitionAndParameterBindings.getB());
                for (Map.Entry e : otherChangedQueriesToAlsoRunInBackground.entrySet()) {
                    GWT.log((String)("Running query for presenter " + (String)e.getKey() + " in the background"));
                    SimpleQueryRunner.this.runQueryAndShowResultsOrErrors((StatisticQueryDefinitionDTO)e.getValue(), (String)e.getKey());
                }
            }
        });
        this.queryReleaseTimer = new Timer(){

            public void run() {
                Util.Pair<ModifiableStatisticQueryDefinitionDTO, ReportParameterToDimensionFilterBindings> queryDefinitionAndParameterBindings = queryDefinitionProvider.getQueryDefinitionAndReportParameterBinding();
                SimpleQueryRunner.this.run((ModifiableStatisticQueryDefinitionDTO)queryDefinitionAndParameterBindings.getA(), (ReportParameterToDimensionFilterBindings)queryDefinitionAndParameterBindings.getB());
            }
        };
        settingsControl.addSettingsComponent(this);
        this.queryDefinitionChanged(queryDefinitionProvider.getQueryDefinition());
    }

    private Map<String, StatisticQueryDefinitionDTO> getOtherQueriesAlsoModifiedWithPresenterId() {
        HashMap<String, StatisticQueryDefinitionDTO> result = new HashMap<String, StatisticQueryDefinitionDTO>();
        for (String presenterId : this.resultsPresenter.getPresenterIds()) {
            if (presenterId.equals(this.resultsPresenter.getCurrentPresenterId()) || !this.resultsPresenter.getQueryDefinition(presenterId).isQueryChangedSinceLastRun()) continue;
            result.put(presenterId, this.resultsPresenter.getQueryDefinition(presenterId));
        }
        return result;
    }

    @Override
    public void run(ModifiableStatisticQueryDefinitionDTO queryDefinition, ReportParameterToDimensionFilterBindings reportParameterBindings) {
        String presenterId = this.resultsPresenter.getCurrentPresenterId();
        StatisticQueryDefinitionDTO oldPresenterQuery = this.resultsPresenter.getCurrentQueryDefinition();
        this.reportProvider.getCurrentReport().getReport().replaceQueryDefinition(oldPresenterQuery, queryDefinition, reportParameterBindings);
        this.runQueryAndShowResultsOrErrors((StatisticQueryDefinitionDTO)queryDefinition, presenterId);
    }

    private void runQueryAndShowResultsOrErrors(final StatisticQueryDefinitionDTO queryDefinition, final String presenterId) {
        Iterable<String> errorMessages = this.queryDefinitionProvider.validateQueryDefinition(queryDefinition);
        if (errorMessages == null || !errorMessages.iterator().hasNext()) {
            this.resultsPresenter.showBusyIndicator(presenterId);
            queryDefinition.setQueryChangedSinceLastRun(false);
            this.dataMiningService.runQuery(this.session, (ModifiableStatisticQueryDefinitionDTO)queryDefinition, new AsyncCallback<QueryResultDTO<Serializable>>(){

                public void onSuccess(QueryResultDTO<Serializable> result) {
                    SimpleQueryRunner.this.resultsPresenter.showResult(presenterId, queryDefinition, result);
                    SimpleQueryRunner.this.queryDefinitionProvider.queryDefinitionChangesHaveBeenStored();
                }

                public void onFailure(Throwable caught) {
                    SimpleQueryRunner.this.errorReporter.reportError(String.valueOf(SimpleQueryRunner.this.getDataMiningStringMessages().errorRunningDataMiningQuery()) + ": " + caught.getMessage());
                    SimpleQueryRunner.this.resultsPresenter.showError(presenterId, queryDefinition, String.valueOf(SimpleQueryRunner.this.getDataMiningStringMessages().errorRunningDataMiningQuery()) + ".");
                }
            });
        } else {
            this.resultsPresenter.showError(presenterId, queryDefinition, this.getDataMiningStringMessages().queryNotValidBecause(), errorMessages);
        }
    }

    public void updateSettings(QueryRunnerSettings newSettings) {
        this.settings = newSettings;
    }

    @Override
    public void queryDefinitionChanged(StatisticQueryDefinitionDTO newQueryDefinition) {
        Iterable<String> errors = this.queryDefinitionProvider.validateQueryDefinition(newQueryDefinition);
        boolean isValid = Util.isEmpty(errors);
        this.runButton.setEnabled(isValid);
        if (isValid) {
            this.runButton.setTitle(null);
            if (this.settings.isRunAutomatically()) {
                this.queryReleaseTimer.schedule(200);
            }
        } else {
            Iterator<String> errorsIterator = errors.iterator();
            StringBuilder tooltipBuilder = new StringBuilder(errorsIterator.next());
            errorsIterator.forEachRemaining(e -> {
                StringBuilder stringBuilder2 = tooltipBuilder.append("\n").append((String)e);
            });
            this.runButton.setTitle(tooltipBuilder.toString());
        }
    }

    public String getLocalizedShortName() {
        return this.getDataMiningStringMessages().queryRunner();
    }

    public Widget getEntryWidget() {
        return this.runButton;
    }

    public boolean isVisible() {
        return this.runButton.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.runButton.setVisible(visibility);
    }

    public boolean hasSettings() {
        return true;
    }

    public QueryRunnerSettings getSettings() {
        return this.settings;
    }

    public SettingsDialogComponent<QueryRunnerSettings> getSettingsDialogComponent(QueryRunnerSettings settings) {
        return new QueryRunnerSettingsDialogComponent(settings, this.getDataMiningStringMessages());
    }

    public String getDependentCssClassName() {
        return "simpleQueryRunner";
    }

    public String getId() {
        return "SimpleQueryRunner";
    }
}

