/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.developer;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ValueListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.datamining.shared.data.ReportParameterToDimensionFilterBindings;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.PredefinedQueryIdentifier;
import com.sap.sse.datamining.shared.impl.dto.ModifiableStatisticQueryDefinitionDTO;
import com.sap.sse.datamining.ui.client.DataMiningServiceAsync;
import com.sap.sse.datamining.ui.client.QueryDefinitionProvider;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.ComponentWithoutSettings;
import com.sap.sse.gwt.client.shared.controls.AbstractObjectRenderer;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;

public class PredefinedQueryRunner
extends ComponentWithoutSettings {
    private final StringMessages stringMessages;
    private final DataMiningServiceAsync dataMiningService;
    private final ErrorReporter errorReporter;
    private final QueryDefinitionProvider<?> queryDefinitionProvider;
    private final Consumer<Util.Pair<ModifiableStatisticQueryDefinitionDTO, ReportParameterToDimensionFilterBindings>> queryRunner;
    private final Button showDialogButton;
    private final DialogBox dialogBox;
    private final SimpleBusyIndicator busyIndicator;
    private final ValueListBox<PredefinedQueryIdentifier> selectionListBox;
    private final Button runButton;

    public PredefinedQueryRunner(Component<?> parent, ComponentContext<?> context, StringMessages stringMessages, DataMiningServiceAsync dataMiningService, ErrorReporter errorReporter, QueryDefinitionProvider<?> queryDefinitionProvider, Consumer<Util.Pair<ModifiableStatisticQueryDefinitionDTO, ReportParameterToDimensionFilterBindings>> queryRunner) {
        super(parent, context);
        this.stringMessages = stringMessages;
        this.dataMiningService = dataMiningService;
        this.errorReporter = errorReporter;
        this.queryDefinitionProvider = queryDefinitionProvider;
        this.queryRunner = queryRunner;
        this.showDialogButton = new Button(stringMessages.runPredefinedQuery(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                PredefinedQueryRunner.this.show();
            }
        });
        this.dialogBox = new DialogBox(false, true);
        this.dialogBox.setText(stringMessages.runPredefinedQuery());
        this.dialogBox.setAnimationEnabled(true);
        Button closeButton = new Button(stringMessages.close(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                PredefinedQueryRunner.this.dialogBox.hide();
            }
        });
        this.runButton = new Button(stringMessages.run(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                PredefinedQueryRunner.this.runSelectedPredefinedQuery();
            }
        });
        HorizontalPanel contentPanel = new HorizontalPanel();
        contentPanel.setSpacing(5);
        contentPanel.add((Widget)new Label(String.valueOf(stringMessages.selectPredefinedQuery()) + ":"));
        this.busyIndicator = new SimpleBusyIndicator(true, 0.7f);
        this.busyIndicator.setVisible(false);
        contentPanel.add((Widget)this.busyIndicator);
        this.selectionListBox = new ValueListBox((Renderer)new AbstractObjectRenderer<PredefinedQueryIdentifier>(){

            protected String convertObjectToString(PredefinedQueryIdentifier nonNullObject) {
                return nonNullObject.getDescription();
            }
        });
        contentPanel.add(this.selectionListBox);
        DockPanel dockPanel = new DockPanel();
        dockPanel.setSpacing(4);
        HorizontalPanel dialogButtonsPanel = new HorizontalPanel();
        dialogButtonsPanel.setSpacing(5);
        dialogButtonsPanel.add((Widget)this.runButton);
        dialogButtonsPanel.add((Widget)closeButton);
        dockPanel.add((Widget)dialogButtonsPanel, DockPanel.SOUTH);
        dockPanel.setCellHorizontalAlignment((Widget)dialogButtonsPanel, DockPanel.ALIGN_RIGHT);
        dockPanel.add((Widget)contentPanel, DockPanel.CENTER);
        dockPanel.setWidth("100%");
        this.dialogBox.setWidget((Widget)dockPanel);
    }

    public void show() {
        this.runButton.setEnabled(false);
        this.selectionListBox.setVisible(false);
        this.busyIndicator.setVisible(true);
        this.dialogBox.center();
        this.dataMiningService.getPredefinedQueryIdentifiers(new AsyncCallback<HashSet<PredefinedQueryIdentifier>>(){

            public void onFailure(Throwable caught) {
                PredefinedQueryRunner.this.errorReporter.reportError("Error fetching the predefined query names: " + caught.getMessage());
                PredefinedQueryRunner.this.busyIndicator.setVisible(false);
            }

            public void onSuccess(HashSet<PredefinedQueryIdentifier> predefinedQueryIdentifiers) {
                if (!predefinedQueryIdentifiers.isEmpty()) {
                    PredefinedQueryIdentifier valueToBeSelected = (PredefinedQueryIdentifier)Util.get(predefinedQueryIdentifiers, (int)0);
                    ArrayList<PredefinedQueryIdentifier> acceptableValues = new ArrayList<PredefinedQueryIdentifier>(predefinedQueryIdentifiers);
                    PredefinedQueryRunner.this.selectionListBox.setValue((Object)valueToBeSelected);
                    PredefinedQueryRunner.this.selectionListBox.setAcceptableValues(acceptableValues);
                    PredefinedQueryRunner.this.runButton.setEnabled(true);
                    PredefinedQueryRunner.this.selectionListBox.setVisible(true);
                } else {
                    PredefinedQueryRunner.this.errorReporter.reportError("No predefined query names have been found.");
                }
                PredefinedQueryRunner.this.busyIndicator.setVisible(false);
            }
        });
    }

    protected void runSelectedPredefinedQuery() {
        PredefinedQueryIdentifier predefinedQueryIdentifier = (PredefinedQueryIdentifier)this.selectionListBox.getValue();
        this.dataMiningService.getPredefinedQueryDefinition(predefinedQueryIdentifier, LocaleInfo.getCurrentLocale().getLocaleName(), new AsyncCallback<ModifiableStatisticQueryDefinitionDTO>(){

            public void onSuccess(ModifiableStatisticQueryDefinitionDTO queryDefinition) {
                PredefinedQueryRunner.this.queryDefinitionProvider.applyQueryDefinition((StatisticQueryDefinitionDTO)queryDefinition);
                PredefinedQueryRunner.this.queryRunner.accept(new Util.Pair((Object)queryDefinition, null));
            }

            public void onFailure(Throwable error) {
                PredefinedQueryRunner.this.errorReporter.reportError("Error running the query: " + error.getMessage());
            }
        });
        this.dialogBox.hide();
    }

    public String getLocalizedShortName() {
        return this.stringMessages.predefinedQueryRunner();
    }

    public Widget getEntryWidget() {
        return this.showDialogButton;
    }

    public boolean isVisible() {
        return this.showDialogButton.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.showDialogButton.setVisible(visibility);
    }

    public String getDependentCssClassName() {
        return "predefinedQueryRunner";
    }

    public String getId() {
        return "PredefinedQueryRunner";
    }
}

