/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.media.mp4;

import com.sap.sailing.media.mp4.MP4MediaParser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import org.mp4parser.BoxParser;
import org.mp4parser.IsoFile;
import org.mp4parser.PropertyBoxParserImpl;
import org.xml.sax.SAXException;

public class MediaFileParser {
    public static void main(String[] args) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        new MediaFileParser().checkMetadata(new File(args[0]));
    }

    public void checkMetadata(File file) throws IOException, ParserConfigurationException, SAXException {
        boolean spherical = false;
        long durationInMillis = -1L;
        Date recordStartedTimer = null;
        PropertyBoxParserImpl boxParserImpl = new PropertyBoxParserImpl(new String[0]);
        boxParserImpl.skippingBoxes(new String[]{"mdat"});
        Throwable throwable = null;
        Object var8_8 = null;
        try (IsoFile isof = new IsoFile((ReadableByteChannel)Files.newByteChannel(file.toPath(), new OpenOption[0]), (BoxParser)boxParserImpl);){
            recordStartedTimer = MP4MediaParser.determineRecordingStart(isof);
            spherical = MP4MediaParser.determine360(isof);
            durationInMillis = MP4MediaParser.determineDurationInMillis(isof);
            System.out.println("Start: " + recordStartedTimer.toString() + ", duration: " + durationInMillis + "ms; spherical: " + spherical);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

