/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.OperationsToMasterSender;
import com.sap.sse.replication.OperationsToMasterSendingQueue;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnsentOperationsSenderJob
implements OperationsToMasterSendingQueue,
Runnable {
    private static final Logger logger = Logger.getLogger(UnsentOperationsSenderJob.class.getName());
    private static final Duration MAX_WAIT_TIME_BETWEEN_ATTEMPTS = Duration.ONE_MINUTE;
    private final Deque<Util.Pair<OperationWithResult<?, ?>, OperationsToMasterSender<?, ?>>> queue = new ConcurrentLinkedDeque();
    private boolean scheduled;
    private Duration nextWaitDuration;

    public UnsentOperationsSenderJob() {
        this.resetWaitDuration();
    }

    private void resetWaitDuration() {
        this.nextWaitDuration = Duration.ONE_MILLISECOND;
    }

    public synchronized <S, O extends OperationWithResult<S, ?>, T> void scheduleForSending(O operationWithResult, OperationsToMasterSender<S, O> sender) {
        this.queue.addLast(new Util.Pair(operationWithResult, sender));
        this.ensureScheduled();
    }

    private synchronized void ensureScheduled() {
        if (!this.scheduled) {
            logger.info("Scheduling replication operation re-send to master in " + this.nextWaitDuration);
            ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor().schedule(this, this.nextWaitDuration.asMillis(), TimeUnit.MILLISECONDS);
            this.scheduled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean empty = false;
        Util.Pair<OperationWithResult<?, ?>, OperationsToMasterSender<?, ?>> first = null;
        boolean sendOk = true;
        while (!empty && sendOk) {
            first = this.queue.peekFirst();
            sendOk = first != null ? this.tryToSend(first) : false;
            UnsentOperationsSenderJob unsentOperationsSenderJob = this;
            synchronized (unsentOperationsSenderJob) {
                if (sendOk) {
                    this.resetWaitDuration();
                    this.queue.removeFirst();
                } else {
                    this.incrementWaitDuration();
                    this.scheduled = false;
                    this.ensureScheduled();
                }
                empty = this.queue.isEmpty();
                if (empty) {
                    this.scheduled = false;
                }
            }
        }
    }

    private <S, O extends OperationWithResult<S, ?>, R> boolean tryToSend(Util.Pair<OperationWithResult<?, ?>, OperationsToMasterSender<?, ?>> unsentOperationAndSender) {
        OperationWithResult operation = (OperationWithResult)unsentOperationAndSender.getA();
        OperationsToMasterSender sender = (OperationsToMasterSender)unsentOperationAndSender.getB();
        return this.tryToSend(operation, sender);
    }

    private <S, O extends OperationWithResult<S, ?>, R> boolean tryToSend(OperationWithResult<S, R> operation, OperationsToMasterSender<S, O> sender) {
        boolean result;
        try {
            sender.sendReplicaInitiatedOperationToMaster(operation);
            result = true;
        }
        catch (Throwable e) {
            result = false;
            sender.hasSentOperationToMaster(operation);
            logger.log(Level.INFO, "Error (re-)sending operation " + operation + " to master " + sender.getMasterDescriptor() + ": " + e.getMessage() + ". Will try again in " + this.nextWaitDuration);
        }
        return result;
    }

    private void incrementWaitDuration() {
        if (this.nextWaitDuration.compareTo((Object)MAX_WAIT_TIME_BETWEEN_ATTEMPTS) < 0) {
            this.nextWaitDuration = this.nextWaitDuration.times(2L);
            if (this.nextWaitDuration.compareTo((Object)MAX_WAIT_TIME_BETWEEN_ATTEMPTS) > 0) {
                this.nextWaitDuration = MAX_WAIT_TIME_BETWEEN_ATTEMPTS;
            }
        }
    }
}

