/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.rabbitmq.client.Channel;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.shared.util.impl.ApproximateTime;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RabbitOutputStream
extends OutputStream {
    private static final Logger logger = Logger.getLogger(RabbitOutputStream.class.getName());
    static final byte[] TERMINATION_COMMAND;
    public static final Duration DURATION_AFTER_TO_SYNC_DATA_TO_CHANNEL_AS_MILLIS;
    private static final long DURATION_TO_PAUSE_SYNCER_THREAD_AS_MILLIS = 1000L;
    private final Channel channel;
    private final String queueName;
    private boolean closed;
    private TimePoint timeLastDataHasBeenReceived;
    private int count;
    private final byte[] streamBuffer;

    static {
        byte[] byArray = new byte[12];
        byArray[0] = 2;
        byArray[1] = 6;
        byArray[3] = 4;
        byArray[4] = 1;
        byArray[5] = 9;
        byArray[6] = 8;
        byArray[7] = 2;
        byArray[9] = 1;
        byArray[10] = 4;
        byArray[11] = 2;
        TERMINATION_COMMAND = byArray;
        DURATION_AFTER_TO_SYNC_DATA_TO_CHANNEL_AS_MILLIS = new MillisecondsDurationImpl(5000L);
    }

    public RabbitOutputStream(int messageSizeInBytes, Channel channel, String queueName, boolean syncAfterTimeout) throws IOException {
        this.streamBuffer = new byte[messageSizeInBytes];
        this.count = 0;
        this.channel = channel;
        this.queueName = channel.queueDeclare(queueName, false, false, false, null).getQueue();
        this.closed = false;
        if (syncAfterTimeout) {
            new Thread("Timeout syncer for " + this.getClass().getSimpleName() + " on channel " + channel){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!RabbitOutputStream.this.closed) {
                        RabbitOutputStream rabbitOutputStream = RabbitOutputStream.this;
                        synchronized (rabbitOutputStream) {
                            if (RabbitOutputStream.this.timeLastDataHasBeenReceived != null) {
                                TimePoint approximateNow = ApproximateTime.approximateNow();
                                if (RabbitOutputStream.this.timeLastDataHasBeenReceived.until(approximateNow).compareTo((Object)DURATION_AFTER_TO_SYNC_DATA_TO_CHANNEL_AS_MILLIS) > 0) {
                                    try {
                                        RabbitOutputStream.this.sendBuffer();
                                        RabbitOutputStream.this.timeLastDataHasBeenReceived = ApproximateTime.approximateNow();
                                    }
                                    catch (IOException e) {
                                        logger.log(Level.INFO, "Exception trying to send message. Aborting.", e);
                                        break;
                                    }
                                }
                            }
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
        }
    }

    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        assert (this.count < this.streamBuffer.length);
        if (this.closed) {
            throw new IOException("This stream has been closed by an earlier operation.");
        }
        this.streamBuffer[this.count++] = (byte)b;
        if (this.count == this.streamBuffer.length) {
            this.sendBuffer();
        }
        this.timeLastDataHasBeenReceived = ApproximateTime.approximateNow();
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public void flush() throws IOException {
        this.sendBuffer();
    }

    private void finish() throws IOException {
        this.sendBuffer();
        this.channel.basicPublish("", this.queueName, null, TERMINATION_COMMAND);
    }

    private synchronized void sendBuffer() throws IOException {
        block3: {
            try {
                if (this.count <= 0) break block3;
                if (this.channel != null && this.channel.isOpen()) {
                    byte[] message = RabbitOutputStream.startsWithTerminationCommand(this.streamBuffer, this.count) ? new byte[this.count + 1] : new byte[this.count];
                    System.arraycopy(this.streamBuffer, 0, message, 0, this.count);
                    this.channel.basicPublish("", this.queueName, null, message);
                    this.count = 0;
                    break block3;
                }
                this.closed = true;
                throw new IOException("AMPQ Channel seems to be closed!");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "IOException while sending data to RabbitMQ queue " + this.queueName, e);
                throw e;
            }
        }
    }

    static boolean startsWithTerminationCommand(byte[] bytes, int count) {
        boolean result = true;
        if (count < TERMINATION_COMMAND.length) {
            result = false;
        } else {
            int i = 0;
            while (i < TERMINATION_COMMAND.length && result) {
                result = bytes[i] == TERMINATION_COMMAND[i];
                ++i;
            }
        }
        return result;
    }
}

