/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.ReplicablesProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.StreamSupport;

public abstract class AbstractReplicablesProvider
implements ReplicablesProvider {
    private final Set<ReplicablesProvider.ReplicableLifeCycleListener> listeners = new HashSet<ReplicablesProvider.ReplicableLifeCycleListener>();

    public void addReplicableLifeCycleListener(ReplicablesProvider.ReplicableLifeCycleListener listener) {
        this.listeners.add(listener);
    }

    public void removeReplicableLifeCycleListener(ReplicablesProvider.ReplicableLifeCycleListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyReplicableLifeCycleListenersAboutReplicableAdded(Replicable<?, ?> replicable) {
        for (ReplicablesProvider.ReplicableLifeCycleListener listener : this.listeners) {
            listener.replicableAdded(replicable);
        }
    }

    protected void notifyReplicableLifeCycleListenersAboutReplicableRemoved(String replicableIdAsString) {
        for (ReplicablesProvider.ReplicableLifeCycleListener listener : this.listeners) {
            listener.replicableRemoved(replicableIdAsString);
        }
    }

    public Replicable<?, ?> getReplicable(String replicableIdAsString, boolean wait) {
        return StreamSupport.stream(this.getReplicables().spliterator(), false).filter(r -> r.getId().toString().equals(replicableIdAsString)).findAny().orElse(null);
    }
}

