/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.racelog.tracking.impl;

import com.sap.sailing.domain.persistence.FieldNames;
import com.sap.sailing.domain.persistence.racelog.tracking.FixMongoHandler;
import com.sap.sailing.shared.persistence.device.DeviceIdentifierMongoHandler;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.Timed;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.TypeBasedServiceFinder;
import org.bson.Document;

abstract class MongoFixHandler {
    protected final TypeBasedServiceFinder<FixMongoHandler<?>> fixServiceFinder;
    protected final TypeBasedServiceFinder<DeviceIdentifierMongoHandler> deviceServiceFinder;

    public MongoFixHandler(TypeBasedServiceFinder<FixMongoHandler<?>> fixServiceFinder, TypeBasedServiceFinder<DeviceIdentifierMongoHandler> deviceServiceFinder) {
        this.fixServiceFinder = fixServiceFinder;
        this.deviceServiceFinder = deviceServiceFinder;
    }

    protected <FixT extends Timed> FixMongoHandler<FixT> findService(String type) {
        return (FixMongoHandler)this.fixServiceFinder.findService(type);
    }

    protected <T extends Timed> T loadFix(Document object) throws TransformationException, NoCorrespondingServiceRegisteredException {
        String type = (String)object.get((Object)FieldNames.GPSFIX_TYPE.name());
        Document fixObject = (Document)object.get((Object)FieldNames.GPSFIX.name());
        return (T)((Timed)this.findService(type).transformBack(fixObject));
    }

    protected <FixT extends Timed> Document storeFixToDocument(Document entry, FixT fix) throws TransformationException {
        String type = fix.getClass().getName();
        FixMongoHandler<FixT> mongoHandler = this.findService(type);
        Object fixObject = mongoHandler.transformForth(fix);
        entry.append(FieldNames.GPSFIX_TYPE.name(), (Object)type).append(FieldNames.GPSFIX.name(), fixObject);
        return entry;
    }
}

