/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.impl;

import com.mongodb.MongoException;
import com.mongodb.client.MongoDatabase;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.MongoWindStore;
import com.sap.sailing.domain.persistence.impl.CollectionNames;
import com.sap.sailing.domain.persistence.impl.MongoWindListener;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindListener;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.impl.EmptyWindStore;
import com.sap.sse.mongodb.MongoDBService;
import java.net.UnknownHostException;
import java.util.Map;

public class MongoWindStoreImpl
extends EmptyWindStore
implements MongoWindStore {
    private final transient MongoDatabase db;
    private final MongoObjectFactory mongoObjectFactory;
    private final DomainObjectFactory domainObjectFactory;

    public MongoWindStoreImpl(MongoDatabase db, MongoObjectFactory mongoObjectFactory, DomainObjectFactory domainObjectFactory) throws UnknownHostException, MongoException {
        this.db = db;
        this.mongoObjectFactory = mongoObjectFactory;
        this.domainObjectFactory = domainObjectFactory;
    }

    private Object readResolve() throws UnknownHostException, MongoException {
        return new MongoWindStoreImpl(MongoDBService.INSTANCE.getDB(), this.mongoObjectFactory, this.domainObjectFactory);
    }

    public WindTrack getWindTrack(String regattaName, TrackedRace trackedRace, WindSource windSource, long millisecondsOverWhichToAverage, long delayForWindEstimationCacheInvalidation) {
        WindTrack result;
        if (windSource.canBeStored()) {
            result = this.domainObjectFactory.loadWindTrack(regattaName, trackedRace.getRace(), windSource, millisecondsOverWhichToAverage);
            result.addListener((WindListener)new MongoWindListener(trackedRace, regattaName, windSource, this.mongoObjectFactory, this.db));
        } else {
            result = super.getWindTrack(regattaName, trackedRace, windSource, millisecondsOverWhichToAverage, delayForWindEstimationCacheInvalidation);
        }
        return result;
    }

    public Map<? extends WindSource, ? extends WindTrack> loadWindTracks(String regattaName, TrackedRace trackedRace, long millisecondsOverWhichToAverageWind) {
        Map<? extends WindSource, ? extends WindTrack> result = this.domainObjectFactory.loadWindTracks(regattaName, trackedRace.getRace(), millisecondsOverWhichToAverageWind);
        for (Map.Entry<? extends WindSource, ? extends WindTrack> e : result.entrySet()) {
            e.getValue().addListener((WindListener)new MongoWindListener(trackedRace, regattaName, e.getKey(), this.mongoObjectFactory, this.db));
        }
        return result;
    }

    public void clear() {
        this.db.getCollection(CollectionNames.WIND_TRACKS.name()).drop();
    }
}

