/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.impl;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.impl.MongoObjectFactoryImpl;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindListener;
import java.util.ArrayList;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoWindListener
implements WindListener {
    private final TrackedRace trackedRace;
    private final String regattaName;
    private final WindSource windSource;
    private final MongoObjectFactoryImpl mongoObjectFactory;
    private final MongoCollection<Document> windTracksCollection;

    public MongoWindListener(TrackedRace trackedRace, String regattaName, WindSource windSource, MongoObjectFactory mongoObjectFactory, MongoDatabase database) {
        this.regattaName = regattaName;
        this.trackedRace = trackedRace;
        this.windSource = windSource;
        this.mongoObjectFactory = (MongoObjectFactoryImpl)mongoObjectFactory;
        this.windTracksCollection = this.mongoObjectFactory.getWindTrackCollection();
    }

    public void windDataReceived(Wind wind) {
        Document windTrackEntry = this.createWindFixDocument(wind);
        this.windTracksCollection.withWriteConcern(WriteConcern.UNACKNOWLEDGED).insertOne((Object)windTrackEntry);
    }

    private Document createWindFixDocument(Wind wind) {
        Document windTrackEntry = this.mongoObjectFactory.storeWindTrackEntry(this.trackedRace.getRace(), this.regattaName, this.windSource, wind);
        return windTrackEntry;
    }

    public void windDataReceived(Iterable<Wind> winds) {
        ArrayList<Document> windTrackEntries = new ArrayList<Document>();
        for (Wind wind : winds) {
            windTrackEntries.add(this.createWindFixDocument(wind));
        }
        this.windTracksCollection.withWriteConcern(WriteConcern.UNACKNOWLEDGED).insertMany(windTrackEntries);
    }

    public void windDataRemoved(Wind wind) {
        Document windTrackEntry = this.mongoObjectFactory.storeWindTrackEntry(this.trackedRace.getRace(), this.regattaName, this.windSource, wind);
        this.windTracksCollection.deleteOne((Bson)windTrackEntry);
    }

    public void windAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
    }
}

