/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.aiagent.persistence.impl;

import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.sap.sailing.aiagent.persistence.MongoObjectFactory;
import com.sap.sailing.aiagent.persistence.impl.CollectionNames;
import com.sap.sailing.aiagent.persistence.impl.FieldNames;
import com.sap.sse.aicore.Credentials;
import com.sap.sse.aicore.CredentialsParser;
import com.sap.sse.common.Util;
import java.util.UUID;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoObjectFactoryImpl
implements MongoObjectFactory {
    private final MongoCollection<Document> eventsToCommentCollection;
    private final MongoCollection<Document> credentialsCollection;

    public MongoObjectFactoryImpl(MongoDatabase db) {
        this.eventsToCommentCollection = MongoObjectFactoryImpl.getOrCreateEventsToCommentCollection(db);
        this.credentialsCollection = MongoObjectFactoryImpl.getOrCreateCredentialsCollection(db);
    }

    static MongoCollection<Document> getOrCreateEventsToCommentCollection(MongoDatabase database) {
        MongoCollection eventsToCommentCollection = database.getCollection(CollectionNames.AIAGENT_EVENTS_TO_COMMENT.name());
        return eventsToCommentCollection;
    }

    static MongoCollection<Document> getOrCreateCredentialsCollection(MongoDatabase database) {
        MongoCollection credentialsCollection = database.getCollection(CollectionNames.AIAGENT_CREDENTIALS.name());
        return credentialsCollection;
    }

    @Override
    public void clear(ClientSession clientSessionOrNull) {
        if (clientSessionOrNull == null) {
            this.eventsToCommentCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).drop();
        } else {
            this.eventsToCommentCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).drop(clientSessionOrNull);
        }
    }

    @Override
    public void addEventToComment(UUID eventId, ClientSession clientSessionOrNull) {
        Document document = new Document(FieldNames.AIAGENT_EVENTS_TO_COMMENT_EVENT_ID.name(), (Object)eventId.toString());
        if (clientSessionOrNull == null) {
            this.eventsToCommentCollection.insertOne((Object)document);
        } else {
            this.eventsToCommentCollection.insertOne(clientSessionOrNull, (Object)document);
        }
    }

    @Override
    public void removeEventToComment(UUID eventId, ClientSession clientSessionOrNull) {
        Document filter = new Document(FieldNames.AIAGENT_EVENTS_TO_COMMENT_EVENT_ID.name(), (Object)eventId.toString());
        if (clientSessionOrNull == null) {
            this.eventsToCommentCollection.deleteOne((Bson)filter);
        } else {
            this.eventsToCommentCollection.deleteOne(clientSessionOrNull, (Bson)filter);
        }
    }

    @Override
    public void updateCredentials(Credentials credentials, ClientSession clientSessionOrNull) {
        if (clientSessionOrNull == null) {
            this.credentialsCollection.drop();
        } else {
            this.credentialsCollection.drop(clientSessionOrNull);
        }
        if (credentials != null) {
            Util.Pair credentialsAsEncodedStringAndSalt = CredentialsParser.create().getAsEncodedString(credentials);
            Document credentialsDocument = new Document().append(FieldNames.AIAGENT_CREDENTIALS_ENCODED_AS_STRING.name(), credentialsAsEncodedStringAndSalt.getA()).append(FieldNames.AIAGENT_CRETENTIALS_SALT.name(), credentialsAsEncodedStringAndSalt.getB());
            if (clientSessionOrNull == null) {
                this.credentialsCollection.insertOne((Object)credentialsDocument);
            } else {
                this.credentialsCollection.insertOne(clientSessionOrNull, (Object)credentialsDocument);
            }
        }
    }
}

