/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.hypothesis;

import smile.math.special.Gamma;

public class ChiSqTest {
    public double df;
    public double chisq;
    public double pvalue;

    private ChiSqTest(double chisq, double df, double pvalue) {
        this.chisq = chisq;
        this.df = df;
        this.pvalue = pvalue;
    }

    public static ChiSqTest test(int[] bins, double[] prob) {
        return ChiSqTest.test(bins, prob, 1);
    }

    public static ChiSqTest test(int[] bins, double[] prob, int constraints) {
        int nbins = bins.length;
        int df = nbins - constraints;
        int n = 0;
        for (int i = 0; i < nbins; ++i) {
            n += bins[i];
        }
        double chisq = 0.0;
        for (int j = 0; j < nbins; ++j) {
            if (prob[j] < 0.0 || prob[j] > 1.0 || prob[j] == 0.0 && bins[j] > 0) {
                throw new IllegalArgumentException("Bad expected number");
            }
            if (prob[j] == 0.0 && bins[j] == 0) {
                --df;
                continue;
            }
            double nj = (double)n * prob[j];
            double temp = (double)bins[j] - nj;
            chisq += temp * temp / nj;
        }
        double p = Gamma.regularizedUpperIncompleteGamma(0.5 * (double)df, 0.5 * chisq);
        return new ChiSqTest(chisq, df, p);
    }

    public static ChiSqTest test(int[] bins1, int[] bins2) {
        return ChiSqTest.test(bins1, bins2, 1);
    }

    public static ChiSqTest test(int[] bins1, int[] bins2, int constraints) {
        if (bins1.length != bins2.length) {
            throw new IllegalArgumentException("Input vectors have different size");
        }
        int nbins = bins1.length;
        int df = nbins - constraints;
        double chisq = 0.0;
        for (int j = 0; j < nbins; ++j) {
            if (bins1[j] == 0 && bins2[j] == 0) {
                --df;
                continue;
            }
            double temp = bins1[j] - bins2[j];
            chisq += temp * temp / (double)(bins1[j] + bins2[j]);
        }
        double p = Gamma.regularizedUpperIncompleteGamma(0.5 * (double)df, 0.5 * chisq);
        return new ChiSqTest(chisq, df, p);
    }
}

