/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.kernel.MercerKernel;

public class ThinPlateSplineKernel
implements MercerKernel<double[]> {
    private static final long serialVersionUID = 1L;
    private double sigma;

    public ThinPlateSplineKernel(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma is not positive.");
        }
        this.sigma = sigma;
    }

    public String toString() {
        return String.format("Thin Plate Spline Kernel (\u02e0 = %.4f)", this.sigma);
    }

    @Override
    public double k(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        double d = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double dxy = x[i] - y[i];
            d += dxy * dxy;
        }
        return d / (this.sigma * this.sigma) * Math.log(Math.sqrt(d) / this.sigma);
    }
}

