/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.kernel.MercerKernel;

public class BinarySparseGaussianKernel
implements MercerKernel<int[]> {
    private static final long serialVersionUID = 1L;
    private double gamma;

    public BinarySparseGaussianKernel(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma is not positive.");
        }
        this.gamma = 0.5 / (sigma * sigma);
    }

    public String toString() {
        return String.format("Sparse Binary Gaussian Kernel (\u02e0 = %.4f)", Math.sqrt(0.5 / this.gamma));
    }

    @Override
    public double k(int[] x, int[] y) {
        double d = 0.0;
        int p1 = 0;
        int p2 = 0;
        while (p1 < x.length && p2 < y.length) {
            int i1 = x[p1];
            int i2 = y[p2];
            if (i1 == i2) {
                ++p1;
                ++p2;
                continue;
            }
            if (i1 > i2) {
                d += 1.0;
                ++p2;
                continue;
            }
            d += 1.0;
            ++p1;
        }
        d += (double)(x.length - p1);
        return Math.exp(-this.gamma * (d += (double)(y.length - p2)));
    }
}

