/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.windestimation;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.CompetitorAndBoat;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.base.impl.SpeedWithBearingWithConfidenceImpl;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.polars.windestimation.ManeuverClassification;
import com.sap.sailing.polars.windestimation.ScalableBearingAndScalableDouble;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.text.SimpleDateFormat;

public class ManeuverClassificationImpl
implements ManeuverClassification {
    private final String competitorName;
    private final TimePoint timePoint;
    private final Position position;
    private final double maneuverAngleDeg;
    private final SpeedWithBearing speedAtManeuverStart;
    private final Bearing middleManeuverCourse;
    private final Distance maneuverLossDistanceLost;
    protected Double[] likelihoodPerManeuverType;
    private ScalableBearingAndScalableDouble scalableMiddleManeuverCourseAndManeuverAngleDegCache;
    private final PolarDataService polarService;
    private final BoatClass boatClass;

    public ManeuverClassificationImpl(String competitorName, BoatClass boatClass, TimePoint timePoint, Position position, double maneuverAngleDeg, SpeedWithBearing speedAtManeuverStart, Bearing middleManeuverCourse, Distance maneuverLossDistanceLost, PolarDataService polarService) {
        this.competitorName = competitorName;
        this.timePoint = timePoint;
        this.position = position;
        this.maneuverAngleDeg = maneuverAngleDeg;
        this.speedAtManeuverStart = speedAtManeuverStart;
        this.middleManeuverCourse = middleManeuverCourse;
        this.maneuverLossDistanceLost = maneuverLossDistanceLost;
        this.polarService = polarService;
        this.boatClass = boatClass;
        this.likelihoodPerManeuverType = new Double[ManeuverType.values().length];
    }

    public ManeuverClassificationImpl(CompetitorAndBoat competitorAndBoat, Maneuver maneuver, PolarDataService polarService) {
        this.boatClass = competitorAndBoat.getBoat().getBoatClass();
        this.polarService = polarService;
        this.competitorName = competitorAndBoat.getCompetitor().getName();
        this.timePoint = maneuver.getTimePoint();
        this.position = maneuver.getPosition();
        this.maneuverAngleDeg = maneuver.getDirectionChangeInDegrees();
        this.speedAtManeuverStart = maneuver.getSpeedWithBearingBefore();
        this.middleManeuverCourse = maneuver.getSpeedWithBearingBefore().getBearing().middle(maneuver.getSpeedWithBearingAfter().getBearing());
        this.maneuverLossDistanceLost = maneuver.getManeuverLoss() == null ? null : maneuver.getManeuverLoss().getProjectedDistanceLost();
        this.likelihoodPerManeuverType = new Double[ManeuverType.values().length];
    }

    @Override
    public String getCompetitorName() {
        return this.competitorName;
    }

    @Override
    public BoatClass getBoatClass() {
        return this.boatClass;
    }

    @Override
    public TimePoint getTimePoint() {
        return this.timePoint;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public double getManeuverAngleDeg() {
        return this.maneuverAngleDeg;
    }

    public SpeedWithBearing getSpeedAtManeuverStart() {
        return this.speedAtManeuverStart;
    }

    @Override
    public Bearing getMiddleManeuverCourse() {
        return this.middleManeuverCourse;
    }

    @Override
    public ScalableBearingAndScalableDouble getScalableMiddleManeuverCourseAndManeuverAngleDeg() {
        if (this.scalableMiddleManeuverCourseAndManeuverAngleDegCache == null) {
            this.scalableMiddleManeuverCourseAndManeuverAngleDegCache = new ScalableBearingAndScalableDouble(this.getMiddleManeuverCourse(), this.getManeuverAngleDeg());
        }
        return this.scalableMiddleManeuverCourseAndManeuverAngleDegCache;
    }

    @Override
    public SpeedWithBearingWithConfidence<Void> getEstimatedWindSpeedAndBearing(ManeuverType maneuverType) {
        SpeedWithBearingWithConfidenceImpl result;
        Util.Pair likelihoodAndTWSBasedOnSpeedAndAngle = this.polarService.getManeuverLikelihoodAndTwsTwa(this.getBoatClass(), (Speed)this.getSpeedAtManeuverStart(), this.getManeuverAngleDeg(), maneuverType);
        if (likelihoodAndTWSBasedOnSpeedAndAngle.getB() == null) {
            result = null;
        } else {
            Bearing bearing;
            double confidence = ((SpeedWithBearingWithConfidence)likelihoodAndTWSBasedOnSpeedAndAngle.getB()).getConfidence() * (Double)likelihoodAndTWSBasedOnSpeedAndAngle.getA();
            SpeedWithBearing speed = ((SpeedWithBearingWithConfidence)likelihoodAndTWSBasedOnSpeedAndAngle.getB()).getObject();
            switch (maneuverType) {
                case TACK: {
                    bearing = this.getMiddleManeuverCourse().reverse();
                    break;
                }
                case JIBE: {
                    bearing = this.getMiddleManeuverCourse();
                    break;
                }
                default: {
                    throw new IllegalStateException("Found leg type " + maneuverType + " but can only handle " + LegType.UPWIND.name() + " and " + LegType.DOWNWIND.name());
                }
            }
            result = new SpeedWithBearingWithConfidenceImpl((SpeedWithBearing)new KnotSpeedWithBearingImpl(speed.getKnots(), bearing), confidence, null);
        }
        return result;
    }

    public Distance getManeuverLossDistanceLost() {
        return this.maneuverLossDistanceLost;
    }

    @Override
    public double getLikelihoodForManeuverType(ManeuverType maneuverType) {
        if (this.likelihoodPerManeuverType[maneuverType.ordinal()] == null) {
            Util.Pair maneuverLikelihoodAndTwsTwa = this.polarService.getManeuverLikelihoodAndTwsTwa(this.getBoatClass(), (Speed)this.getSpeedAtManeuverStart(), this.getManeuverAngleDeg(), maneuverType);
            this.likelihoodPerManeuverType[maneuverType.ordinal()] = (Double)maneuverLikelihoodAndTwsTwa.getA();
        }
        return this.likelihoodPerManeuverType[maneuverType.ordinal()];
    }

    public String toString() {
        return this.format(null);
    }

    @Override
    public String format(String id) {
        SimpleDateFormat df = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
        String prefix = String.valueOf(this.competitorName) + "\t" + df.format(this.getTimePoint().asDate()) + "\t" + this.getManeuverAngleDeg() + "\t" + this.getSpeedAtManeuverStart().getKnots() + "\t" + this.getSpeedAtManeuverStart().getBearing().getDegrees();
        StringBuilder result = new StringBuilder();
        if (id != null) {
            result.append("ID");
            result.append(id);
            result.append('\t');
        }
        result.append(prefix);
        result.append("\t");
        result.append(this.getMiddleManeuverCourse().getDegrees());
        result.append("\t");
        result.append(this.getManeuverLossDistanceLost() == null ? 0.0 : this.getManeuverLossDistanceLost().getMeters());
        result.append("\t");
        result.append(this.getLikelihoodForManeuverType(ManeuverType.TACK));
        result.append("\t");
        result.append(this.getLikelihoodForManeuverType(ManeuverType.JIBE));
        return result.toString();
    }
}

