/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.regression.impl;

import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.polars.regression.IncrementalLeastSquares;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.MatrixVisitorException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SingularMatrixException;

public class IncrementalAnyOrderLeastSquaresImpl
implements IncrementalLeastSquares {
    private static final long serialVersionUID = -5282614133220702724L;
    private double[][] matrixOfXSums;
    private double[] vectorOfXYMultSums;
    private int polynomialOrder;
    private AtomicLong numberOfPointsAdded = new AtomicLong(0L);
    private AtomicBoolean functionNeedsUpdate = new AtomicBoolean(true);
    private transient NamedReentrantReadWriteLock lock = new NamedReentrantReadWriteLock("IncrementalLeastSquaresLock", false);
    private transient NamedReentrantReadWriteLock cacheLock = new NamedReentrantReadWriteLock("IncrementalLeastSquaresCacheLock", true);
    private PolynomialFunction cachedFunction;
    private final boolean hasIntercept;
    private final boolean useSymbollicInversionIfPossible;

    public IncrementalAnyOrderLeastSquaresImpl(double[][] matrixOfXSums, double[] vectorOfXYMultSums, int polynomialOrder, boolean hasIntercept, boolean useSymbollicInversionIfPossible, long numberOfPointsAdded) {
        this.hasIntercept = hasIntercept;
        this.polynomialOrder = polynomialOrder;
        this.useSymbollicInversionIfPossible = useSymbollicInversionIfPossible;
        this.matrixOfXSums = matrixOfXSums;
        this.vectorOfXYMultSums = vectorOfXYMultSums;
        this.numberOfPointsAdded.set(numberOfPointsAdded);
        this.functionNeedsUpdate.set(true);
    }

    public IncrementalAnyOrderLeastSquaresImpl(int polynomialOrder, boolean hasIntercept, boolean useSymbolicInversionIfPossible) {
        this.hasIntercept = hasIntercept;
        this.polynomialOrder = polynomialOrder;
        this.useSymbollicInversionIfPossible = useSymbolicInversionIfPossible;
        if (hasIntercept) {
            this.matrixOfXSums = new double[polynomialOrder + 1][polynomialOrder + 1];
            this.vectorOfXYMultSums = new double[polynomialOrder + 1];
        } else {
            this.matrixOfXSums = new double[polynomialOrder][polynomialOrder];
            this.vectorOfXYMultSums = new double[polynomialOrder];
        }
    }

    public IncrementalAnyOrderLeastSquaresImpl(int polynomialOrder) {
        this(polynomialOrder, true, true);
    }

    public IncrementalAnyOrderLeastSquaresImpl(int polynomialOrder, boolean hasIntercept) {
        this(polynomialOrder, hasIntercept, true);
    }

    @Override
    public void addData(double x, double y) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            this.numberOfPointsAdded.incrementAndGet();
            this.functionNeedsUpdate.set(true);
            int i = 0;
            while (!(this.hasIntercept ? i > this.polynomialOrder : i >= this.polynomialOrder)) {
                int powerI = this.hasIntercept ? i : i + 1;
                int n = i;
                this.vectorOfXYMultSums[n] = this.vectorOfXYMultSums[n] + y * Math.pow(x, powerI);
                int j = 0;
                while (!(this.hasIntercept ? j > this.polynomialOrder : j >= this.polynomialOrder)) {
                    int powerJ;
                    int n2 = powerJ = this.hasIntercept ? j : j + 1;
                    if (powerI == 0 && powerJ == 0) {
                        double[] dArray = this.matrixOfXSums[i];
                        int n3 = j;
                        dArray[n3] = dArray[n3] + 1.0;
                    } else {
                        double[] dArray = this.matrixOfXSums[i];
                        int n4 = j;
                        dArray[n4] = dArray[n4] + Math.pow(x, powerI + powerJ);
                    }
                    ++j;
                }
                ++i;
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public PolynomialFunction getOrCreatePolynomialFunction() throws NotEnoughDataHasBeenAddedException {
        PolynomialFunction resultFunction;
        if (!this.functionNeedsUpdate.get()) {
            LockUtil.lockForRead((NamedReentrantReadWriteLock)this.cacheLock);
            try {
                resultFunction = new PolynomialFunction(this.cachedFunction.getCoefficients());
            }
            finally {
                LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.cacheLock);
            }
        }
        if (this.numberOfPointsAdded.get() < 1L) {
            throw new NotEnoughDataHasBeenAddedException("No points have been added to the regression yet.");
        }
        resultFunction = this.numberOfPointsAdded.get() == 1L ? this.createConstantFunctionForOneDataPoint() : this.createEstimatingPolynomialFunction();
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.cacheLock);
        try {
            this.cachedFunction = new PolynomialFunction(resultFunction.getCoefficients());
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.cacheLock);
        }
        this.functionNeedsUpdate.set(false);
        return resultFunction;
    }

    private PolynomialFunction createEstimatingPolynomialFunction() throws NotEnoughDataHasBeenAddedException {
        RealVector vectorOfXYMultSumsCopy;
        RealMatrix matrixOfXSumsCopy;
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            matrixOfXSumsCopy = MatrixUtils.createRealMatrix((double[][])this.matrixOfXSums);
            vectorOfXYMultSumsCopy = MatrixUtils.createRealVector((double[])this.vectorOfXYMultSums);
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
        LeastSquaresInversionHelperType type = LeastSquaresInversionHelperType.getType(this.polynomialOrder, this.hasIntercept);
        RealMatrix inversedMatrix = null;
        if (this.useSymbollicInversionIfPossible && type != null) {
            inversedMatrix = type.inverseMatrix(matrixOfXSumsCopy);
        }
        if (inversedMatrix == null) {
            try {
                inversedMatrix = new LUDecompositionImpl(matrixOfXSumsCopy).getSolver().getInverse();
            }
            catch (SingularMatrixException singularMatrixException) {
                throw new NotEnoughDataHasBeenAddedException("Matrix singular, all x input equal?", (Throwable)singularMatrixException);
            }
        } else {
            NaNCheckerVisitor nanChecker = new NaNCheckerVisitor();
            inversedMatrix.walkInOptimizedOrder((RealMatrixPreservingVisitor)nanChecker);
            if (nanChecker.hasNaNEntry()) {
                throw new NotEnoughDataHasBeenAddedException("Matrix singular, all x input equal?");
            }
        }
        RealVector coeffs = inversedMatrix.operate(vectorOfXYMultSumsCopy);
        PolynomialFunction resultFunction = !this.hasIntercept ? this.createFunctionWithZeroIntercept(coeffs) : new PolynomialFunction(coeffs.toArray());
        return resultFunction;
    }

    private PolynomialFunction createFunctionWithZeroIntercept(RealVector coeffs) {
        double[] coeffsNoIntercept = coeffs.toArray();
        double[] coeffsWithZeroIntercept = new double[coeffsNoIntercept.length + 1];
        coeffsWithZeroIntercept[0] = 0.0;
        int i = 1;
        while (i < coeffsWithZeroIntercept.length) {
            coeffsWithZeroIntercept[i] = coeffsNoIntercept[i - 1];
            ++i;
        }
        PolynomialFunction resultFunction = new PolynomialFunction(coeffsWithZeroIntercept);
        return resultFunction;
    }

    private PolynomialFunction createConstantFunctionForOneDataPoint() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        double[] coeff = new double[1];
        try {
            coeff[0] = this.vectorOfXYMultSums[0];
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
        return new PolynomialFunction(coeff);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.lock = new NamedReentrantReadWriteLock("IncrementalLeastSquaresLock", false);
        this.cacheLock = new NamedReentrantReadWriteLock("IncrementalLeastSquaresCacheLock", true);
    }

    @Override
    public long getNumberOfAddedPoints() {
        return this.numberOfPointsAdded.get();
    }

    public double[][] getMatrixOfXSums() {
        return this.matrixOfXSums;
    }

    public double[] getVectorOfXYMultSums() {
        return this.vectorOfXYMultSums;
    }

    public int getPolynomialOrder() {
        return this.polynomialOrder;
    }

    public boolean isHasIntercept() {
        return this.hasIntercept;
    }

    public boolean isUseSymbollicInversionIfPossible() {
        return this.useSymbollicInversionIfPossible;
    }

    private static enum LeastSquaresInversionHelperType {
        CUBIC,
        CUBIC_NO_INTERCEPT;


        private RealMatrix inverseMatrix(RealMatrix realMatrix) {
            RealMatrix result = null;
            switch (this) {
                case CUBIC_NO_INTERCEPT: {
                    double[][] originDataCNI = realMatrix.getData();
                    double a = originDataCNI[0][0];
                    double b = originDataCNI[0][1];
                    double c = originDataCNI[0][2];
                    double d = originDataCNI[1][2];
                    double e = originDataCNI[2][2];
                    double[][] matrixDataCNI = new double[][]{{d * d - c * e, b * e - c * d, c * c - b * d}, {b * e - c * d, c * c - a * e, a * d - b * c}, {c * c - b * d, a * d - b * c, b * b - a * c}};
                    RealMatrix intermediateMatrixCNI = MatrixUtils.createRealMatrix((double[][])matrixDataCNI);
                    double factorCNI = 1.0 / (-a * c * e + a * d * d + b * b * e - 2.0 * b * c * d + c * c * c);
                    result = intermediateMatrixCNI.scalarMultiply(factorCNI);
                    break;
                }
                case CUBIC: {
                    double[][] originDataC = realMatrix.getData();
                    double n = originDataC[0][0];
                    double a = originDataC[0][1];
                    double b = originDataC[0][2];
                    double c = originDataC[0][3];
                    double d = originDataC[1][3];
                    double e = originDataC[2][3];
                    double f = originDataC[3][3];
                    double[][] matrixDataC = new double[][]{{-d * d * d + 2.0 * c * e * d + b * f * d - b * e * e - c * c * f, -e * c * c + d * d * c + b * f * c + a * e * e - b * d * e - a * d * f, -f * b * b + d * d * b + c * e * b - c * c * d - a * d * e + a * c * f, c * c * c - 2.0 * b * d * c - a * e * c + a * d * d + b * b * e}, {-e * c * c + d * d * c + b * f * c + a * e * e - b * d * e - a * d * f, -f * b * b + 2.0 * c * e * b - c * c * d - e * e * n + d * f * n, c * c * c - b * d * c - a * e * c - f * n * c + a * b * f + d * e * n, d * b * b - c * c * b - a * e * b + a * c * d - d * d * n + c * e * n}, {-f * b * b + d * d * b + c * e * b - c * c * d - a * d * e + a * c * f, c * c * c - b * d * c - a * e * c - f * n * c + a * b * f + d * e * n, -f * a * a + 2.0 * c * d * a - b * c * c - d * d * n + b * f * n, e * a * a - c * c * a - b * d * a + b * b * c + c * d * n - b * e * n}, {c * c * c - 2.0 * b * d * c - a * e * c + a * d * d + b * b * e, d * b * b - c * c * b - a * e * b + a * c * d - d * d * n + c * e * n, e * a * a - c * c * a - b * d * a + b * b * c + c * d * n - b * e * n, -b * b * b + 2.0 * a * c * b + d * n * b - a * a * d - c * c * n}};
                    RealMatrix intermediateMatrixC = MatrixUtils.createRealMatrix((double[][])matrixDataC);
                    double factorC = 1.0 / (-a * a * d * f + a * a * e * e + 2.0 * c * (a * (b * f + d * d) + e * (b * b + d * n)) - c * c * (2.0 * a * e + 3.0 * b * d + f * n) + b * (-2.0 * a * d * e + d * f * n + e * e * -n) - b * b * b * f + b * b * d * d + c * c * c * c - d * d * d * n);
                    result = intermediateMatrixC.scalarMultiply(factorC);
                    break;
                }
            }
            return result;
        }

        private static LeastSquaresInversionHelperType getType(int order, boolean hasIntercept) {
            LeastSquaresInversionHelperType result = null;
            switch (order) {
                case 3: {
                    result = hasIntercept ? CUBIC : CUBIC_NO_INTERCEPT;
                }
            }
            return result;
        }
    }

    private class NaNCheckerVisitor
    implements RealMatrixPreservingVisitor {
        private boolean hasNaNEntry = false;

        private NaNCheckerVisitor() {
        }

        public void visit(int arg0, int arg1, double arg2) throws MatrixVisitorException {
            if (Double.isNaN(arg2)) {
                this.hasNaNEntry = true;
            }
        }

        public void start(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        }

        public double end() {
            return 0.0;
        }

        public boolean hasNaNEntry() {
            return this.hasNaNEntry;
        }
    }
}

