/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.mining;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.base.impl.SpeedWithBearingWithConfidenceImpl;
import com.sap.sailing.domain.base.impl.SpeedWithConfidenceImpl;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.PolarSheetGenerationSettings;
import com.sap.sailing.domain.common.PolarSheetsData;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.WindSpeedStepping;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.PolarSheetsDataImpl;
import com.sap.sailing.domain.common.impl.PolarSheetsHistogramDataImpl;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.polars.PolarsChangedListener;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.polars.impl.CubicEquation;
import com.sap.sailing.polars.mining.AbstractEnrichingProcessor;
import com.sap.sailing.polars.mining.CubicRegressionPerCourseProcessor;
import com.sap.sailing.polars.mining.GPSFixMovingWithOriginInfo;
import com.sap.sailing.polars.mining.GPSFixMovingWithPolarContext;
import com.sap.sailing.polars.mining.PolarDataDimensionCollectionFactory;
import com.sap.sailing.polars.mining.PolarFixFilterCriteria;
import com.sap.sailing.polars.mining.SpeedRegressionPerAngleClusterProcessor;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.datamining.components.FilterCriterion;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.data.ClusterGroup;
import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.functions.ParameterProvider;
import com.sap.sse.datamining.impl.components.ParallelFilteringProcessor;
import com.sap.sse.datamining.impl.components.ParallelMultiDimensionsValueNestingGroupingProcessor;
import com.sap.sse.datamining.impl.functions.SimpleParameterizedFunction;
import com.sap.sse.util.ThreadPoolUtil;
import com.sap.sse.util.impl.ThreadFactoryWithPriority;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;

public class PolarDataMiner {
    private static final int EXECUTOR_QUEUE_SIZE = 100;
    private static final int THREAD_POOL_SIZE = ThreadPoolUtil.INSTANCE.getReasonableThreadPoolSize();
    private final ThreadPoolExecutor executor = this.createExecutor();
    private static final ScheduledExecutorService processRacesThatFinishedLoadingExecutor = ThreadPoolUtil.INSTANCE.createBackgroundTaskThreadPoolExecutor(1, String.valueOf(PolarDataMiner.class.getName()) + " processRacesThatFinishedLoadingExecutor");
    private final Map<BoatClass, AtomicInteger> stats = new ConcurrentHashMap<BoatClass, AtomicInteger>();
    private final Queue<GPSFixMovingWithOriginInfo> fixQueue = new ConcurrentLinkedQueue<GPSFixMovingWithOriginInfo>();
    private static final Logger logger = Logger.getLogger(PolarDataMiner.class.getSimpleName());
    private final ConcurrentMap<BoatClass, Set<PolarsChangedListener>> listeners = new ConcurrentHashMap<BoatClass, Set<PolarsChangedListener>>();
    private ParallelFilteringProcessor<GPSFixMovingWithOriginInfo> preFilteringProcessor;
    private final PolarSheetGenerationSettings backendPolarSheetGenerationSettings;
    private final CubicRegressionPerCourseProcessor cubicRegressionPerCourseProcessor;
    private final SpeedRegressionPerAngleClusterProcessor speedRegressionPerAngleClusterProcessor;
    private final ClusterGroup<Bearing> angleClusterGroup;

    private ThreadPoolExecutor createExecutor() {
        return new ThreadPoolExecutor(THREAD_POOL_SIZE, THREAD_POOL_SIZE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue(100), (ThreadFactory)new ThreadFactoryWithPriority(PolarDataMiner.class.getSimpleName(), 4, Boolean.valueOf(true))){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                GPSFixMovingWithOriginInfo fix;
                super.afterExecute(r, t);
                while (this.getQueue().size() < 10 && (fix = (GPSFixMovingWithOriginInfo)PolarDataMiner.this.fixQueue.poll()) != null) {
                    PolarDataMiner.this.preFilteringProcessor.processElement((Object)fix);
                }
            }
        };
    }

    public PolarDataMiner(PolarSheetGenerationSettings backendPolarSettings, CubicRegressionPerCourseProcessor cubicRegressionPerCourseProcessor, SpeedRegressionPerAngleClusterProcessor speedRegressionPerAngleClusterProcessor, ClusterGroup<Bearing> angleClusterGroup) {
        cubicRegressionPerCourseProcessor.setListeners(this.listeners);
        speedRegressionPerAngleClusterProcessor.setListeners(this.listeners);
        this.backendPolarSheetGenerationSettings = backendPolarSettings;
        this.cubicRegressionPerCourseProcessor = cubicRegressionPerCourseProcessor;
        this.speedRegressionPerAngleClusterProcessor = speedRegressionPerAngleClusterProcessor;
        this.angleClusterGroup = angleClusterGroup;
        try {
            this.setUpWorkflow();
        }
        catch (ClassCastException | NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void setUpWorkflow() throws ClassCastException, NoSuchMethodException, SecurityException {
        ArrayList<CubicRegressionPerCourseProcessor> regressionPerCourseGrouperResultReceivers = new ArrayList<CubicRegressionPerCourseProcessor>();
        regressionPerCourseGrouperResultReceivers.add(this.cubicRegressionPerCourseProcessor);
        ArrayList<SimpleParameterizedFunction> parameterizedDimensionsForCubicRegression = new ArrayList<SimpleParameterizedFunction>();
        for (Function<?> function : PolarDataDimensionCollectionFactory.getCubicRegressionPerCourseClusterKeyDimensions()) {
            parameterizedDimensionsForCubicRegression.add(new SimpleParameterizedFunction(function, ParameterProvider.NULL));
        }
        ParallelMultiDimensionsValueNestingGroupingProcessor cubicRegressionPerCourseGroupingProcessor = new ParallelMultiDimensionsValueNestingGroupingProcessor(GPSFixMovingWithPolarContext.class, (ExecutorService)this.executor, regressionPerCourseGrouperResultReceivers, parameterizedDimensionsForCubicRegression);
        ArrayList<SpeedRegressionPerAngleClusterProcessor> regressionPerAngleClusterGrouperResultReceivers = new ArrayList<SpeedRegressionPerAngleClusterProcessor>();
        regressionPerAngleClusterGrouperResultReceivers.add(this.speedRegressionPerAngleClusterProcessor);
        ArrayList<SimpleParameterizedFunction> parameterizedDimensionsForRegressionPerAngleCluster = new ArrayList<SimpleParameterizedFunction>();
        for (Function<?> function : PolarDataDimensionCollectionFactory.getSpeedRegressionPerAngleClusterClusterKeyDimensions()) {
            parameterizedDimensionsForRegressionPerAngleCluster.add(new SimpleParameterizedFunction(function, ParameterProvider.NULL));
        }
        ParallelMultiDimensionsValueNestingGroupingProcessor regressionPerAngleClusterGroupingProcessor = new ParallelMultiDimensionsValueNestingGroupingProcessor(GPSFixMovingWithPolarContext.class, (ExecutorService)this.executor, regressionPerAngleClusterGrouperResultReceivers, parameterizedDimensionsForRegressionPerAngleCluster);
        ArrayList<ParallelMultiDimensionsValueNestingGroupingProcessor> filteringResultReceivers = new ArrayList<ParallelMultiDimensionsValueNestingGroupingProcessor>();
        filteringResultReceivers.add(cubicRegressionPerCourseGroupingProcessor);
        filteringResultReceivers.add(regressionPerAngleClusterGroupingProcessor);
        ParallelFilteringProcessor filteringProcessor = new ParallelFilteringProcessor(GPSFixMovingWithPolarContext.class, (ExecutorService)this.executor, filteringResultReceivers, (FilterCriterion)new PolarFixFilterCriteria(this.backendPolarSheetGenerationSettings.getPctOfLeadingCompetitorsToInclude()));
        List<Processor> enrichingResultReceivers = Arrays.asList(filteringProcessor);
        AbstractEnrichingProcessor<GPSFixMovingWithOriginInfo, GPSFixMovingWithPolarContext> enrichingProcessor = new AbstractEnrichingProcessor<GPSFixMovingWithOriginInfo, GPSFixMovingWithPolarContext>(GPSFixMovingWithOriginInfo.class, GPSFixMovingWithPolarContext.class, (ExecutorService)this.executor, enrichingResultReceivers){

            @Override
            protected GPSFixMovingWithPolarContext enrich(GPSFixMovingWithOriginInfo element) {
                GPSFixMovingWithPolarContext result = null;
                result = new GPSFixMovingWithPolarContext(element.getFix(), element.getTrackedRace(), element.getCompetitor(), (ClusterGroup<Bearing>)PolarDataMiner.this.angleClusterGroup);
                return result;
            }
        };
        List<Processor> preFilterResultReceivers = Arrays.asList(new Processor[]{enrichingProcessor});
        this.preFilteringProcessor = new ParallelFilteringProcessor(GPSFixMovingWithOriginInfo.class, (ExecutorService)this.executor, preFilterResultReceivers, (FilterCriterion)new FilterCriterion<GPSFixMovingWithOriginInfo>(){

            public boolean matches(GPSFixMovingWithOriginInfo element) {
                boolean result = false;
                if (PolarFixFilterCriteria.isInLeadingCompetitors(element.getTrackedRace(), element.getCompetitor(), PolarDataMiner.this.backendPolarSheetGenerationSettings.getPctOfLeadingCompetitorsToInclude())) {
                    result = true;
                    BoatClass boatClass = element.getBoat().getBoatClass();
                    AtomicInteger count = (AtomicInteger)PolarDataMiner.this.stats.get(boatClass);
                    if (count == null) {
                        count = new AtomicInteger(1);
                        PolarDataMiner.this.stats.put(boatClass, count);
                    } else {
                        count.getAndIncrement();
                    }
                }
                return result;
            }

            public Class<GPSFixMovingWithOriginInfo> getElementType() {
                return GPSFixMovingWithOriginInfo.class;
            }
        });
    }

    public void addFix(GPSFixMoving fix, Competitor competitor, TrackedRace trackedRace) {
        if (trackedRace.getStatus().getStatus() != TrackedRaceStatusEnum.LOADING) {
            GPSFixMovingWithOriginInfo fixWithOriginInfo = new GPSFixMovingWithOriginInfo(fix, trackedRace, competitor);
            this.processFix(trackedRace, fixWithOriginInfo);
        }
    }

    private void processFix(TrackedRace trackedRace, GPSFixMovingWithOriginInfo fixWithOriginInfo) {
        if (this.executor.getQueue().size() >= 10) {
            this.fixQueue.add(fixWithOriginInfo);
        } else {
            this.preFilteringProcessor.processElement((Object)fixWithOriginInfo);
        }
    }

    public boolean isCurrentlyActiveAndOrHasQueue() {
        boolean hasQueue;
        boolean isActive = this.executor.getActiveCount() > 0;
        boolean bl = hasQueue = this.executor.getQueue().size() > 0;
        return isActive || hasQueue;
    }

    public SpeedWithConfidence<Void> estimateBoatSpeed(BoatClass boatClass, Speed windSpeed, Bearing trueWindAngle) throws NotEnoughDataHasBeenAddedException {
        return this.speedRegressionPerAngleClusterProcessor.estimateBoatSpeed(boatClass, windSpeed, trueWindAngle);
    }

    public Util.Pair<List<Speed>, Double> estimateWindSpeeds(BoatClass boatClass, Speed boatSpeed, Bearing trueWindAngle) throws NotEnoughDataHasBeenAddedException {
        LegType legType = trueWindAngle.getDegrees() < 70.0 ? LegType.UPWIND : (trueWindAngle.getDegrees() < 120.0 ? LegType.REACHING : LegType.DOWNWIND);
        Set<SpeedWithBearingWithConfidence<Void>> resultSet = this.cubicRegressionPerCourseProcessor.estimateTrueWindSpeedAndAngleCandidates(boatClass, boatSpeed, legType, Tack.STARBOARD);
        double referenceTwsKnots = 10.0;
        if (!resultSet.isEmpty()) {
            double bestTwsKnots = Double.MAX_VALUE;
            for (SpeedWithBearingWithConfidence<Void> speedWithBearingWithConfidence : resultSet) {
                double twsKnots = speedWithBearingWithConfidence.getObject().getKnots();
                if (!(twsKnots > 2.0) || !(twsKnots < 20.0) || !(Math.abs(10.0 - twsKnots) < Math.abs(10.0 - bestTwsKnots))) continue;
                bestTwsKnots = twsKnots;
            }
            if (bestTwsKnots > 2.0 && bestTwsKnots < 20.0) {
                referenceTwsKnots = bestTwsKnots;
            }
        }
        return this.speedRegressionPerAngleClusterProcessor.estimateWindSpeeds(boatClass, boatSpeed, trueWindAngle, referenceTwsKnots);
    }

    public Set<SpeedWithBearingWithConfidence<Void>> estimateTrueWindSpeedAndAngleCandidates(BoatClass boatClass, Speed speedOverGround, LegType legType, Tack tack) {
        Set<SpeedWithBearingWithConfidence<Void>> resultSet = this.cubicRegressionPerCourseProcessor.estimateTrueWindSpeedAndAngleCandidates(boatClass, speedOverGround, legType, tack);
        if (resultSet.isEmpty()) {
            resultSet = this.getAverageTrueWindSpeedAndAngleCandidatesWithFallbackFunction(boatClass, speedOverGround, legType, tack);
        }
        return resultSet;
    }

    private Set<SpeedWithBearingWithConfidence<Void>> getAverageTrueWindSpeedAndAngleCandidatesWithFallbackFunction(BoatClass boatClass, Speed speedOverGround, LegType legType, Tack tack) {
        int tackFactor;
        HashSet<SpeedWithBearingWithConfidence<Void>> resultSet = new HashSet<SpeedWithBearingWithConfidence<Void>>();
        int n = tackFactor = tack.equals((Object)Tack.PORT) ? -1 : 1;
        if (legType.equals((Object)LegType.UPWIND)) {
            CubicEquation upWindEquation = new CubicEquation(2.0E-4, -0.0245, 0.7602, -0.0463 - speedOverGround.getKnots());
            int angle = 49 * tackFactor;
            this.solveAndAddResults(resultSet, upWindEquation, angle);
        } else if (legType.equals((Object)LegType.DOWNWIND)) {
            CubicEquation downWindEquation = new CubicEquation(3.0E-4, -0.0373, 1.5213, -2.1309 - speedOverGround.getKnots());
            int angle = 150 * tackFactor;
            this.solveAndAddResults(resultSet, downWindEquation, angle);
        }
        return resultSet;
    }

    private void solveAndAddResults(Set<SpeedWithBearingWithConfidence<Void>> result, CubicEquation equation, int angle) {
        double[] windSpeedCandidates = equation.solve();
        int i = 0;
        while (i < windSpeedCandidates.length) {
            double windSpeedCandidateInKnots;
            double d = windSpeedCandidateInKnots = windSpeedCandidates[i] > 0.0 ? windSpeedCandidates[i] : 0.0;
            if (windSpeedCandidateInKnots < 40.0) {
                result.add((SpeedWithBearingWithConfidence<Void>)new SpeedWithBearingWithConfidenceImpl((SpeedWithBearing)new KnotSpeedWithBearingImpl(windSpeedCandidateInKnots, (Bearing)new DegreeBearingImpl((double)angle)), 1.0E-5, null));
            }
            ++i;
        }
    }

    public PolarSheetsData createFullSheetForBoatClass(BoatClass boatClass) {
        double[] defaultWindSpeeds = this.backendPolarSheetGenerationSettings.getWindSpeedStepping().getRawStepping();
        Number[][] averagedPolarDataByWindSpeed = new Number[defaultWindSpeeds.length][360];
        HashMap<Integer, Integer[]> dataCountPerAngleForWindspeed = new HashMap<Integer, Integer[]>();
        HashMap histogramDataMap = new HashMap();
        int totalDataCount = 0;
        int windIndex = 0;
        while (windIndex < defaultWindSpeeds.length) {
            Double windSpeed = defaultWindSpeeds[windIndex];
            Integer[] perAngle = new Integer[360];
            HashMap<Integer, PolarSheetsHistogramDataImpl> perWindSpeed = new HashMap<Integer, PolarSheetsHistogramDataImpl>();
            int angle = 0;
            while (angle < 360) {
                SpeedWithConfidenceImpl speedWithConfidence;
                try {
                    int convertedAngle = this.convertAngleIfNecessary(angle);
                    SpeedWithConfidenceImpl regressionResult = this.speedRegressionPerAngleClusterProcessor.estimateBoatSpeed(boatClass, (Speed)new KnotSpeedImpl(windSpeed.doubleValue()), (Bearing)new DegreeBearingImpl((double)convertedAngle));
                    speedWithConfidence = regressionResult.getConfidence() > 0.1 ? regressionResult : new SpeedWithConfidenceImpl((Speed)new KnotSpeedImpl(0.0), regressionResult.getConfidence(), null);
                }
                catch (NotEnoughDataHasBeenAddedException e) {
                    speedWithConfidence = new SpeedWithConfidenceImpl((Speed)new KnotSpeedImpl(0.0), 0.0, null);
                }
                averagedPolarDataByWindSpeed[windIndex][angle] = ((Speed)speedWithConfidence.getObject()).getKnots();
                int dataCount = 200;
                totalDataCount += dataCount;
                double coefficiantOfVariation = 0.8;
                double confidenceMeasure = 0.5;
                PolarSheetsHistogramDataImpl polarSheetsHistogramDataImpl = this.createEmptyHistogramData(perAngle, angle, dataCount, coefficiantOfVariation, confidenceMeasure);
                perWindSpeed.put(angle, polarSheetsHistogramDataImpl);
                ++angle;
            }
            histogramDataMap.put(windIndex, perWindSpeed);
            dataCountPerAngleForWindspeed.put(windIndex, perAngle);
            ++windIndex;
        }
        PolarSheetsDataImpl data = new PolarSheetsDataImpl(averagedPolarDataByWindSpeed, totalDataCount, dataCountPerAngleForWindspeed, (WindSpeedStepping)this.backendPolarSheetGenerationSettings.getWindSpeedStepping(), histogramDataMap);
        return data;
    }

    private int convertAngleIfNecessary(int angle) {
        int convertedAngle = angle;
        if (angle > 180) {
            convertedAngle = angle - 360;
        }
        return convertedAngle;
    }

    private PolarSheetsHistogramDataImpl createEmptyHistogramData(Integer[] perAngle, int angle, int dataCount, double coefficiantOfVariation, double confidenceMeasure) {
        perAngle[angle] = dataCount;
        Number[] xValues = new Number[]{};
        Number[] yValues = new Number[]{};
        HashMap yValuesByGaugeIds = new HashMap();
        HashMap yValuesByDay = new HashMap();
        HashMap yValuesByDayAndGaugeId = new HashMap();
        PolarSheetsHistogramDataImpl polarSheetsHistogramDataImpl = new PolarSheetsHistogramDataImpl(angle, xValues, yValues, yValuesByGaugeIds, yValuesByDay, yValuesByDayAndGaugeId, dataCount, coefficiantOfVariation);
        polarSheetsHistogramDataImpl.setConfidenceMeasure(confidenceMeasure);
        return polarSheetsHistogramDataImpl;
    }

    public Set<BoatClass> getAvailableBoatClasses() {
        return this.speedRegressionPerAngleClusterProcessor.getAvailableBoatClasses();
    }

    public int[] getDataCountsForWindSpeed(BoatClass boatClass, Speed windSpeed, int startAngleInclusive, int endAngleExclusive) {
        int[] dataCounts = new int[360];
        int angle = 0;
        while (angle < 360) {
            dataCounts[angle] = angle >= startAngleInclusive && angle < endAngleExclusive ? 0 : -1;
            ++angle;
        }
        return dataCounts;
    }

    public SpeedWithBearingWithConfidence<Void> getAverageSpeedAndCourseOverGround(BoatClass boatClass, Speed windSpeed, LegType legType) throws NotEnoughDataHasBeenAddedException {
        SpeedWithBearingWithConfidence<Void> averageSpeedAndCourseOverGround = null;
        averageSpeedAndCourseOverGround = this.cubicRegressionPerCourseProcessor.getAverageSpeedAndCourseOverGround(boatClass, windSpeed, legType);
        return averageSpeedAndCourseOverGround;
    }

    public PolynomialFunction getSpeedRegressionFunction(BoatClass boatClass, LegType legType) throws NotEnoughDataHasBeenAddedException {
        return this.cubicRegressionPerCourseProcessor.getSpeedRegressionFunction(boatClass, legType);
    }

    public PolynomialFunction getAngleRegressionFunction(BoatClass boatClass, LegType legType) throws NotEnoughDataHasBeenAddedException {
        return this.cubicRegressionPerCourseProcessor.getAngleRegressionFunction(boatClass, legType);
    }

    public PolynomialFunction getSpeedRegressionFunction(BoatClass boatClass, double trueWindAngle) throws NotEnoughDataHasBeenAddedException {
        return this.speedRegressionPerAngleClusterProcessor.getSpeedRegressionFunction(boatClass, trueWindAngle);
    }

    public void raceFinishedTracking(TrackedRace race) {
        processRacesThatFinishedLoadingExecutor.execute(() -> {
            logger.info("All queued fixes for newly loaded race will process now. " + (race.getRace() != null ? race.getRace().getName() : race.getRaceIdentifier().getRaceName()));
            for (Competitor competitor : race.getRace().getCompetitors()) {
                GPSFixTrack track = race.getTrack(competitor);
                ArrayList<GPSFixMoving> fixes = new ArrayList<GPSFixMoving>();
                track.lockForRead();
                try {
                    for (GPSFixMoving fix : track.getFixes()) {
                        fixes.add(fix);
                    }
                }
                finally {
                    track.unlockAfterRead();
                }
                for (GPSFixMoving fix : fixes) {
                    this.preFilteringProcessor.processElement((Object)new GPSFixMovingWithOriginInfo(fix, race, competitor));
                }
            }
            logger.info("Finished injecting fixes for race " + (race.getRace() != null ? race.getRace().getName() : race.getRaceIdentifier().getRaceName()) + "; stats: " + this.stats);
        });
    }

    public void registerListener(BoatClass boatClass, PolarsChangedListener listener) {
        Set listenersForBoatClass = (Set)this.listeners.get(boatClass);
        if (listenersForBoatClass == null) {
            ConcurrentHashMap mapForConcurrency = new ConcurrentHashMap();
            listenersForBoatClass = Collections.newSetFromMap(mapForConcurrency);
            this.listeners.put(boatClass, listenersForBoatClass);
        }
        listenersForBoatClass.add(listener);
    }

    public void unregisterListener(BoatClass boatClass, PolarsChangedListener listener) {
        Set listenersForBoatClass = (Set)this.listeners.get(boatClass);
        if (listenersForBoatClass != null) {
            listenersForBoatClass.remove(listener);
        }
    }

    public CubicRegressionPerCourseProcessor getCubicRegressionPerCourseProcessor() {
        return this.cubicRegressionPerCourseProcessor;
    }

    public SpeedRegressionPerAngleClusterProcessor getSpeedRegressionPerAngleClusterProcessor() {
        return this.speedRegressionPerAngleClusterProcessor;
    }

    public PolarSheetGenerationSettings getPolarSheetGenerationSettings() {
        return this.backendPolarSheetGenerationSettings;
    }
}

