/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.impl;

public class CubicEquation {
    private double a;
    private double b;
    private double c;
    private double d;

    public CubicEquation(double a, double b, double c, double d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public double[] solve() {
        double[] result;
        double f = (3.0 * this.c / this.a - this.b * this.b / (this.a * this.a)) / 3.0;
        double g = (2.0 * this.b * this.b * this.b / (this.a * this.a * this.a) - 9.0 * this.b * this.c / (this.a * this.a) + 27.0 * this.d / this.a) / 27.0;
        double h = g * g / 4.0 + f * f * f / 27.0;
        if (f == 0.0 && g == 0.0 && h == 0.0) {
            result = new double[]{-Math.cbrt(this.d / this.a)};
        } else if (h > 0.0) {
            double r = -(g / 2.0) + Math.sqrt(h);
            double s = Math.cbrt(r);
            double t = -(g / 2.0) - Math.sqrt(h);
            double u = Math.cbrt(t);
            result = new double[]{s + u - this.b / (3.0 * this.a)};
        } else {
            double i = Math.sqrt(g * g / 4.0 - h);
            double j = Math.cbrt(i);
            double k = Math.acos(-(g / (2.0 * i)));
            double l = -1.0 * j;
            double m = Math.cos(k / 3.0);
            double n = Math.sqrt(3.0) * Math.sin(k / 3.0);
            double p = -(this.b / (3.0 * this.a));
            result = new double[]{2.0 * j * Math.cos(k / 3.0) - this.b / (3.0 * this.a), l * (m + n) + p, l * (m - n) + p};
        }
        return result;
    }
}

