/*
    This file is part of RouteConverter.

    RouteConverter is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RouteConverter is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RouteConverter; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Copyright (C) 2007 Christian Pesch. All Rights Reserved.
*/

package slash.navigation.fpl;

/**
 * Enumeration of ICAO country codes.
 *
 * @author Christian Pesch
 */

public enum CountryCode {
    None("NONE"),

    Afghanistan1("AF"),
    Afghanistan2("OA"),
    Albania("LA"),
    Algeria("DA"),
    American_Samoa("NS"),
    Angola("FN"),
    Anguilla("TQ"),
    Antarctica1("AA"),
    Antarctica2("NZ"),
    Antarctica3("SA"),
    Antarctica("SC"),
    Antigua_and_Barbuda("TA"),
    Argentina("SA"),
    Armenia1("UD"),
    Armenia2("UG"),
    Aruba("TN"),
    Australia1("DA"),
    Australia2("LG"),
    Australia3("SW"),
    Australia4("TC"),
    Australia("Y"),
    Austria("LO"),
    Azerbaijan1("UB"),
    Azerbaijan2("UG"),
    Bahamas("MY"),
    Bahrain("OB"),
    Bangladesh("VG"),
    Barbados("TB"),
    Belarus("UM"),
    Belgium("EB"),
    Belize("MZ"),
    Benin("DB"),
    Bermuda_Islands("TX"),
    Bhutan("VQ"),
    Bolivia("SL"),
    Bosnia_and_Herzegowina("LQ"),
    Botswana("FB"),
    Brazil1("SB"),
    Brazil2("SD"),
    Brazil3("SI"),
    Brazil4("SJ"),
    Brazil5("SN"),
    Brazil6("SS"),
    Brazil7("SW"),
    British_Indian_Ocean_Territory("FJ"),
    Brunei_Darussalam("WB"),
    Bulgaria("LB"),
    Burkina_Faso("DF"),
    Burundi("HB"),
    Cambodia("VD"),
    Cameroon("FK"),
    Canada("C"),
    Cape_Verde("GV"),
    Cayman_Islands("MW"),
    Central_African_Republic("FE"),
    Chad("FT"),
    Chile1("SC"),
    Chile2("SH"),
    China_People_Republic1("ZB"),
    China_People_Republic2("ZG"),
    China_People_Republic3("ZH"),
    China_People_Republic4("ZJ"),
    China_People_Republic5("ZL"),
    China_People_Republic6("ZP"),
    China_People_Republic7("ZS"),
    China_People_Republic8("ZU"),
    China_People_Republic9("ZW"),
    China_People_RepublicA("ZY"),
    Colombia("SK"),
    Comoros("FM"),
    Congo1("FC"),
    Congo2("FZ"),
    Cook_Islands("NC"),
    Costa_Rica1("ME"),
    Costa_Rica2("ML"),
    Costa_Rica("MR"),
    Cote_d_Ivoire("DI"),
    Croatia("LD"),
    Cuba("MU"),
    Cyprus("LC"),
    Czech_Republic("LK"),
    Denmark("EK"),
    Djibouti("HD"),
    Dominica("TD"),
    Dominican_Republic("MD"),
    East_Timor("WP"),
    Ecuador("SE"),
    Egypt("HE"),
    El_Salvador("MS"),
    Equatorial_Guinea("FG"),
    Eritrea("HH"),
    Estonia("EE"),
    Ethiopia("HA"),
    Falkland_Islands_Malvinas1("EG"),
    Falkland_Islands_Malvinas2("SF"),
    Faroe_Islands("EK"),
    Fiji_Islands("NF"),
    Finland("EF"),
    France("LF"),
    France_metropolitan("LF"),
    French_Guiana("SO"),
    French_Polynesia("NT"),
    Gabon("FO"),
    Gambia("GB"),
    Georgia("UG"),
    Germany1("ED"),
    Germany2("ET"),
    Ghana("DG"),
    Gibraltar("LX"),
    Greece("LG"),
    Greenland1("BG"),
    Greenland2("BK"),
    Grenada("TG"),
    Guadeloupe("TF"),
    Guam1("HI"),
    Guam2("PG"),
    Guatemala("MG"),
    Guernsey("EG"),
    Guinea("GU"),
    Guinea_Bissau("GG"),
    Guyana1("PK"),
    Guyana2("SY"),
    Haiti("MT"),
    Honduras1("MH"),
    Honduras2("MT"),
    Hong_Kong("VH"),
    Hungary("LH"),
    Iceland("BI"),
    India1("VA"),
    India2("VE"),
    India3("VI"),
    India4("VO"),
    Indonesia1("WA"),
    Indonesia2("WI"),
    Indonesia3("WP"),
    Indonesia4("WR"),
    Iran("OI"),
    Iraq("OR"),
    Ireland("EI"),
    Island_of_Man("EG"),
    Israel("LL"),
    Italy("LI"),
    Jamaica("MK"),
    Japan1("RJ"),
    Japan2("RO"),
    Jersey("EG"),
    Jordan("OJ"),
    Kazakhstan("UA"),
    Kenya("HK"),
    Kiribati1("NG"),
    Kiribati2("PC"),
    Kiribati3("PL"),
    Korea_North("ZK"),
    Korea_South("RK"),
    Kuwait1("OK"),
    Kuwait2("Z1"),
    Kyrgyzstan("UA"),
    Laos("VL"),
    Latvia("EV"),
    Lebanon("OL"),
    Lesotho("FX"),
    Liberia("GL"),
    Libya_Arab_Jamahiriya("HL"),
    Liechtenstein("LS"),
    Lithuania("EY"),
    Luxembourg("EL"),
    Macau("VM"),
    Macedonia("LW"),
    Madagascar("FM"),
    Malawi("FW"),
    Malaysia1("WB"),
    Malaysia2("WM"),
    Maldives("VR"),
    Mali("GA"),
    Malta("LM"),
    Marshall_Islands1("ML"),
    Marshall_Islands2("PK"),
    Marshall_Islands3("UJ"),
    Martinique("TF"),
    Mauritania("GQ"),
    Mauritius("FI"),
    Mayotte("FM"),
    Mexico("MM"),
    Micronesia("PT"),
    Moldova("LU"),
    Monaco("LN"),
    Mongolia("ZM"),
    Montenegro1("BK"),
    Montenegro2("LY"),
    Montserrat("TR"),
    Morocco("GM"),
    Mozambique("FQ"),
    Myanmar("VY"),
    Namibia("FY"),
    Nauru("AN"),
    Nepal("VN"),
    Netherlands("EH"),
    Netherlands_Antilles("TN"),
    New_Caledonia("NW"),
    New_Zealand("NZ"),
    Nicaragua("MN"),
    Niger("DR"),
    Nigeria("DN"),
    Niue("NI"),
    Northern_Mariana_Islands1("HI"),
    Northern_Mariana_Islands2("PG"),
    Northern_Mariana_Islands3("TT"),
    Norway("EN"),
    Oman("OO"),
    Pakistan("OP"),
    Palau("PT"),
    Palestinian_Territory("LV"),
    Panama("MP"),
    Papua_New_Guinea("AY"),
    Paraguay1("SG"),
    Paraguay2("Z2"),
    Peru1("SO"),
    Peru2("SP"),
    Philippines("RP"),
    Poland("EP"),
    Portugal("LP"),
    Portugal_Madeira("LP"),
    Puerto_Rico1("PR"),
    Puerto_Rico2("TJ"),
    Qatar("OT"),
    Reunion("FM"),
    Romania("LR"),
    Russian_Federation1("UE"),
    Russian_Federation2("UH"),
    Russian_Federation3("UI"),
    Russian_Federation4("UL"),
    Russian_Federation5("UM"),
    Russian_Federation6("UN"),
    Russian_Federation7("UO"),
    Russian_Federation8("UR"),
    Russian_Federation9("US"),
    Russian_FederationA("UU"),
    Russian_FederationB("UW"),
    Russian_FederationC("XL"),
    Russian_FederationD("XR"),
    Russian_FederationE("XU"),
    Russian_FederationF("XW"),
    Rwanda("HR"),
    Saint_Helena("FH"),
    Saint_Kitts_and_Nevis("TK"),
    Saint_Lucia_Island("TL"),
    Saint_Pierre_and_Miquelon("LF"),
    Saint_Vincent_and_The_Grenadines("TV"),
    Samoa1("NS"),
    Samoa2("UG"),
    Sao_Tome_and_Principe("FP"),
    Saudi_Arabia("OE"),
    Senegal("GO"),
    Serbia("LY"),
    Seychelles("FS"),
    Sierra_Leone("GF"),
    Singapore("WS"),
    Slovakia("LZ"),
    Slovenia("LJ"),
    Solomon_Islands("AG"),
    Somalia("HC"),
    South_Africa("FA"),
    South_Georgia_and_Islands("UG"),
    Spain1("GC"),
    Spain2("GE"),
    Spain3("LE"),
    Sri_Lanka("VC"),
    Sudan("HS"),
    Suriname("SM"),
    Svalbard_and_Jan_Mayen_Islands("EN"),
    Swaziland("FD"),
    Sweden("ES"),
    Switzerland("LS"),
    Syria("OS"),
    Tadzjikistan_Republic("UT"),
    Taiwan("RC"),
    Tanzania("HT"),
    Thailand("VT"),
    Togo("DX"),
    Tonga("NF"),
    Trinidad_and_Tobago("TT"),
    Tunisia("DT"),
    Turkey("LT"),
    Turkmenistan("UT"),
    Turks_and_Caicos_Islands("MB"),
    Tuvalu("NG"),
    Uganda("HU"),
    Ukraine("UK"),
    United_Arab_Emirates("OM"),
    United_Kingdom1("EG"),
    United_Kingdom2("XB"),
    United_Kingdom3("XP"),
    United_States("K"),
    Uruguay("SU"),
    US_Minor_Outlying_Islands1("PJ"),
    US_Minor_Outlying_Islands2("PL"),
    US_Minor_Outlying_Islands3("PM"),
    US_Minor_Outlying_Islands4("PW"),
    US_Minor_Outlying_Islands5("TF"),
    Uzbekistan1("UA"),
    Uzbekistan2("UT"),
    Vanuatu("NV"),
    Venezuela("SV"),
    Viet_Nam("VV"),
    Virgin_Islands_British("TU"),
    Virgin_Islands_US1("TI"),
    Virgin_Islands_US2("VI"),
    Wallis_and_Futuna_Islands("NL"),
    Western_Sahara1("GM"),
    Western_Sahara2("GS"),
    Yemen("OY"),
    Zaire("FZ"),
    Zambia("FL"),
    Zimbabwe("FV");

    private String value;

    private CountryCode(String value) {
        this.value = value;
    }

    public String value() {
        return value;
    }

    public static CountryCode fromValue(String value) {
        for (CountryCode countryCode : CountryCode.values()) {
            if (countryCode.value().equalsIgnoreCase(value))
                return countryCode;
        }
        return null;
    }
}
