/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueryLoggingConfigsResponse extends Route53Response implements
        ToCopyableBuilder<ListQueryLoggingConfigsResponse.Builder, ListQueryLoggingConfigsResponse> {
    private static final SdkField<List<QueryLoggingConfig>> QUERY_LOGGING_CONFIGS_FIELD = SdkField
            .<List<QueryLoggingConfig>> builder(MarshallingType.LIST)
            .memberName("QueryLoggingConfigs")
            .getter(getter(ListQueryLoggingConfigsResponse::queryLoggingConfigs))
            .setter(setter(Builder::queryLoggingConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryLoggingConfigs")
                    .unmarshallLocationName("QueryLoggingConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("QueryLoggingConfig")
                            .memberFieldInfo(
                                    SdkField.<QueryLoggingConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryLoggingConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("QueryLoggingConfig")
                                                    .unmarshallLocationName("QueryLoggingConfig").build()).build()).build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListQueryLoggingConfigsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_LOGGING_CONFIGS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<QueryLoggingConfig> queryLoggingConfigs;

    private final String nextToken;

    private ListQueryLoggingConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.queryLoggingConfigs = builder.queryLoggingConfigs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryLoggingConfigs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryLoggingConfigs() {
        return queryLoggingConfigs != null && !(queryLoggingConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains one <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html">QueryLoggingConfig</a>
     * element for each configuration for DNS query logging that is associated with the current Amazon Web Services
     * account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryLoggingConfigs} method.
     * </p>
     * 
     * @return An array that contains one <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html"
     *         >QueryLoggingConfig</a> element for each configuration for DNS query logging that is associated with the
     *         current Amazon Web Services account.
     */
    public final List<QueryLoggingConfig> queryLoggingConfigs() {
        return queryLoggingConfigs;
    }

    /**
     * <p>
     * If a response includes the last of the query logging configurations that are associated with the current Amazon
     * Web Services account, <code>NextToken</code> doesn't appear in the response.
     * </p>
     * <p>
     * If a response doesn't include the last of the configurations, you can get more configurations by submitting
     * another <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html">
     * ListQueryLoggingConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in the
     * previous response and include it in <code>NextToken</code> in the next request.
     * </p>
     * 
     * @return If a response includes the last of the query logging configurations that are associated with the current
     *         Amazon Web Services account, <code>NextToken</code> doesn't appear in the response.</p>
     *         <p>
     *         If a response doesn't include the last of the configurations, you can get more configurations by
     *         submitting another <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html"
     *         >ListQueryLoggingConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53
     *         returned in the previous response and include it in <code>NextToken</code> in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryLoggingConfigs() ? queryLoggingConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueryLoggingConfigsResponse)) {
            return false;
        }
        ListQueryLoggingConfigsResponse other = (ListQueryLoggingConfigsResponse) obj;
        return hasQueryLoggingConfigs() == other.hasQueryLoggingConfigs()
                && Objects.equals(queryLoggingConfigs(), other.queryLoggingConfigs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQueryLoggingConfigsResponse")
                .add("QueryLoggingConfigs", hasQueryLoggingConfigs() ? queryLoggingConfigs() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryLoggingConfigs":
            return Optional.ofNullable(clazz.cast(queryLoggingConfigs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryLoggingConfigs", QUERY_LOGGING_CONFIGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQueryLoggingConfigsResponse, T> g) {
        return obj -> g.apply((ListQueryLoggingConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, ListQueryLoggingConfigsResponse> {
        /**
         * <p>
         * An array that contains one <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html"
         * >QueryLoggingConfig</a> element for each configuration for DNS query logging that is associated with the
         * current Amazon Web Services account.
         * </p>
         * 
         * @param queryLoggingConfigs
         *        An array that contains one <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html"
         *        >QueryLoggingConfig</a> element for each configuration for DNS query logging that is associated with
         *        the current Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryLoggingConfigs(Collection<QueryLoggingConfig> queryLoggingConfigs);

        /**
         * <p>
         * An array that contains one <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html"
         * >QueryLoggingConfig</a> element for each configuration for DNS query logging that is associated with the
         * current Amazon Web Services account.
         * </p>
         * 
         * @param queryLoggingConfigs
         *        An array that contains one <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html"
         *        >QueryLoggingConfig</a> element for each configuration for DNS query logging that is associated with
         *        the current Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryLoggingConfigs(QueryLoggingConfig... queryLoggingConfigs);

        /**
         * <p>
         * An array that contains one <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html"
         * >QueryLoggingConfig</a> element for each configuration for DNS query logging that is associated with the
         * current Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53.model.QueryLoggingConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.route53.model.QueryLoggingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53.model.QueryLoggingConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #queryLoggingConfigs(List<QueryLoggingConfig>)}.
         * 
         * @param queryLoggingConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53.model.QueryLoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryLoggingConfigs(java.util.Collection<QueryLoggingConfig>)
         */
        Builder queryLoggingConfigs(Consumer<QueryLoggingConfig.Builder>... queryLoggingConfigs);

        /**
         * <p>
         * If a response includes the last of the query logging configurations that are associated with the current
         * Amazon Web Services account, <code>NextToken</code> doesn't appear in the response.
         * </p>
         * <p>
         * If a response doesn't include the last of the configurations, you can get more configurations by submitting
         * another <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html">
         * ListQueryLoggingConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in
         * the previous response and include it in <code>NextToken</code> in the next request.
         * </p>
         * 
         * @param nextToken
         *        If a response includes the last of the query logging configurations that are associated with the
         *        current Amazon Web Services account, <code>NextToken</code> doesn't appear in the response.</p>
         *        <p>
         *        If a response doesn't include the last of the configurations, you can get more configurations by
         *        submitting another <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html"
         *        >ListQueryLoggingConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53
         *        returned in the previous response and include it in <code>NextToken</code> in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<QueryLoggingConfig> queryLoggingConfigs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueryLoggingConfigsResponse model) {
            super(model);
            queryLoggingConfigs(model.queryLoggingConfigs);
            nextToken(model.nextToken);
        }

        public final List<QueryLoggingConfig.Builder> getQueryLoggingConfigs() {
            List<QueryLoggingConfig.Builder> result = QueryLoggingConfigsCopier.copyToBuilder(this.queryLoggingConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryLoggingConfigs(Collection<QueryLoggingConfig.BuilderImpl> queryLoggingConfigs) {
            this.queryLoggingConfigs = QueryLoggingConfigsCopier.copyFromBuilder(queryLoggingConfigs);
        }

        @Override
        public final Builder queryLoggingConfigs(Collection<QueryLoggingConfig> queryLoggingConfigs) {
            this.queryLoggingConfigs = QueryLoggingConfigsCopier.copy(queryLoggingConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryLoggingConfigs(QueryLoggingConfig... queryLoggingConfigs) {
            queryLoggingConfigs(Arrays.asList(queryLoggingConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryLoggingConfigs(Consumer<QueryLoggingConfig.Builder>... queryLoggingConfigs) {
            queryLoggingConfigs(Stream.of(queryLoggingConfigs).map(c -> QueryLoggingConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListQueryLoggingConfigsResponse build() {
            return new ListQueryLoggingConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
