/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCidrCollectionResponse extends Route53Response implements
        ToCopyableBuilder<CreateCidrCollectionResponse.Builder, CreateCidrCollectionResponse> {
    private static final SdkField<CidrCollection> COLLECTION_FIELD = SdkField
            .<CidrCollection> builder(MarshallingType.SDK_POJO)
            .memberName("Collection")
            .getter(getter(CreateCidrCollectionResponse::collection))
            .setter(setter(Builder::collection))
            .constructor(CidrCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Collection")
                    .unmarshallLocationName("Collection").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Location")
            .getter(getter(CreateCidrCollectionResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_FIELD,
            LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CidrCollection collection;

    private final String location;

    private CreateCidrCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.collection = builder.collection;
        this.location = builder.location;
    }

    /**
     * <p>
     * A complex type that contains information about the CIDR collection.
     * </p>
     * 
     * @return A complex type that contains information about the CIDR collection.
     */
    public final CidrCollection collection() {
        return collection;
    }

    /**
     * <p>
     * A unique URL that represents the location for the CIDR collection.
     * </p>
     * 
     * @return A unique URL that represents the location for the CIDR collection.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collection());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCidrCollectionResponse)) {
            return false;
        }
        CreateCidrCollectionResponse other = (CreateCidrCollectionResponse) obj;
        return Objects.equals(collection(), other.collection()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCidrCollectionResponse").add("Collection", collection()).add("Location", location())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Collection":
            return Optional.ofNullable(clazz.cast(collection()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Collection", COLLECTION_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCidrCollectionResponse, T> g) {
        return obj -> g.apply((CreateCidrCollectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateCidrCollectionResponse> {
        /**
         * <p>
         * A complex type that contains information about the CIDR collection.
         * </p>
         * 
         * @param collection
         *        A complex type that contains information about the CIDR collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collection(CidrCollection collection);

        /**
         * <p>
         * A complex type that contains information about the CIDR collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link CidrCollection.Builder} avoiding the need
         * to create one manually via {@link CidrCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CidrCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #collection(CidrCollection)}.
         * 
         * @param collection
         *        a consumer that will call methods on {@link CidrCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collection(CidrCollection)
         */
        default Builder collection(Consumer<CidrCollection.Builder> collection) {
            return collection(CidrCollection.builder().applyMutation(collection).build());
        }

        /**
         * <p>
         * A unique URL that represents the location for the CIDR collection.
         * </p>
         * 
         * @param location
         *        A unique URL that represents the location for the CIDR collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private CidrCollection collection;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCidrCollectionResponse model) {
            super(model);
            collection(model.collection);
            location(model.location);
        }

        public final CidrCollection.Builder getCollection() {
            return collection != null ? collection.toBuilder() : null;
        }

        public final void setCollection(CidrCollection.BuilderImpl collection) {
            this.collection = collection != null ? collection.build() : null;
        }

        @Override
        public final Builder collection(CidrCollection collection) {
            this.collection = collection;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public CreateCidrCollectionResponse build() {
            return new CreateCidrCollectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
