/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the VPC resources, VPC endpoint services, Lattice services, or service networks associated with the VPC
 * endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcEndpointAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcEndpointAssociation.Builder, VpcEndpointAssociation> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(VpcEndpointAssociation::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("id")
                    .build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId")
            .getter(getter(VpcEndpointAssociation::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId")
                    .unmarshallLocationName("vpcEndpointId").build()).build();

    private static final SdkField<String> SERVICE_NETWORK_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceNetworkArn")
            .getter(getter(VpcEndpointAssociation::serviceNetworkArn))
            .setter(setter(Builder::serviceNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNetworkArn")
                    .unmarshallLocationName("serviceNetworkArn").build()).build();

    private static final SdkField<String> SERVICE_NETWORK_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceNetworkName")
            .getter(getter(VpcEndpointAssociation::serviceNetworkName))
            .setter(setter(Builder::serviceNetworkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNetworkName")
                    .unmarshallLocationName("serviceNetworkName").build()).build();

    private static final SdkField<String> ASSOCIATED_RESOURCE_ACCESSIBILITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociatedResourceAccessibility")
            .getter(getter(VpcEndpointAssociation::associatedResourceAccessibility))
            .setter(setter(Builder::associatedResourceAccessibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceAccessibility")
                    .unmarshallLocationName("associatedResourceAccessibility").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FailureReason")
            .getter(getter(VpcEndpointAssociation::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason")
                    .unmarshallLocationName("failureReason").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FailureCode")
            .getter(getter(VpcEndpointAssociation::failureCode))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode")
                    .unmarshallLocationName("failureCode").build()).build();

    private static final SdkField<DnsEntry> DNS_ENTRY_FIELD = SdkField
            .<DnsEntry> builder(MarshallingType.SDK_POJO)
            .memberName("DnsEntry")
            .getter(getter(VpcEndpointAssociation::dnsEntry))
            .setter(setter(Builder::dnsEntry))
            .constructor(DnsEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsEntry")
                    .unmarshallLocationName("dnsEntry").build()).build();

    private static final SdkField<DnsEntry> PRIVATE_DNS_ENTRY_FIELD = SdkField
            .<DnsEntry> builder(MarshallingType.SDK_POJO)
            .memberName("PrivateDnsEntry")
            .getter(getter(VpcEndpointAssociation::privateDnsEntry))
            .setter(setter(Builder::privateDnsEntry))
            .constructor(DnsEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsEntry")
                    .unmarshallLocationName("privateDnsEntry").build()).build();

    private static final SdkField<String> ASSOCIATED_RESOURCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociatedResourceArn")
            .getter(getter(VpcEndpointAssociation::associatedResourceArn))
            .setter(setter(Builder::associatedResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceArn")
                    .unmarshallLocationName("associatedResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceConfigurationGroupArn")
            .getter(getter(VpcEndpointAssociation::resourceConfigurationGroupArn))
            .setter(setter(Builder::resourceConfigurationGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfigurationGroupArn")
                    .unmarshallLocationName("resourceConfigurationGroupArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(VpcEndpointAssociation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            VPC_ENDPOINT_ID_FIELD, SERVICE_NETWORK_ARN_FIELD, SERVICE_NETWORK_NAME_FIELD,
            ASSOCIATED_RESOURCE_ACCESSIBILITY_FIELD, FAILURE_REASON_FIELD, FAILURE_CODE_FIELD, DNS_ENTRY_FIELD,
            PRIVATE_DNS_ENTRY_FIELD, ASSOCIATED_RESOURCE_ARN_FIELD, RESOURCE_CONFIGURATION_GROUP_ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String vpcEndpointId;

    private final String serviceNetworkArn;

    private final String serviceNetworkName;

    private final String associatedResourceAccessibility;

    private final String failureReason;

    private final String failureCode;

    private final DnsEntry dnsEntry;

    private final DnsEntry privateDnsEntry;

    private final String associatedResourceArn;

    private final String resourceConfigurationGroupArn;

    private final List<Tag> tags;

    private VpcEndpointAssociation(BuilderImpl builder) {
        this.id = builder.id;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.serviceNetworkArn = builder.serviceNetworkArn;
        this.serviceNetworkName = builder.serviceNetworkName;
        this.associatedResourceAccessibility = builder.associatedResourceAccessibility;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
        this.dnsEntry = builder.dnsEntry;
        this.privateDnsEntry = builder.privateDnsEntry;
        this.associatedResourceArn = builder.associatedResourceArn;
        this.resourceConfigurationGroupArn = builder.resourceConfigurationGroupArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the VPC endpoint association.
     * </p>
     * 
     * @return The ID of the VPC endpoint association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the VPC endpoint.
     * </p>
     * 
     * @return The ID of the VPC endpoint.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service network.
     */
    public final String serviceNetworkArn() {
        return serviceNetworkArn;
    }

    /**
     * <p>
     * The name of the service network.
     * </p>
     * 
     * @return The name of the service network.
     */
    public final String serviceNetworkName() {
        return serviceNetworkName;
    }

    /**
     * <p>
     * The connectivity status of the resources associated to a VPC endpoint. The resource is accessible if the
     * associated resource configuration is <code>AVAILABLE</code>, otherwise the resource is inaccessible.
     * </p>
     * 
     * @return The connectivity status of the resources associated to a VPC endpoint. The resource is accessible if the
     *         associated resource configuration is <code>AVAILABLE</code>, otherwise the resource is inaccessible.
     */
    public final String associatedResourceAccessibility() {
        return associatedResourceAccessibility;
    }

    /**
     * <p>
     * A message related to why an VPC endpoint association failed.
     * </p>
     * 
     * @return A message related to why an VPC endpoint association failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * An error code related to why an VPC endpoint association failed.
     * </p>
     * 
     * @return An error code related to why an VPC endpoint association failed.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * The DNS entry of the VPC endpoint association.
     * </p>
     * 
     * @return The DNS entry of the VPC endpoint association.
     */
    public final DnsEntry dnsEntry() {
        return dnsEntry;
    }

    /**
     * <p>
     * The private DNS entry of the VPC endpoint association.
     * </p>
     * 
     * @return The private DNS entry of the VPC endpoint association.
     */
    public final DnsEntry privateDnsEntry() {
        return privateDnsEntry;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the associated resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the associated resource.
     */
    public final String associatedResourceArn() {
        return associatedResourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource configuration group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource configuration group.
     */
    public final String resourceConfigurationGroupArn() {
        return resourceConfigurationGroupArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the VPC endpoint association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to apply to the VPC endpoint association.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkName());
        hashCode = 31 * hashCode + Objects.hashCode(associatedResourceAccessibility());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(dnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(associatedResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpointAssociation)) {
            return false;
        }
        VpcEndpointAssociation other = (VpcEndpointAssociation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(serviceNetworkArn(), other.serviceNetworkArn())
                && Objects.equals(serviceNetworkName(), other.serviceNetworkName())
                && Objects.equals(associatedResourceAccessibility(), other.associatedResourceAccessibility())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(failureCode(), other.failureCode())
                && Objects.equals(dnsEntry(), other.dnsEntry()) && Objects.equals(privateDnsEntry(), other.privateDnsEntry())
                && Objects.equals(associatedResourceArn(), other.associatedResourceArn())
                && Objects.equals(resourceConfigurationGroupArn(), other.resourceConfigurationGroupArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcEndpointAssociation").add("Id", id()).add("VpcEndpointId", vpcEndpointId())
                .add("ServiceNetworkArn", serviceNetworkArn()).add("ServiceNetworkName", serviceNetworkName())
                .add("AssociatedResourceAccessibility", associatedResourceAccessibility()).add("FailureReason", failureReason())
                .add("FailureCode", failureCode()).add("DnsEntry", dnsEntry()).add("PrivateDnsEntry", privateDnsEntry())
                .add("AssociatedResourceArn", associatedResourceArn())
                .add("ResourceConfigurationGroupArn", resourceConfigurationGroupArn()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "ServiceNetworkArn":
            return Optional.ofNullable(clazz.cast(serviceNetworkArn()));
        case "ServiceNetworkName":
            return Optional.ofNullable(clazz.cast(serviceNetworkName()));
        case "AssociatedResourceAccessibility":
            return Optional.ofNullable(clazz.cast(associatedResourceAccessibility()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "DnsEntry":
            return Optional.ofNullable(clazz.cast(dnsEntry()));
        case "PrivateDnsEntry":
            return Optional.ofNullable(clazz.cast(privateDnsEntry()));
        case "AssociatedResourceArn":
            return Optional.ofNullable(clazz.cast(associatedResourceArn()));
        case "ResourceConfigurationGroupArn":
            return Optional.ofNullable(clazz.cast(resourceConfigurationGroupArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("ServiceNetworkArn", SERVICE_NETWORK_ARN_FIELD);
        map.put("ServiceNetworkName", SERVICE_NETWORK_NAME_FIELD);
        map.put("AssociatedResourceAccessibility", ASSOCIATED_RESOURCE_ACCESSIBILITY_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("FailureCode", FAILURE_CODE_FIELD);
        map.put("DnsEntry", DNS_ENTRY_FIELD);
        map.put("PrivateDnsEntry", PRIVATE_DNS_ENTRY_FIELD);
        map.put("AssociatedResourceArn", ASSOCIATED_RESOURCE_ARN_FIELD);
        map.put("ResourceConfigurationGroupArn", RESOURCE_CONFIGURATION_GROUP_ARN_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcEndpointAssociation, T> g) {
        return obj -> g.apply((VpcEndpointAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcEndpointAssociation> {
        /**
         * <p>
         * The ID of the VPC endpoint association.
         * </p>
         * 
         * @param id
         *        The ID of the VPC endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the VPC endpoint.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service network.
         * </p>
         * 
         * @param serviceNetworkArn
         *        The Amazon Resource Name (ARN) of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkArn(String serviceNetworkArn);

        /**
         * <p>
         * The name of the service network.
         * </p>
         * 
         * @param serviceNetworkName
         *        The name of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkName(String serviceNetworkName);

        /**
         * <p>
         * The connectivity status of the resources associated to a VPC endpoint. The resource is accessible if the
         * associated resource configuration is <code>AVAILABLE</code>, otherwise the resource is inaccessible.
         * </p>
         * 
         * @param associatedResourceAccessibility
         *        The connectivity status of the resources associated to a VPC endpoint. The resource is accessible if
         *        the associated resource configuration is <code>AVAILABLE</code>, otherwise the resource is
         *        inaccessible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceAccessibility(String associatedResourceAccessibility);

        /**
         * <p>
         * A message related to why an VPC endpoint association failed.
         * </p>
         * 
         * @param failureReason
         *        A message related to why an VPC endpoint association failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * An error code related to why an VPC endpoint association failed.
         * </p>
         * 
         * @param failureCode
         *        An error code related to why an VPC endpoint association failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The DNS entry of the VPC endpoint association.
         * </p>
         * 
         * @param dnsEntry
         *        The DNS entry of the VPC endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsEntry(DnsEntry dnsEntry);

        /**
         * <p>
         * The DNS entry of the VPC endpoint association.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsEntry.Builder} avoiding the need to
         * create one manually via {@link DnsEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsEntry.Builder#build()} is called immediately and its result is
         * passed to {@link #dnsEntry(DnsEntry)}.
         * 
         * @param dnsEntry
         *        a consumer that will call methods on {@link DnsEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsEntry(DnsEntry)
         */
        default Builder dnsEntry(Consumer<DnsEntry.Builder> dnsEntry) {
            return dnsEntry(DnsEntry.builder().applyMutation(dnsEntry).build());
        }

        /**
         * <p>
         * The private DNS entry of the VPC endpoint association.
         * </p>
         * 
         * @param privateDnsEntry
         *        The private DNS entry of the VPC endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsEntry(DnsEntry privateDnsEntry);

        /**
         * <p>
         * The private DNS entry of the VPC endpoint association.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsEntry.Builder} avoiding the need to
         * create one manually via {@link DnsEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsEntry.Builder#build()} is called immediately and its result is
         * passed to {@link #privateDnsEntry(DnsEntry)}.
         * 
         * @param privateDnsEntry
         *        a consumer that will call methods on {@link DnsEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateDnsEntry(DnsEntry)
         */
        default Builder privateDnsEntry(Consumer<DnsEntry.Builder> privateDnsEntry) {
            return privateDnsEntry(DnsEntry.builder().applyMutation(privateDnsEntry).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the associated resource.
         * </p>
         * 
         * @param associatedResourceArn
         *        The Amazon Resource Name (ARN) of the associated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceArn(String associatedResourceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource configuration group.
         * </p>
         * 
         * @param resourceConfigurationGroupArn
         *        The Amazon Resource Name (ARN) of the resource configuration group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationGroupArn(String resourceConfigurationGroupArn);

        /**
         * <p>
         * The tags to apply to the VPC endpoint association.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the VPC endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to apply to the VPC endpoint association.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the VPC endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to apply to the VPC endpoint association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String vpcEndpointId;

        private String serviceNetworkArn;

        private String serviceNetworkName;

        private String associatedResourceAccessibility;

        private String failureReason;

        private String failureCode;

        private DnsEntry dnsEntry;

        private DnsEntry privateDnsEntry;

        private String associatedResourceArn;

        private String resourceConfigurationGroupArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpointAssociation model) {
            id(model.id);
            vpcEndpointId(model.vpcEndpointId);
            serviceNetworkArn(model.serviceNetworkArn);
            serviceNetworkName(model.serviceNetworkName);
            associatedResourceAccessibility(model.associatedResourceAccessibility);
            failureReason(model.failureReason);
            failureCode(model.failureCode);
            dnsEntry(model.dnsEntry);
            privateDnsEntry(model.privateDnsEntry);
            associatedResourceArn(model.associatedResourceArn);
            resourceConfigurationGroupArn(model.resourceConfigurationGroupArn);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getServiceNetworkArn() {
            return serviceNetworkArn;
        }

        public final void setServiceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
        }

        @Override
        public final Builder serviceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        public final String getServiceNetworkName() {
            return serviceNetworkName;
        }

        public final void setServiceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
        }

        @Override
        public final Builder serviceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
            return this;
        }

        public final String getAssociatedResourceAccessibility() {
            return associatedResourceAccessibility;
        }

        public final void setAssociatedResourceAccessibility(String associatedResourceAccessibility) {
            this.associatedResourceAccessibility = associatedResourceAccessibility;
        }

        @Override
        public final Builder associatedResourceAccessibility(String associatedResourceAccessibility) {
            this.associatedResourceAccessibility = associatedResourceAccessibility;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final DnsEntry.Builder getDnsEntry() {
            return dnsEntry != null ? dnsEntry.toBuilder() : null;
        }

        public final void setDnsEntry(DnsEntry.BuilderImpl dnsEntry) {
            this.dnsEntry = dnsEntry != null ? dnsEntry.build() : null;
        }

        @Override
        public final Builder dnsEntry(DnsEntry dnsEntry) {
            this.dnsEntry = dnsEntry;
            return this;
        }

        public final DnsEntry.Builder getPrivateDnsEntry() {
            return privateDnsEntry != null ? privateDnsEntry.toBuilder() : null;
        }

        public final void setPrivateDnsEntry(DnsEntry.BuilderImpl privateDnsEntry) {
            this.privateDnsEntry = privateDnsEntry != null ? privateDnsEntry.build() : null;
        }

        @Override
        public final Builder privateDnsEntry(DnsEntry privateDnsEntry) {
            this.privateDnsEntry = privateDnsEntry;
            return this;
        }

        public final String getAssociatedResourceArn() {
            return associatedResourceArn;
        }

        public final void setAssociatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
        }

        @Override
        public final Builder associatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
            return this;
        }

        public final String getResourceConfigurationGroupArn() {
            return resourceConfigurationGroupArn;
        }

        public final void setResourceConfigurationGroupArn(String resourceConfigurationGroupArn) {
            this.resourceConfigurationGroupArn = resourceConfigurationGroupArn;
        }

        @Override
        public final Builder resourceConfigurationGroupArn(String resourceConfigurationGroupArn) {
            this.resourceConfigurationGroupArn = resourceConfigurationGroupArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public VpcEndpointAssociation build() {
            return new VpcEndpointAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
