/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.clustering;

import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.polars.windestimation.ManeuverClassificationImpl;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.data.ManeuverTypeForClassification;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverWithProbabilisticTypeClassification;

public class ManeuverClassificationForClusteringImpl
extends ManeuverClassificationImpl {
    private final ManeuverWithProbabilisticTypeClassification maneuverWithProbabilisticTypeClassification;

    public ManeuverClassificationForClusteringImpl(ManeuverWithProbabilisticTypeClassification maneuverWithProbabilisticTypeClassification, String competitorName, PolarDataService polarService) {
        super(competitorName, maneuverWithProbabilisticTypeClassification.getManeuver().getBoatClass(), maneuverWithProbabilisticTypeClassification.getManeuver().getManeuverTimePoint(), maneuverWithProbabilisticTypeClassification.getManeuver().getManeuverPosition(), maneuverWithProbabilisticTypeClassification.getManeuver().getCourseChangeInDegrees(), maneuverWithProbabilisticTypeClassification.getManeuver().getSpeedWithBearingBefore(), maneuverWithProbabilisticTypeClassification.getManeuver().getMiddleCourse(), null, polarService);
        this.maneuverWithProbabilisticTypeClassification = maneuverWithProbabilisticTypeClassification;
    }

    public double getLikelihoodForManeuverType(ManeuverType maneuverType) {
        if (this.likelihoodPerManeuverType[maneuverType.ordinal()] == null) {
            this.likelihoodPerManeuverType[ManeuverType.TACK.ordinal()] = this.maneuverWithProbabilisticTypeClassification.getManeuverTypeLikelihood(ManeuverTypeForClassification.TACK);
            this.likelihoodPerManeuverType[ManeuverType.JIBE.ordinal()] = this.maneuverWithProbabilisticTypeClassification.getManeuverTypeLikelihood(ManeuverTypeForClassification.JIBE);
            this.likelihoodPerManeuverType[ManeuverType.HEAD_UP.ordinal()] = this.maneuverWithProbabilisticTypeClassification.getManeuverTypeLikelihood(ManeuverTypeForClassification.HEAD_UP);
            this.likelihoodPerManeuverType[ManeuverType.BEAR_AWAY.ordinal()] = this.maneuverWithProbabilisticTypeClassification.getManeuverTypeLikelihood(ManeuverTypeForClassification.BEAR_AWAY);
            this.likelihoodPerManeuverType[ManeuverType.PENALTY_CIRCLE.ordinal()] = 0.0;
            this.likelihoodPerManeuverType[ManeuverType.UNKNOWN.ordinal()] = 0.0;
        }
        return this.likelihoodPerManeuverType[maneuverType.ordinal()];
    }

    public ManeuverForEstimation getManeuver() {
        return this.maneuverWithProbabilisticTypeClassification.getManeuver();
    }
}

