/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription;

import com.sap.sse.common.TimePoint;
import com.sap.sse.security.shared.subscription.Subscription;
import java.util.HashMap;
import java.util.Map;

public class SubscriptionData {
    private Map<String, Object> data;

    public static SubscriptionData createEmptySubscriptionDataWithUpdateTimes(String planId, TimePoint latestEventTime, TimePoint manualUpdatedTime) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(DataAttribute.PLAN_ID.name(), planId);
        data.put(DataAttribute.LATEST_EVENT_TIME.name(), latestEventTime.asMillis());
        data.put(DataAttribute.MANUAL_UPDATED_AT.name(), manualUpdatedTime.asMillis());
        return new SubscriptionData(data);
    }

    public SubscriptionData(Map<String, Object> data) {
        this.data = data;
    }

    public Map<String, Object> getMap() {
        return this.data;
    }

    public String getSubscriptionId() {
        return this.getMapStringValue(DataAttribute.SUBSCRIPTION_ID.name());
    }

    public String getPlanId() {
        return this.getMapStringValue(DataAttribute.PLAN_ID.name());
    }

    public String getCustomerId() {
        return this.getMapStringValue(DataAttribute.CUSTOMER_ID.name());
    }

    public TimePoint getTrialStart() {
        return this.getMapTimePointValue(DataAttribute.TRIAL_START.name());
    }

    public TimePoint getTrialEnd() {
        return this.getMapTimePointValue(DataAttribute.TRIAL_END.name());
    }

    public String getSubscriptionStatus() {
        return this.getMapStringValue(DataAttribute.SUBSCRIPTION_STATUS.name());
    }

    public String getPaymentStatus() {
        return this.getMapStringValue(DataAttribute.PAYMENT_STATUS.name());
    }

    public String getTransactionType() {
        return this.getMapStringValue(DataAttribute.TRANSACTION_TYPE.name());
    }

    public String getTransactionStatus() {
        return this.getMapStringValue(DataAttribute.TRANSACTION_STATUS.name());
    }

    public String getInvoiceId() {
        return this.getMapStringValue(DataAttribute.INVOICE_ID.name());
    }

    public String getInvoiceStatus() {
        return this.getMapStringValue(DataAttribute.INVOICE_STATUS.name());
    }

    public TimePoint getSubscriptionCreatedAt() {
        return this.getMapTimePointValue(DataAttribute.SUBSCRIPTION_CREATED_AT.name());
    }

    public TimePoint getSubscriptionUpdatedAt() {
        return this.getMapTimePointValue(DataAttribute.SUBSCRIPTION_UPDATED_AT.name());
    }

    public TimePoint getLatestEventTime() {
        return this.getMapTimePointValue(DataAttribute.LATEST_EVENT_TIME.name());
    }

    public TimePoint getManualUpdatedAt() {
        return this.getMapTimePointValue(DataAttribute.MANUAL_UPDATED_AT.name());
    }

    public String getProviderName() {
        return this.getMapStringValue(DataAttribute.PROVIDER_NAME.name());
    }

    public TimePoint getNextBillingAt() {
        return this.getMapTimePointValue(DataAttribute.NEXT_BILLING_AT.name());
    }

    public TimePoint getCurrentTermEnd() {
        return this.getMapTimePointValue(DataAttribute.CURRENT_TERM_END.name());
    }

    public TimePoint getCancelledAt() {
        return this.getMapTimePointValue(DataAttribute.CANCELLED_AT.name());
    }

    public TimePoint getSubscriptionActivatedAt() {
        return this.getMapTimePointValue(DataAttribute.SUBSCRIPTION_ACTIVATED_AT.name());
    }

    public Integer getReocurringPaymentValue() {
        return this.getMapIntegerValue(DataAttribute.REOCURRING_PAYMENT_VALUE.name());
    }

    public String getCurrencyCode() {
        return this.getMapStringValue(DataAttribute.CURRENCY_CODE.name());
    }

    private String getMapStringValue(String key) {
        Object valObj = this.data.get(key);
        String val = valObj != null ? (String)valObj : null;
        return val;
    }

    private Integer getMapIntegerValue(String key) {
        Object valObj = this.data.get(key);
        Integer val = valObj != null ? (Integer)valObj : null;
        return val;
    }

    private TimePoint getMapTimePointValue(String key) {
        Object valObj = this.data.get(key);
        TimePoint val = valObj != null ? Subscription.getTime((long)((Long)valObj)) : Subscription.getTime((long)0L);
        return val;
    }

    public static enum DataAttribute {
        SUBSCRIPTION_ID,
        CUSTOMER_ID,
        PLAN_ID,
        TRIAL_START,
        TRIAL_END,
        SUBSCRIPTION_STATUS,
        PAYMENT_STATUS,
        TRANSACTION_TYPE,
        TRANSACTION_STATUS,
        INVOICE_ID,
        INVOICE_STATUS,
        SUBSCRIPTION_CREATED_AT,
        SUBSCRIPTION_UPDATED_AT,
        LATEST_EVENT_TIME,
        MANUAL_UPDATED_AT,
        PROVIDER_NAME,
        NEXT_BILLING_AT,
        CURRENT_TERM_END,
        CANCELLED_AT,
        SUBSCRIPTION_ACTIVATED_AT,
        REOCURRING_PAYMENT_VALUE,
        CURRENCY_CODE;

    }
}

