/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sailing.domain.tracking.impl.UpdateHandler;
import com.sap.sse.common.TimePoint;
import com.sap.sse.util.HttpUrlConnectionHelper;
import com.sap.sse.util.LaxRedirectStrategyForAllRedirectResponseCodes;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.parser.ParseException;

public class FinishTimeUpdateHandler
extends UpdateHandler {
    private static final Logger logger = Logger.getLogger(FinishTimeUpdateHandler.class.getName());
    private static final String ACTION_STOP_TRACKING = "end_tracking";
    private static final String FIELD_TRACKING_END_TIME = "tracking_end_time";
    private final Regatta regatta;

    public FinishTimeUpdateHandler(URI updateURI, String tracTracApiToken, Serializable eventId, Serializable raceId, Regatta regatta) {
        super(updateURI, ACTION_STOP_TRACKING, tracTracApiToken, eventId, raceId);
        this.regatta = regatta;
    }

    public Listener getListener() {
        return new Listener();
    }

    private class Listener
    extends AbstractRaceChangeListener {
        private Listener() {
        }

        @Override
        public void finishedTimeChanged(TimePoint oldFinishedTime, TimePoint newFinishedTime) {
            if (FinishTimeUpdateHandler.this.isActive() && newFinishedTime != null && FinishTimeUpdateHandler.this.regatta.isControlTrackingFromStartAndFinishTimes()) {
                try {
                    URI stopTrackingURI = FinishTimeUpdateHandler.this.getActionURI(FinishTimeUpdateHandler.ACTION_STOP_TRACKING);
                    HttpPost request = new HttpPost(stopTrackingURI);
                    List<BasicNameValuePair> params = FinishTimeUpdateHandler.this.getDefaultParametersAsNewList();
                    params.add(new BasicNameValuePair(FinishTimeUpdateHandler.FIELD_TRACKING_END_TIME, String.valueOf(newFinishedTime.plus(TrackedRace.STOP_TRACKING_THIS_MUCH_AFTER_RACE_FINISH).asMillis())));
                    request.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                    CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategyForAllRedirectResponseCodes()).build();
                    logger.info("Using " + FinishTimeUpdateHandler.this.eraseSecurityRelatedValuesFromURL(stopTrackingURI.toString()) + " to stop tracking");
                    CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                    try {
                        FinishTimeUpdateHandler.this.parseAndLogResponse(new BufferedReader(new InputStreamReader(response.getEntity().getContent(), HttpUrlConnectionHelper.getCharsetFromHttpEntity((HttpEntity)response.getEntity(), (String)"UTF-8"))));
                    }
                    catch (ParseException e) {
                        logger.log(Level.INFO, "Error parsing TracTrac response for stop tracking", e);
                    }
                }
                catch (IOException | URISyntaxException ioe) {
                    logger.log(Level.INFO, "Exception trying to stop TracTrac tracking", ioe);
                }
            }
        }
    }
}

