/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogCourseDesignChangedEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.LastPublishedCourseDesignFinder;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tracking.RaceTrackerListeners;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Util;
import difflib.PatchFailedException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractRaceTrackerBaseImpl<RTCP extends RaceTrackingConnectivityParameters>
implements RaceTracker {
    private static final Logger logger = Logger.getLogger(AbstractRaceTrackerBaseImpl.class.getName());
    private final RaceTrackerListeners listeners = new RaceTrackerListeners();
    private final Set<RaceTracker.RaceCreationListener> raceCreationListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final RTCP connectivityParams;

    public AbstractRaceTrackerBaseImpl(RTCP connectivityParams) {
        this.connectivityParams = connectivityParams;
    }

    protected void onCourseDesignChangedEvent(RaceLogCourseDesignChangedEvent event, RaceLog raceLog, DomainFactory baseDomainFactory, TrackedRace trackedRace) {
        if (trackedRace != null) {
            CourseBase base = (CourseBase)new LastPublishedCourseDesignFinder(raceLog, true).analyze();
            ArrayList<Util.Pair<ControlPoint, PassingInstruction>> update = new ArrayList<Util.Pair<ControlPoint, PassingInstruction>>();
            for (Waypoint waypoint : base.getWaypoints()) {
                update.add(new Util.Pair((Object)waypoint.getControlPoint(), (Object)waypoint.getPassingInstructions()));
            }
            try {
                Course course = trackedRace.getRace().getCourse();
                course.update(update, event.getCourseDesign().getAssociatedRoles(), event.getCourseDesign().getOriginatingCourseTemplateIdOrNull(), baseDomainFactory);
                if (base.getName() != null) {
                    course.setName(base.getName());
                }
            }
            catch (PatchFailedException e) {
                logger.log(Level.WARNING, "Could not update course for race " + trackedRace.getRace().getName());
            }
        }
    }

    @Override
    public final void stop(boolean preemptive) throws MalformedURLException, IOException, InterruptedException {
        this.stop(preemptive, false);
    }

    @Override
    public final void stop(boolean preemptive, boolean willBeRemoved) throws MalformedURLException, IOException, InterruptedException {
        try {
            this.listeners.onTrackerWillStop(preemptive, willBeRemoved);
        }
        finally {
            this.onStop(preemptive, willBeRemoved);
        }
    }

    protected void onStop(boolean preemptive, boolean willBeRemoved) throws MalformedURLException, IOException, InterruptedException {
    }

    @Override
    public boolean add(RaceTracker.Listener listener) {
        return this.listeners.addListener(listener);
    }

    @Override
    public void remove(RaceTracker.Listener listener) {
        this.listeners.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(RaceTracker.RaceCreationListener listener) {
        RaceDefinition race;
        Set<RaceTracker.RaceCreationListener> set = this.raceCreationListeners;
        synchronized (set) {
            race = this.getRace();
            if (race == null) {
                this.raceCreationListeners.add(listener);
            }
        }
        if (race != null) {
            listener.onRaceCreated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(RaceTracker.RaceCreationListener listener) {
        Set<RaceTracker.RaceCreationListener> set = this.raceCreationListeners;
        synchronized (set) {
            this.raceCreationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRaceCreationListeners() {
        HashSet<RaceTracker.RaceCreationListener> listenersToNotify;
        assert (this.getRace() != null);
        Set<RaceTracker.RaceCreationListener> set = this.raceCreationListeners;
        synchronized (set) {
            listenersToNotify = new HashSet<RaceTracker.RaceCreationListener>(this.raceCreationListeners);
            this.raceCreationListeners.clear();
        }
        listenersToNotify.forEach(l -> l.onRaceCreated(this));
    }

    public RTCP getConnectivityParams() {
        return this.connectivityParams;
    }
}

