/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassingcalculation.impl;

import com.sap.sailing.domain.markpassingcalculation.Candidate;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.TimeRangeImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class MostProbableCandidatesInSmallTimeRangeFilter {
    public static final Duration CANDIDATE_FILTER_TIME_WINDOW = Duration.ONE_SECOND.times(5L);
    private static final double MAX_PROBABILITY_DELTA = 0.2;
    private final NavigableSet<Candidate> filteredCandidates;
    private final Comparator<Candidate> candidateComparator;
    private final Candidate startProxyCandidate;
    private final Candidate endProxyCandidate;

    public MostProbableCandidatesInSmallTimeRangeFilter(Comparator<Candidate> candidateComparator, Candidate startProxyCandidate, Candidate endProxyCandidate) {
        this.candidateComparator = candidateComparator;
        this.filteredCandidates = new TreeSet<Candidate>(candidateComparator);
        this.startProxyCandidate = startProxyCandidate;
        this.endProxyCandidate = endProxyCandidate;
    }

    Util.Pair<Set<Candidate>, Set<Candidate>> updateCandidates(NavigableSet<Candidate> competitorCandidates, Iterable<Candidate> newCandidates, Iterable<Candidate> removedCandidates) {
        assert (Util.containsAll(competitorCandidates, newCandidates));
        assert (!competitorCandidates.stream().filter(c -> Util.contains((Iterable)removedCandidates, (Object)c)).findAny().isPresent());
        TreeSet<Candidate> candidatesAddedToFiltered = new TreeSet<Candidate>(this.candidateComparator);
        TreeSet<Candidate> candidatesRemovedFromFiltered = new TreeSet<Candidate>(this.candidateComparator);
        TreeSet<Candidate> newCandidatesModifiableCopy = new TreeSet<Candidate>(this.candidateComparator);
        TreeSet<Candidate> removedCandidatesModifiableCopy = new TreeSet<Candidate>(this.candidateComparator);
        Util.addAll(newCandidates, newCandidatesModifiableCopy);
        Util.addAll(removedCandidates, removedCandidatesModifiableCopy);
        this.filterStartAndEndCandidates(newCandidatesModifiableCopy, removedCandidatesModifiableCopy, candidatesAddedToFiltered, candidatesRemovedFromFiltered);
        HashSet<NavigableSet<Candidate>> disjointSequencesAffectedByNewAndRemovedCandidates = new HashSet<NavigableSet<Candidate>>();
        while (!newCandidatesModifiableCopy.isEmpty()) {
            Candidate candidate = (Candidate)newCandidatesModifiableCopy.iterator().next();
            newCandidatesModifiableCopy.remove(candidate);
            NavigableSet<Candidate> contiguousSequenceForNextNewCandidate = this.getTimeWiseContiguousCandidates(competitorCandidates, candidate, true);
            disjointSequencesAffectedByNewAndRemovedCandidates.add(contiguousSequenceForNextNewCandidate);
            Util.removeAll(contiguousSequenceForNextNewCandidate, newCandidatesModifiableCopy);
            this.removeAllRemovedCandidatesInOrNearSequence(contiguousSequenceForNextNewCandidate, removedCandidatesModifiableCopy);
        }
        Util.addAll(removedCandidates, candidatesRemovedFromFiltered);
        candidatesRemovedFromFiltered.retainAll(this.filteredCandidates);
        while (!removedCandidatesModifiableCopy.isEmpty()) {
            Candidate candidate = (Candidate)removedCandidatesModifiableCopy.iterator().next();
            removedCandidatesModifiableCopy.remove(candidate);
            NavigableSet<Candidate> contiguousSequenceForNextRemovedCandidate = this.getTimeWiseContiguousCandidates(competitorCandidates, candidate, false);
            this.removeAllRemovedCandidatesInOrNearSequence(contiguousSequenceForNextRemovedCandidate, removedCandidatesModifiableCopy);
            Util.addAll(this.splitIfGapAroundRemovedCandidateIsTooLarge(contiguousSequenceForNextRemovedCandidate, candidate), disjointSequencesAffectedByNewAndRemovedCandidates);
        }
        for (SortedSet sortedSet : disjointSequencesAffectedByNewAndRemovedCandidates) {
            this.findNewAndRemovedCandidates(sortedSet, candidatesAddedToFiltered, candidatesRemovedFromFiltered);
        }
        assert (!new HashSet<Candidate>(candidatesAddedToFiltered).removeAll(this.filteredCandidates));
        this.filteredCandidates.addAll(candidatesAddedToFiltered);
        assert (!new HashSet<Candidate>(candidatesRemovedFromFiltered).retainAll(this.filteredCandidates));
        assert (!new HashSet<Candidate>(candidatesAddedToFiltered).removeAll(candidatesRemovedFromFiltered));
        this.filteredCandidates.removeAll(candidatesRemovedFromFiltered);
        return new Util.Pair(candidatesAddedToFiltered, candidatesRemovedFromFiltered);
    }

    private void findNewAndRemovedCandidates(SortedSet<Candidate> contiguousCandidateSequence, Set<Candidate> candidatesAddedToFiltered, Set<Candidate> candidatesRemovedFromFiltered) {
        if (!contiguousCandidateSequence.isEmpty()) {
            Candidate currentCandidate;
            NavigableSet<Candidate> candidatesPreviouslyPassingFilter = this.filteredCandidates.subSet(contiguousCandidateSequence.first(), true, contiguousCandidateSequence.last(), true);
            ArrayList<Candidate> sortedByProbabilityFromLowToHigh = new ArrayList<Candidate>(contiguousCandidateSequence);
            Collections.sort(sortedByProbabilityFromLowToHigh, (c1, c2) -> Double.compare(c1.getProbability(), c2.getProbability()));
            double maxProbability = sortedByProbabilityFromLowToHigh.get(sortedByProbabilityFromLowToHigh.size() - 1).getProbability();
            TreeSet<Candidate> candidatesAcceptedFromSequence = new TreeSet<Candidate>(this.candidateComparator);
            int i = sortedByProbabilityFromLowToHigh.size() - 1;
            while (i >= 0 && (currentCandidate = sortedByProbabilityFromLowToHigh.get(i)).getProbability() + 0.2 >= maxProbability) {
                candidatesAcceptedFromSequence.add(currentCandidate);
                if (!candidatesPreviouslyPassingFilter.contains(currentCandidate)) {
                    candidatesAddedToFiltered.add(currentCandidate);
                }
                --i;
            }
            for (Candidate candidateThatPreviouslyPassedFilter : candidatesPreviouslyPassingFilter) {
                if (candidatesAcceptedFromSequence.contains(candidateThatPreviouslyPassedFilter)) continue;
                candidatesRemovedFromFiltered.add(candidateThatPreviouslyPassedFilter);
            }
        }
    }

    private Iterable<SortedSet<Candidate>> splitIfGapAroundRemovedCandidateIsTooLarge(NavigableSet<Candidate> contiguousSequenceForNextRemovedCandidate, Candidate nextRemovedCandidate) {
        Candidate firstAfter;
        Candidate lastBefore = contiguousSequenceForNextRemovedCandidate.lower(nextRemovedCandidate);
        Collection<SortedSet<Object>> result = lastBefore != null ? ((firstAfter = contiguousSequenceForNextRemovedCandidate.higher(nextRemovedCandidate)) != null && lastBefore.getTimePoint().until(firstAfter.getTimePoint()).compareTo((Object)CANDIDATE_FILTER_TIME_WINDOW) > 0 ? Arrays.asList(contiguousSequenceForNextRemovedCandidate.headSet(nextRemovedCandidate), contiguousSequenceForNextRemovedCandidate.tailSet(nextRemovedCandidate, false)) : Collections.singleton(contiguousSequenceForNextRemovedCandidate)) : Collections.singleton(contiguousSequenceForNextRemovedCandidate);
        return result;
    }

    private void removeAllRemovedCandidatesInOrNearSequence(NavigableSet<Candidate> contiguousSequenceForNextNewCandidate, Set<Candidate> removedCandidatesModifiableCopy) {
        if (!contiguousSequenceForNextNewCandidate.isEmpty()) {
            TimeRangeImpl sequenceTimeRange = new TimeRangeImpl(((Candidate)contiguousSequenceForNextNewCandidate.first()).getTimePoint(), ((Candidate)contiguousSequenceForNextNewCandidate.last()).getTimePoint());
            Iterator<Candidate> removedCandidateIter = removedCandidatesModifiableCopy.iterator();
            while (removedCandidateIter.hasNext()) {
                Candidate removedCandidate = removedCandidateIter.next();
                if (sequenceTimeRange.timeDifference(removedCandidate.getTimePoint()).compareTo((Object)CANDIDATE_FILTER_TIME_WINDOW) > 0) continue;
                removedCandidateIter.remove();
            }
        }
    }

    public NavigableSet<Candidate> getTimeWiseContiguousCandidates(NavigableSet<Candidate> competitorCandidates, Candidate startFrom, boolean includeStartFrom) {
        TreeSet<Candidate> result = new TreeSet<Candidate>(this.candidateComparator);
        if (includeStartFrom) {
            result.add(startFrom);
        }
        this.addContiguousCandidates(competitorCandidates.descendingSet().tailSet(startFrom, false), startFrom, result);
        this.addContiguousCandidates(competitorCandidates.tailSet(startFrom, false), startFrom, result);
        return result;
    }

    private void addContiguousCandidates(Iterable<Candidate> candidates, Candidate startFrom, Collection<Candidate> addTo) {
        Candidate current = startFrom;
        for (Candidate next : candidates) {
            if (next == this.startProxyCandidate || next == this.endProxyCandidate) continue;
            if (next.getTimePoint().until(current.getTimePoint()).abs().compareTo((Object)CANDIDATE_FILTER_TIME_WINDOW) > 0) break;
            addTo.add(next);
            current = next;
        }
    }

    private void filterStartAndEndCandidates(Set<Candidate> newCandidatesModifiableCopy, Set<Candidate> removedCandidatesModifiableCopy, Set<Candidate> candidatesAddedToFiltered, Set<Candidate> candidatesRemovedFromFiltered) {
        for (Candidate startAndEnd : Arrays.asList(this.startProxyCandidate, this.endProxyCandidate)) {
            if (newCandidatesModifiableCopy.remove(startAndEnd)) {
                candidatesAddedToFiltered.add(startAndEnd);
            }
            if (!removedCandidatesModifiableCopy.remove(startAndEnd)) continue;
            candidatesRemovedFromFiltered.add(startAndEnd);
        }
    }

    Iterable<Candidate> getFilteredCandidates() {
        return this.filteredCandidates;
    }
}

