/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.maneuverdetection.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.BearingChangeAnalyzer;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.maneuverdetection.ManeuverDetector;
import com.sap.sailing.domain.maneuverdetection.TrackTimeInfo;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import java.util.NavigableSet;

public abstract class AbstractManeuverDetectorImpl
implements ManeuverDetector {
    protected final TrackedRace trackedRace;
    protected final Competitor competitor;
    protected final GPSFixTrack<Competitor, GPSFixMoving> track;

    public AbstractManeuverDetectorImpl(TrackedRace trackedRace, Competitor competitor) {
        this.trackedRace = trackedRace;
        this.competitor = competitor;
        this.track = trackedRace != null ? trackedRace.getTrack(competitor) : null;
    }

    @Override
    public TrackTimeInfo getTrackTimeInfo() {
        GPSFixMoving firstRawFix;
        NavigableSet<MarkPassing> markPassings = this.trackedRace.getMarkPassings(this.competitor);
        TimePoint earliestTrackRecord = null;
        TimePoint latestRawFixTimePoint = null;
        MarkPassing crossedFinishLine = null;
        Waypoint lastWaypoint = this.trackedRace.getRace().getCourse().getLastWaypoint();
        if (lastWaypoint != null) {
            this.trackedRace.lockForRead(markPassings);
            try {
                if (markPassings != null && !markPassings.isEmpty()) {
                    earliestTrackRecord = markPassings.iterator().next().getTimePoint();
                    crossedFinishLine = this.trackedRace.getMarkPassing(this.competitor, lastWaypoint);
                }
            }
            finally {
                this.trackedRace.unlockAfterRead(markPassings);
            }
        }
        if (earliestTrackRecord == null && (firstRawFix = (GPSFixMoving)this.track.getFirstRawFix()) != null) {
            earliestTrackRecord = firstRawFix.getTimePoint();
        }
        if (earliestTrackRecord != null) {
            GPSFixMoving lastRawFix;
            TimePoint latestTrackRecord;
            if (crossedFinishLine != null) {
                latestTrackRecord = crossedFinishLine.getTimePoint();
            } else {
                lastRawFix = (GPSFixMoving)this.track.getLastRawFix();
                if (lastRawFix != null) {
                    latestRawFixTimePoint = latestTrackRecord = lastRawFix.getTimePoint();
                } else {
                    latestTrackRecord = null;
                }
            }
            if (latestTrackRecord != null) {
                if (latestRawFixTimePoint == null && (lastRawFix = (GPSFixMoving)this.track.getLastRawFix()) != null) {
                    latestRawFixTimePoint = lastRawFix.getTimePoint();
                }
                if (latestRawFixTimePoint != null) {
                    if (!earliestTrackRecord.equals(latestTrackRecord)) {
                        return new TrackTimeInfo(earliestTrackRecord, latestTrackRecord, latestRawFixTimePoint);
                    }
                    GPSFixMoving firstRawFix2 = (GPSFixMoving)this.track.getFirstRawFix();
                    if (firstRawFix2 != null) {
                        return new TrackTimeInfo(firstRawFix2.getTimePoint(), latestRawFixTimePoint, latestRawFixTimePoint);
                    }
                }
            }
        }
        return null;
    }

    protected int getNumberOfJibes(ManeuverCurveBoundaries maneuverBoundaries, Wind wind) {
        BearingChangeAnalyzer bearingChangeAnalyzer = BearingChangeAnalyzer.INSTANCE;
        int numberOfJibes = wind == null ? 0 : bearingChangeAnalyzer.didPass(maneuverBoundaries.getSpeedWithBearingBefore().getBearing(), maneuverBoundaries.getDirectionChangeInDegrees(), maneuverBoundaries.getSpeedWithBearingAfter().getBearing(), wind.getBearing());
        return numberOfJibes;
    }

    protected int getNumberOfTacks(ManeuverCurveBoundaries maneuverBoundaries, Wind wind) {
        BearingChangeAnalyzer bearingChangeAnalyzer = BearingChangeAnalyzer.INSTANCE;
        int numberOfTacks = wind == null ? 0 : bearingChangeAnalyzer.didPass(maneuverBoundaries.getSpeedWithBearingBefore().getBearing(), maneuverBoundaries.getDirectionChangeInDegrees(), maneuverBoundaries.getSpeedWithBearingAfter().getBearing(), wind.getFrom());
        return numberOfTacks;
    }

    protected NauticalSide getDirectionOfCourseChange(double courseChangeInDegrees) {
        return courseChangeInDegrees < 0.0 ? NauticalSide.PORT : NauticalSide.STARBOARD;
    }

    protected Duration getApproximateManeuverDuration() {
        return this.trackedRace.getRace().getBoatOfCompetitor(this.competitor).getBoatClass().getApproximateManeuverDuration();
    }
}

