/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.impl.LeaderboardGroupBaseImpl;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.LeaderboardGroupListener;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class LeaderboardGroupImpl
extends LeaderboardGroupBaseImpl
implements LeaderboardGroup {
    private static final long serialVersionUID = 2035927369446736934L;
    private boolean displayGroupsInReverseOrder;
    private final NamedReentrantReadWriteLock leaderboardsLock;
    private final List<Leaderboard> leaderboards;
    private final Set<LeaderboardGroupListener> listeners;
    private Leaderboard overallLeaderboard;

    public LeaderboardGroupImpl(String name, String description, String displayName, boolean displayGroupsInReverseOrder, List<? extends Leaderboard> leaderboards) {
        this(UUID.randomUUID(), name, description, displayName, displayGroupsInReverseOrder, leaderboards);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.leaderboardsLock);
        try {
            oos.defaultWriteObject();
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.leaderboardsLock);
        }
    }

    public LeaderboardGroupImpl(UUID id, String name, String description, String displayName, boolean displayGroupsInReverseOrder, List<? extends Leaderboard> leaderboards) {
        super(id, name, description, displayName);
        this.leaderboardsLock = new NamedReentrantReadWriteLock("leaderboards lock fo rleaderboard group " + name, false);
        this.displayGroupsInReverseOrder = displayGroupsInReverseOrder;
        this.leaderboards = new ArrayList<Leaderboard>(leaderboards);
        this.listeners = new HashSet<LeaderboardGroupListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLeaderboardGroupListener(LeaderboardGroupListener listener) {
        Set<LeaderboardGroupListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLeaderboardGroupListener(LeaderboardGroupListener listener) {
        Set<LeaderboardGroupListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<LeaderboardGroupListener> getLeaderboardGroupListeners() {
        Set<LeaderboardGroupListener> set = this.listeners;
        synchronized (set) {
            return new HashSet<LeaderboardGroupListener>(this.listeners);
        }
    }

    private void notifyLeaderboardGroupListenersAboutLeaderboardAdded(Leaderboard leaderboard) {
        for (LeaderboardGroupListener listener : this.getLeaderboardGroupListeners()) {
            listener.leaderboardAdded(this, leaderboard);
        }
    }

    private void notifyLeaderboardGroupListenersAboutLeaderboardRemoved(Leaderboard leaderboard) {
        for (LeaderboardGroupListener listener : this.getLeaderboardGroupListeners()) {
            listener.leaderboardRemoved(this, leaderboard);
        }
    }

    @Override
    public Leaderboard getOverallLeaderboard() {
        return this.overallLeaderboard;
    }

    public boolean hasOverallLeaderboard() {
        return this.getOverallLeaderboard() != null;
    }

    public String getOverallLeaderboardName() {
        return this.hasOverallLeaderboard() ? this.getOverallLeaderboard().getName() : null;
    }

    @Override
    public void setOverallLeaderboard(Leaderboard overallLeaderboard) {
        this.overallLeaderboard = overallLeaderboard;
    }

    @Override
    public Iterable<Leaderboard> getLeaderboards() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.leaderboardsLock);
        try {
            ArrayList<Leaderboard> arrayList = new ArrayList<Leaderboard>(this.leaderboards);
            return arrayList;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.leaderboardsLock);
        }
    }

    @Override
    public int getIndexOf(Leaderboard leaderboard) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.leaderboardsLock);
        try {
            int n = this.leaderboards.indexOf(leaderboard);
            return n;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.leaderboardsLock);
        }
    }

    @Override
    public void addLeaderboard(Leaderboard leaderboard) {
        if (leaderboard == this.overallLeaderboard) {
            throw new IllegalArgumentException("Cannot insert the overall leaderboard into its own leaderboard group");
        }
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardsLock);
        try {
            this.addLeaderboardAt(leaderboard, this.leaderboards.size());
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardsLock);
        }
    }

    @Override
    public void addLeaderboardAt(Leaderboard leaderboard, int index) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardsLock);
        try {
            this.leaderboards.add(index, leaderboard);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardsLock);
        }
        this.notifyLeaderboardGroupListenersAboutLeaderboardAdded(leaderboard);
    }

    @Override
    public void addAllLeaderboards(Collection<Leaderboard> leaderboards) {
        for (Leaderboard leaderboard : leaderboards) {
            this.addLeaderboard(leaderboard);
        }
    }

    @Override
    public void removeLeaderboard(Leaderboard leaderboard) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardsLock);
        try {
            this.leaderboards.remove(leaderboard);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardsLock);
        }
        this.notifyLeaderboardGroupListenersAboutLeaderboardRemoved(leaderboard);
    }

    @Override
    public void removeAllLeaderboards(Collection<Leaderboard> leaderboards) {
        for (Leaderboard leaderboard : leaderboards) {
            this.removeLeaderboard(leaderboard);
        }
    }

    @Override
    public void clearLeaderboards() {
        for (Leaderboard leaderboard : this.getLeaderboards()) {
            this.removeLeaderboard(leaderboard);
        }
    }

    @Override
    public boolean isDisplayGroupsInReverseOrder() {
        return this.displayGroupsInReverseOrder;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " " + this.getDescription();
    }
}

