/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.tracking.TrackedRace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TrackedRaces
implements Serializable {
    private static final long serialVersionUID = -5521115213267651333L;
    private transient ThreadLocal<Boolean> ongoingMasterDataExport;
    private Map<Fleet, TrackedRace> trackedRaces;
    private Map<Competitor, TrackedRace> racesByCompetitor;

    public TrackedRaces(Map<Fleet, TrackedRace> trackedRaces) {
        this.trackedRaces = trackedRaces;
        this.racesByCompetitor = new HashMap<Competitor, TrackedRace>();
        for (TrackedRace trackedRace : trackedRaces.values()) {
            this.updateRaceByCompetitor(trackedRace);
        }
        this.ongoingMasterDataExport = this.createOngoingMasterDataExportThreadLocal();
    }

    private void updateRaceByCompetitor(TrackedRace trackedRace) {
        for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
            this.racesByCompetitor.put(competitor, trackedRace);
        }
    }

    public TrackedRaces() {
        this(new HashMap<Fleet, TrackedRace>());
    }

    public TrackedRace get(Competitor competitor) {
        return this.racesByCompetitor.get(competitor);
    }

    public TrackedRace get(Fleet fleet) {
        return this.trackedRaces.get(fleet);
    }

    public void put(Fleet fleet, TrackedRace trackedRace) {
        TrackedRace previousTrackedRace = this.trackedRaces.put(fleet, trackedRace);
        if (previousTrackedRace != null) {
            this.removeRaceByCompetitor(previousTrackedRace);
        }
        if (trackedRace != null) {
            this.updateRaceByCompetitor(trackedRace);
        }
    }

    private void removeRaceByCompetitor(TrackedRace previousTrackedRace) {
        for (Competitor previousCompetitor : previousTrackedRace.getRace().getCompetitors()) {
            this.racesByCompetitor.remove(previousCompetitor);
        }
    }

    public TrackedRace remove(Fleet fleet) {
        TrackedRace trackedRace = this.trackedRaces.remove(fleet);
        if (trackedRace != null) {
            this.removeRaceByCompetitor(trackedRace);
        }
        return trackedRace;
    }

    public Set<Map.Entry<Fleet, TrackedRace>> entrySet() {
        return this.trackedRaces.entrySet();
    }

    public boolean isEmpty() {
        return this.trackedRaces.isEmpty();
    }

    public Collection<TrackedRace> values() {
        return this.trackedRaces.values();
    }

    private ThreadLocal<Boolean> createOngoingMasterDataExportThreadLocal() {
        return new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
    }

    public void setMasterDataExportOngoingThreadFlag(boolean flagValue) {
        this.ongoingMasterDataExport.set(flagValue);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        boolean masterDataImportOngoing = ois.readBoolean();
        if (masterDataImportOngoing) {
            this.trackedRaces = new HashMap<Fleet, TrackedRace>();
            this.racesByCompetitor = new HashMap<Competitor, TrackedRace>();
        } else {
            ois.defaultReadObject();
        }
        this.ongoingMasterDataExport = this.createOngoingMasterDataExportThreadLocal();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Boolean masterDataExportOngoing = this.ongoingMasterDataExport.get();
        oos.writeBoolean(masterDataExportOngoing);
        if (!masterDataExportOngoing.booleanValue()) {
            oos.defaultWriteObject();
        }
    }
}

