/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventListener;
import com.sap.sailing.domain.base.Venue;
import com.sap.sailing.domain.base.impl.EventBaseImpl;
import com.sap.sailing.domain.base.impl.VenueImpl;
import com.sap.sailing.domain.common.Placemark;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalablePosition;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.shared.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.geocoding.ReverseGeocoder;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.scalablevalue.ScalableValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.parser.ParseException;

public class EventImpl
extends EventBaseImpl
implements Event {
    private static final long serialVersionUID = 855135446595485715L;
    private static final Logger logger = Logger.getLogger(EventImpl.class.getName());
    private final ConcurrentLinkedQueue<LeaderboardGroup> leaderboardGroups = new ConcurrentLinkedQueue();
    private final ConcurrentMap<String, Boolean> windFinderReviewedSpotsCollectionIds = new ConcurrentHashMap<String, Boolean>();
    private transient ConcurrentMap<EventListener, Boolean> eventListeners = new ConcurrentHashMap<EventListener, Boolean>();

    public EventImpl(String name, TimePoint startDate, TimePoint endDate, String venueName, boolean isPublic, UUID id) {
        this(name, startDate, endDate, (Venue)new VenueImpl(venueName), isPublic, id);
    }

    public EventImpl(String name, TimePoint startDate, TimePoint endDate, Venue venue, boolean isPublic, UUID id) {
        super(name, startDate, endDate, venue, isPublic, id);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        if (this.eventListeners == null) {
            this.eventListeners = new ConcurrentHashMap<EventListener, Boolean>();
        }
    }

    public String toString() {
        return this.getId() + " " + this.getName() + " " + this.getVenue().getName() + " " + this.isPublic();
    }

    @Override
    public Iterable<LeaderboardGroup> getLeaderboardGroups() {
        return Collections.unmodifiableCollection(this.leaderboardGroups);
    }

    @Override
    public void setLeaderboardGroups(Iterable<LeaderboardGroup> leaderboardGroups) {
        this.leaderboardGroups.clear();
        Util.addAll(leaderboardGroups, this.leaderboardGroups);
    }

    @Override
    public void addLeaderboardGroup(LeaderboardGroup leaderboardGroup) {
        this.leaderboardGroups.add(leaderboardGroup);
        this.eventListeners.keySet().forEach(eventListener -> eventListener.leaderboardGroupAdded(this, leaderboardGroup));
    }

    @Override
    public boolean removeLeaderboardGroup(LeaderboardGroup leaderboardGroup) {
        boolean result = this.leaderboardGroups.remove(leaderboardGroup);
        this.eventListeners.keySet().forEach(eventListener -> eventListener.leaderboardGroupRemoved(this, leaderboardGroup));
        return result;
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.eventListeners.put(eventListener, true);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    @Override
    public Iterable<String> getWindFinderReviewedSpotsCollectionIds() {
        return Collections.unmodifiableSet(this.windFinderReviewedSpotsCollectionIds.keySet());
    }

    @Override
    public Iterable<String> getAllFinderSpotIdsUsedByTrackedRacesInEvent() {
        HashSet<String> result = new HashSet<String>();
        for (LeaderboardGroup leaderboardGroup : this.getLeaderboardGroups()) {
            for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                for (TrackedRace trackedRace : leaderboard.getTrackedRaces()) {
                    for (WindSource windTrackerWindSource : trackedRace.getWindSources(WindSourceType.WINDFINDER)) {
                        result.add(windTrackerWindSource.getId().toString());
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void setWindFinderReviewedSpotsCollection(Iterable<String> reviewedSpotsCollectionIds) {
        this.windFinderReviewedSpotsCollectionIds.clear();
        for (String reviewedSpotsCollectionId : reviewedSpotsCollectionIds) {
            this.windFinderReviewedSpotsCollectionIds.putIfAbsent(reviewedSpotsCollectionId, true);
        }
    }

    public Set<TrackingConnectorInfo> getTrackingConnectorInfos() {
        HashSet<TrackingConnectorInfo> result = new HashSet<TrackingConnectorInfo>();
        for (LeaderboardGroup lbg : this.getLeaderboardGroups()) {
            for (Leaderboard lb : lbg.getLeaderboards()) {
                for (TrackedRace tr : lb.getTrackedRaces()) {
                    TrackingConnectorInfo trackingConnectorInfo = tr.getTrackingConnectorInfo();
                    if (trackingConnectorInfo == null) continue;
                    result.add(trackingConnectorInfo);
                }
            }
        }
        return result;
    }

    @Override
    public Position getLocation() {
        int MAX_NUMBER_OF_POSITION_SAMPLES = 5;
        HashSet<Position> positionSamples = new HashSet<Position>();
        for (LeaderboardGroup leaderboardGroup : this.getLeaderboardGroups()) {
            for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                if (!Util.containsAny(leaderboard.getCourseAreas(), (Iterable)this.getVenue().getCourseAreas())) continue;
                for (TrackedRace trackedRace : leaderboard.getTrackedRaces()) {
                    Position centerOfCourse;
                    if (trackedRace.getStartOfRace() == null || (centerOfCourse = trackedRace.getCenterOfCourse(trackedRace.getStartOfRace())) == null) continue;
                    positionSamples.add(centerOfCourse);
                    if (positionSamples.size() < 5) continue;
                    return this.getAveragePosition(positionSamples);
                }
            }
        }
        ReverseGeocoder geocoder = ReverseGeocoder.INSTANCE;
        try {
            Placemark placemark = geocoder.getPlacemark(this.getVenue().getName(), new Placemark.ByPopulation().reversed());
            if (placemark != null) {
                positionSamples.add(placemark.getPosition());
            }
        }
        catch (IOException | ParseException e) {
            logger.log(Level.WARNING, "Problem while trying to resolve venue name " + this.getVenue().getName() + " with geocoder", e);
        }
        return positionSamples.isEmpty() ? null : this.getAveragePosition(positionSamples);
    }

    private Position getAveragePosition(Set<Position> positionSamples) {
        ScalablePosition sum = null;
        boolean count = false;
        for (Position waypointPosition : positionSamples) {
            ScalablePosition p = new ScalablePosition(waypointPosition);
            sum = sum == null ? p : sum.add((ScalableValue)p);
        }
        Position result = sum == null ? null : sum.divide((double)count);
        return result;
    }
}

