/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.resultimport.impl;

import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.resultimport.CompetitorRow;
import com.sap.sailing.resultimport.RegattaResults;
import com.sap.sailing.resultimport.impl.ScoreCorrectionForRaceImpl;
import com.sap.sse.common.Util;
import java.util.ArrayList;

public class RegattaScoreCorrectionsImpl
implements RegattaScoreCorrections {
    private final ScoreCorrectionProvider provider;
    private final Iterable<RegattaScoreCorrections.ScoreCorrectionsForRace> scoreCorrectionsForRaces;

    public RegattaScoreCorrectionsImpl(ScoreCorrectionProvider scoreCorrectionProviderImpl, RegattaResults regattaResult) {
        this.provider = scoreCorrectionProviderImpl;
        ArrayList<RegattaScoreCorrections.ScoreCorrectionsForRace> scfr = new ArrayList<RegattaScoreCorrections.ScoreCorrectionsForRace>();
        int maxSize = this.getMaxListSize(regattaResult);
        int i = 0;
        while (i < maxSize) {
            scfr.add(new ScoreCorrectionForRaceImpl(regattaResult, i));
            ++i;
        }
        this.scoreCorrectionsForRaces = scfr;
    }

    private int getMaxListSize(RegattaResults regattaResult) {
        int result = 0;
        for (CompetitorRow competitorRow : regattaResult.getCompetitorResults()) {
            result = Math.max(result, Util.size(competitorRow.getRankAndMaxPointsReasonAndPointsAndDiscarded()));
        }
        return result;
    }

    public ScoreCorrectionProvider getProvider() {
        return this.provider;
    }

    public String getRegattaName() {
        return "Extreme Sailing Series";
    }

    public Iterable<RegattaScoreCorrections.ScoreCorrectionsForRace> getScoreCorrectionsForRaces() {
        return this.scoreCorrectionsForRaces;
    }
}

