/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;

public class TimeWindow<T extends Timed>
implements Iterator<Util.Pair<T, T>> {
    private final Iterator<T> iterator;
    private final Duration length;
    private final LinkedList<T> content;
    private T nextCandidate;
    private Iterator<T> nextSecondPairElement;
    private final Function<T, Object> equivalenceWrapperSupplier;
    private final Set<Object> equivalenceWrappersForContent;

    public TimeWindow(Iterator<T> iterator, Duration length) {
        this(iterator, length, null);
    }

    public TimeWindow(Iterator<T> iterator, Duration length, Function<T, Object> equivalenceWrapperSupplier) {
        this.equivalenceWrapperSupplier = equivalenceWrapperSupplier;
        this.equivalenceWrappersForContent = equivalenceWrapperSupplier == null ? null : new HashSet();
        this.iterator = iterator;
        this.length = length;
        this.content = new LinkedList();
        this.nextCandidate = iterator.hasNext() ? (Timed)iterator.next() : null;
        this.fill();
    }

    private void fill() {
        T candidate = this.nextCandidate;
        if (candidate != null) {
            do {
                if (this.content.size() < 2) {
                    while (!this.candidateFits(candidate)) {
                        this.removeFirstFromContent();
                    }
                }
                while (candidate != null && this.candidateFits(candidate)) {
                    this.add(candidate);
                    Timed timed = candidate = this.iterator.hasNext() ? (Timed)this.iterator.next() : null;
                }
            } while (this.content.size() < 2 && candidate != null);
        }
        this.nextCandidate = candidate;
        this.nextSecondPairElement = this.content.size() >= 2 ? this.content.listIterator(1) : null;
    }

    private void add(T candidate) {
        if (this.equivalenceWrapperSupplier == null || this.equivalenceWrappersForContent.add(this.equivalenceWrapperSupplier.apply(candidate))) {
            this.content.add(candidate);
        }
    }

    private void pop() {
        this.removeFirstFromContent();
        this.fill();
    }

    private void removeFirstFromContent() {
        Timed elementRemoved = (Timed)this.content.removeFirst();
        if (this.equivalenceWrapperSupplier != null) {
            this.equivalenceWrappersForContent.remove(this.equivalenceWrapperSupplier.apply(elementRemoved));
        }
    }

    private boolean candidateFits(T candidate) {
        return this.content.isEmpty() || ((Timed)this.content.getFirst()).getTimePoint().until(candidate.getTimePoint()).compareTo(this.length) <= 0;
    }

    @Override
    public boolean hasNext() {
        return this.nextSecondPairElement != null && this.nextSecondPairElement.hasNext();
    }

    @Override
    public Util.Pair<T, T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Util.Pair<Timed, Timed> result = new Util.Pair<Timed, Timed>((Timed)this.content.getFirst(), (Timed)this.nextSecondPairElement.next());
        if (!this.nextSecondPairElement.hasNext()) {
            this.pop();
        }
        return result;
    }
}

