/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.dialog;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.LongBox;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.sap.sse.common.Color;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ColorTextBox;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.controls.GenericListBox;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DialogUtils;
import com.sap.sse.gwt.client.dialog.DoubleBox;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Supplier;

public abstract class DataEntryDialog<T> {
    private final DialogBox dataEntryDialog;
    private Validator<T> validator;
    private final Button okButton;
    private final Button cancelButton;
    private final HTML statusLabel;
    private final FlowPanel errorListPanel;
    private final FlowPanel panelForAdditionalWidget;
    private final DockPanel buttonPanel;
    private final FlowPanel rightButtonPanel;
    private final FlowPanel leftButtonPanel;
    private final AsyncActionsExecutor validationExecutor = new AsyncActionsExecutor();
    protected static final String VALIDATION_ACTION_CATEGORY = "validation";
    private boolean dialogInInvalidState = false;

    public DataEntryDialog(String title, String message, String okButtonName, String cancelButtonName, Validator<T> validator, DialogCallback<T> callback) {
        this(title, message, okButtonName, cancelButtonName, validator, true, callback);
    }

    public DataEntryDialog(String title, String message, String okButtonName, String cancelButtonName, Validator<T> validator, boolean animationEnabled, final DialogCallback<T> callback) {
        this.dataEntryDialog = new DialogBox();
        this.dataEntryDialog.setText(title);
        this.dataEntryDialog.setGlassEnabled(true);
        this.validator = validator;
        this.okButton = new Button(okButtonName);
        this.okButton.getElement().getStyle().setMargin(3.0, Style.Unit.PX);
        this.okButton.ensureDebugId("OkButton");
        this.okButton.addStyleName("btn-lg");
        this.okButton.addStyleName("btn-primary");
        FlowPanel dialogFPanel = new FlowPanel();
        dialogFPanel.setWidth("100%");
        this.statusLabel = new HTML(SafeHtmlUtils.fromSafeConstant((String)"&nbsp;"));
        this.statusLabel.ensureDebugId("StatusLabel");
        dialogFPanel.add((Widget)this.statusLabel);
        this.errorListPanel = new FlowPanel();
        dialogFPanel.add((Widget)this.errorListPanel);
        if (message != null) {
            Label messageLabel = new Label(message);
            messageLabel.addStyleName("dialogMessageLabel");
            dialogFPanel.add((Widget)messageLabel);
        }
        this.panelForAdditionalWidget = new FlowPanel();
        this.panelForAdditionalWidget.setWidth("100%");
        dialogFPanel.add((Widget)this.panelForAdditionalWidget);
        this.buttonPanel = new DockPanel();
        this.buttonPanel.setWidth("100%");
        dialogFPanel.add((Widget)this.buttonPanel);
        this.rightButtonPanel = new FlowPanel();
        this.leftButtonPanel = new FlowPanel();
        this.leftButtonPanel.setStyleName("additionalWidgetsLeft");
        this.rightButtonPanel.setStyleName("additionalWidgetsRight");
        this.rightButtonPanel.add((Widget)this.okButton);
        this.buttonPanel.add((Widget)this.rightButtonPanel, DockPanel.EAST);
        this.buttonPanel.add((Widget)this.leftButtonPanel, DockPanel.WEST);
        if (cancelButtonName != null) {
            this.cancelButton = new Button(cancelButtonName);
            this.cancelButton.getElement().getStyle().setMargin(3.0, Style.Unit.PX);
            this.cancelButton.ensureDebugId("CancelButton");
            this.rightButtonPanel.add((Widget)this.cancelButton);
            this.cancelButton.addStyleName("btn-lg");
            this.cancelButton.addStyleName("btn-secondary");
            this.cancelButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    DataEntryDialog.this.dataEntryDialog.hide();
                    if (callback != null) {
                        callback.cancel();
                    }
                }
            });
        } else {
            this.cancelButton = null;
        }
        this.dataEntryDialog.setWidget((Widget)dialogFPanel);
        this.okButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataEntryDialog.this.ifLastValidationRequestSuccessful(() -> {
                    DataEntryDialog.this.dataEntryDialog.hide();
                    if (callback != null) {
                        callback.ok(DataEntryDialog.this.getResult());
                    }
                });
            }
        });
    }

    protected void ifLastValidationRequestSuccessful(Runnable callback) {
        this.validationExecutor.runAfterLastActionReturned(VALIDATION_ACTION_CATEGORY, () -> {
            if (!this.dialogInInvalidState) {
                callback.run();
            }
        });
    }

    public void setValidator(Validator<T> validator) {
        this.validator = validator;
    }

    protected void validateAndUpdate() {
        final T result = this.getResult();
        if (this.validator != null) {
            this.validator.validate(result, new AsyncCallback<String>(){

                public void onFailure(Throwable caught) {
                    this.onSuccess(caught.getMessage());
                }

                public void onSuccess(String errorMessage) {
                    boolean invalidState;
                    DataEntryDialog.this.errorListPanel.clear();
                    boolean bl = invalidState = errorMessage != null && !errorMessage.isEmpty();
                    if (invalidState != DataEntryDialog.this.dialogInInvalidState) {
                        DataEntryDialog.this.onInvalidStateChanged(invalidState);
                    }
                    if (invalidState) {
                        String[] errors = errorMessage.split("\\r?\\n|\\r");
                        if (errors.length > 1) {
                            int i = 0;
                            while (i < errors.length) {
                                GWT.log((String)(String.valueOf(i) + " - " + errors[i]));
                                HTML errorLabel = new HTML(SafeHtmlUtils.fromString((String)errors[i]));
                                errorLabel.setStyleName("errorLabel");
                                DataEntryDialog.this.errorListPanel.add((Widget)errorLabel);
                                ++i;
                            }
                            DataEntryDialog.this.statusLabel.setHTML(SafeHtmlUtils.fromSafeConstant((String)"&nbsp;"));
                        } else {
                            DataEntryDialog.this.statusLabel.setHTML(SafeHtmlUtils.fromString((String)errorMessage));
                            DataEntryDialog.this.statusLabel.setStyleName("errorLabel");
                        }
                        DataEntryDialog.this.getOkButton().setEnabled(false);
                    } else {
                        DataEntryDialog.this.statusLabel.setHTML(SafeHtmlUtils.fromSafeConstant((String)"&nbsp;"));
                        DataEntryDialog.this.onChange(result);
                        DataEntryDialog.this.getOkButton().setEnabled(true);
                    }
                }
            }, this.validationExecutor);
        }
    }

    protected void onChange(T result) {
    }

    protected void onInvalidStateChanged(boolean invalidState) {
        this.getOkButton().setEnabled(!invalidState);
        this.dialogInInvalidState = invalidState;
    }

    protected abstract T getResult();

    protected SuggestBox createSuggestBox(Iterable<String> suggestValues) {
        ArrayList suggestValuesAsCollection = new ArrayList();
        Util.addAll(suggestValues, suggestValuesAsCollection);
        MultiWordSuggestOracle oracle = new MultiWordSuggestOracle();
        oracle.addAll(suggestValuesAsCollection);
        oracle.setDefaultSuggestionsFromText(suggestValuesAsCollection);
        return this.createSuggestBox((SuggestOracle)oracle);
    }

    protected SuggestBox createSuggestBox(SuggestOracle suggestOracle) {
        SuggestBox result = new SuggestBox(suggestOracle);
        this.ensureHasValueIsValidated((HasValueChangeHandlers)result.getValueBox());
        this.ensureChangeableIsValidated((HasChangeHandlers)result.getValueBox());
        result.getValueBox().addKeyUpHandler(event -> this.validateAndUpdate());
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)result.getValueBox());
        return result;
    }

    public TextBox createTextBox(String initialValue) {
        return this.createTextBox(initialValue, 30);
    }

    public TextBox createTextBox(String initialValue, int visibleLength) {
        return this.configureTextBox(new TextBox(), initialValue, visibleLength);
    }

    public ColorTextBox createColorTextBox(Color initialValue) {
        return this.createColorTextBox(initialValue, 30);
    }

    public ColorTextBox createColorTextBox(Color initialValue, int visibleLength) {
        return this.configureTextBox(new ColorTextBox(), initialValue == null ? null : initialValue.getAsHtml(), visibleLength);
    }

    private <TextBoxType extends TextBox> TextBoxType configureTextBox(TextBoxType textBox, String initialValue, int visibleLength) {
        textBox.setVisibleLength(visibleLength);
        textBox.setText(initialValue == null ? "" : initialValue);
        DialogUtils.addFocusUponKeyUpToggler(textBox);
        this.ensureChangeableIsValidated((HasChangeHandlers)textBox);
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)textBox);
        return textBox;
    }

    public PasswordTextBox createPasswordTextBox(String initialValue) {
        return this.createPasswordTextBoxInternal(initialValue, 30);
    }

    public PasswordTextBox createPasswordTextBox(String initialValue, int visibleLength) {
        return this.createPasswordTextBoxInternal(initialValue, visibleLength);
    }

    private PasswordTextBox createPasswordTextBoxInternal(String initialValue, int visibleLength) {
        PasswordTextBox passwordTextBox = new PasswordTextBox();
        passwordTextBox.setVisibleLength(visibleLength);
        passwordTextBox.setText(initialValue == null ? "" : initialValue);
        DialogUtils.addFocusUponKeyUpToggler((FocusWidget)passwordTextBox);
        this.ensureChangeableIsValidated((HasChangeHandlers)passwordTextBox);
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)passwordTextBox);
        return passwordTextBox;
    }

    public TextArea createTextArea(String initialValue) {
        TextArea textArea = new TextArea();
        textArea.setText(initialValue == null ? "" : initialValue);
        DialogUtils.addFocusUponKeyUpToggler((FocusWidget)textArea);
        this.ensureChangeableIsValidated((HasChangeHandlers)textArea);
        DialogUtils.linkEscapeToButton(this.getCancelButton(), new HasAllKeyHandlers[]{textArea});
        return textArea;
    }

    public LongBox createLongBox(long initialValue, int visibleLength) {
        LongBox longBox = new LongBox();
        longBox.setVisibleLength(visibleLength);
        longBox.setValue((Object)initialValue);
        DialogUtils.addFocusUponKeyUpToggler((FocusWidget)longBox);
        this.ensureChangeableIsValidated((HasChangeHandlers)longBox);
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)longBox);
        return longBox;
    }

    public DoubleBox createDoubleBox(Double initialValue, int visibleLength) {
        return this.createDoubleBoxInternal(initialValue, visibleLength);
    }

    public DoubleBox createDoubleBox(int visibleLength) {
        return this.createDoubleBoxInternal(null, visibleLength);
    }

    private DoubleBox createDoubleBoxInternal(Double initialValue, int visibleLength) {
        DoubleBox doubleBox = new DoubleBox();
        doubleBox.setVisibleLength(visibleLength);
        doubleBox.setValue(initialValue);
        DialogUtils.addFocusUponKeyUpToggler((FocusWidget)doubleBox);
        this.ensureChangeableIsValidated((HasChangeHandlers)doubleBox);
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)doubleBox);
        return doubleBox;
    }

    public DateBox createDateBox(Date initialDate, int visibleLength) {
        return this.createDateBoxInternal(initialDate, visibleLength);
    }

    public DateBox createDateBox(long initialTimeInMs, int visibleLength) {
        return this.createDateBoxInternal(new Date(initialTimeInMs), visibleLength);
    }

    public DateBox createDateBox(int visibleLength) {
        return this.createDateBoxInternal(null, visibleLength);
    }

    private DateBox createDateBoxInternal(Date initialDate, int visibleLength) {
        DateBox dateBox = new DateBox();
        dateBox.getTextBox().setVisibleLength(visibleLength);
        dateBox.setFireNullValues(true);
        dateBox.setValue(initialDate);
        DialogUtils.addFocusUponKeyUpToggler((FocusWidget)dateBox.getTextBox());
        this.ensureHasValueIsValidated((HasValueChangeHandlers)dateBox);
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)dateBox.getTextBox());
        return dateBox;
    }

    public IntegerBox createIntegerBox(Integer initialValue, int visibleLength) {
        IntegerBox intBox = new IntegerBox();
        intBox.setVisibleLength(visibleLength);
        intBox.setValue(initialValue);
        DialogUtils.addFocusUponKeyUpToggler((FocusWidget)intBox);
        this.ensureChangeableIsValidated((HasChangeHandlers)intBox);
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)intBox);
        return intBox;
    }

    public LongBox createLongBoxWithOptionalValue(Long initialValue, int visibleLength) {
        LongBox longBox = new LongBox();
        longBox.setVisibleLength(visibleLength);
        longBox.setValue((Object)initialValue);
        DialogUtils.addFocusUponKeyUpToggler((FocusWidget)longBox);
        this.ensureChangeableIsValidated((HasChangeHandlers)longBox);
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)longBox);
        return longBox;
    }

    public Label createHeadlineLabel(String headlineText) {
        Label headlineLabel = new Label(headlineText);
        headlineLabel.getElement().getStyle().setFontWeight(Style.FontWeight.BOLD);
        headlineLabel.getElement().getStyle().setPaddingTop(1.0, Style.Unit.EM);
        return headlineLabel;
    }

    public FlowPanel createHeadline(String headlineText, boolean regularHeadline) {
        FlowPanel headlinePanel = new FlowPanel();
        Label headlineLabel = new Label(headlineText);
        if (regularHeadline) {
            headlinePanel.addStyleName("dialogInnerHeadline");
        } else {
            headlinePanel.addStyleName("dialogInnerHeadlineOther");
        }
        headlinePanel.add((Widget)headlineLabel);
        return headlinePanel;
    }

    public CheckBox createCheckbox(String checkboxLabel) {
        CheckBox result = new CheckBox(checkboxLabel);
        result.setWordWrap(false);
        this.ensureHasValueIsValidated((HasValueChangeHandlers)result);
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)result);
        return result;
    }

    public CheckBox registerCheckbox(CheckBox result) {
        result.setWordWrap(false);
        this.ensureHasValueIsValidated((HasValueChangeHandlers)result);
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)result);
        return result;
    }

    public <C extends HasValueChangeHandlers<?> & HasAllKeyHandlers> C create(Supplier<C> factory) {
        HasValueChangeHandlers control = (HasValueChangeHandlers)factory.get();
        this.ensureHasValueIsValidated(control);
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)control);
        return (C)control;
    }

    public void ensureHasValueIsValidated(HasValueChangeHandlers hasValue) {
        hasValue.addValueChangeHandler(event -> this.validateAndUpdate());
    }

    public void ensureChangeableIsValidated(HasChangeHandlers changeable) {
        changeable.addChangeHandler(event -> this.validateAndUpdate());
    }

    public void ensureFocusWidgetIsLinkedToKeyStrokes(HasAllKeyHandlers widget) {
        DialogUtils.linkEnterToButton(this.getOkButton(), widget);
        DialogUtils.linkEscapeToButton(this.getCancelButton(), widget);
    }

    public void addTooltip(IsWidget widget, String tooltip) {
        widget.asWidget().setTitle(tooltip);
    }

    public RadioButton createRadioButton(String radioButtonGroupName, String radioButtonLabel) {
        RadioButton result = new RadioButton(radioButtonGroupName, radioButtonLabel);
        result.setWordWrap(false);
        this.ensureHasValueIsValidated((HasValueChangeHandlers)result);
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)result);
        return result;
    }

    public Label createLabel(String name) {
        Label result = new Label(String.valueOf(name) + ":");
        result.setWordWrap(false);
        return result;
    }

    public <ListItemT> GenericListBox<ListItemT> createGenericListBox(GenericListBox.ValueBuilder<ListItemT> valueBuilder, boolean isMultipleSelect) {
        GenericListBox<ListItemT> result = new GenericListBox<ListItemT>(valueBuilder);
        result.setMultipleSelect(isMultipleSelect);
        this.ensureChangeableIsValidated((HasChangeHandlers)result);
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)result);
        return result;
    }

    public ListBox createListBox(boolean isMultipleSelect) {
        ListBox result = new ListBox();
        result.setMultipleSelect(isMultipleSelect);
        this.ensureChangeableIsValidated((HasChangeHandlers)result);
        this.ensureFocusWidgetIsLinkedToKeyStrokes((HasAllKeyHandlers)result);
        return result;
    }

    public void alignAllPanelWidgetsVertically(HorizontalPanel panel, HasVerticalAlignment.VerticalAlignmentConstant alignment) {
        int i = 0;
        while (i < panel.getWidgetCount()) {
            panel.setCellVerticalAlignment(panel.getWidget(i), alignment);
            ++i;
        }
    }

    protected Widget getAdditionalWidget() {
        return null;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Button getCancelButton() {
        return this.cancelButton;
    }

    protected Label getStatusLabel() {
        return this.statusLabel;
    }

    protected void setCursor(Style.Cursor cursor) {
        this.dataEntryDialog.getElement().getStyle().setCursor(cursor);
    }

    public void center() {
        this.dataEntryDialog.center();
    }

    public void show() {
        Widget additionalWidget = this.getAdditionalWidget();
        if (additionalWidget != null) {
            this.panelForAdditionalWidget.add(additionalWidget);
        }
        this.validateAndUpdate();
        this.dataEntryDialog.center();
        final Focusable focusWidget = this.getInitialFocusWidget();
        if (focusWidget != null) {
            if (!(focusWidget instanceof HasEnabled) || ((HasEnabled)focusWidget).isEnabled()) {
                Scheduler.get().scheduleFinally(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        focusWidget.setFocus(true);
                    }
                });
            } else {
                DialogUtils.linkEscapeToButton(this.okButton, new HasAllKeyHandlers[]{this.okButton});
                Scheduler.get().scheduleFinally(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        DataEntryDialog.this.okButton.setFocus(true);
                    }
                });
            }
        } else {
            this.okButton.setFocus(true);
        }
    }

    protected Focusable getInitialFocusWidget() {
        return this.okButton;
    }

    protected DialogBox getDialogBox() {
        return this.dataEntryDialog;
    }

    public void ensureDebugId(String debugId) {
        this.dataEntryDialog.ensureDebugId(debugId);
    }

    protected void addAutoHidePartner(Element element) {
        this.dataEntryDialog.addAutoHidePartner(element);
    }

    protected FlowPanel getLeftButtonPannel() {
        return this.leftButtonPanel;
    }

    protected FlowPanel getRightButtonPannel() {
        return this.rightButtonPanel;
    }

    public static interface DialogCallback<T> {
        public void ok(T var1);

        public void cancel();
    }

    @FunctionalInterface
    public static interface Validator<T> {
        public String getErrorMessage(T var1);

        default public void validate(T valueToValidate, AsyncCallback<String> callback, AsyncActionsExecutor validationExecutor) {
            validationExecutor.execute(cb -> cb.onSuccess((Object)this.getErrorMessage(valueToValidate)), DataEntryDialog.VALIDATION_ACTION_CATEGORY, callback);
        }
    }
}

