/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.dropdown;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.web.bindery.event.shared.HandlerRegistration;

public class DropdownHandler {
    private HandlerRegistration reg;
    private boolean dropdownShown = false;
    private final Element dropdownContainer;

    public DropdownHandler(Element dropdownTrigger, Element dropdownContainer) {
        this.dropdownContainer = dropdownContainer;
        Event.sinkEvents((Element)dropdownTrigger, (int)1);
        Event.setEventListener((Element)dropdownTrigger, (EventListener)new EventListener(){

            public void onBrowserEvent(Event event) {
                if (!DropdownHandler.this.dropdownShown) {
                    DropdownHandler.this.show();
                }
            }
        });
    }

    public DropdownHandler(FocusWidget dropdownTrigger, Element dropdownContainer) {
        this.dropdownContainer = dropdownContainer;
        dropdownTrigger.addClickHandler(event -> {
            if (!this.dropdownShown) {
                this.show();
            }
        });
    }

    private void show() {
        this.dropdownShown = true;
        this.dropdownStateChanged(true);
        this.reg = Event.addNativePreviewHandler((Event.NativePreviewHandler)new Event.NativePreviewHandler(){

            public void onPreviewNativeEvent(Event.NativePreviewEvent event) {
                EventTarget eventTarget = event.getNativeEvent().getEventTarget();
                if (Element.is((JavaScriptObject)eventTarget)) {
                    Element evtElement = Element.as((JavaScriptObject)eventTarget);
                    if (event.getTypeInt() == 1 && !DropdownHandler.this.dropdownContainer.isOrHasChild((Node)evtElement)) {
                        DropdownHandler.this.hide();
                    }
                }
            }
        });
    }

    void hide() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                DropdownHandler.this.dropdownShown = false;
                DropdownHandler.this.dropdownStateChanged(false);
                if (DropdownHandler.this.reg != null) {
                    DropdownHandler.this.reg.removeHandler();
                    DropdownHandler.this.reg = null;
                }
            }
        });
    }

    public void setVisible(boolean visible) {
        if (visible != this.dropdownShown) {
            if (visible) {
                this.show();
            } else {
                this.hide();
            }
        }
    }

    protected void dropdownStateChanged(boolean dropdownShown) {
        if (dropdownShown) {
            this.dropdownContainer.getStyle().clearDisplay();
        } else {
            this.dropdownContainer.getStyle().setDisplay(Style.Display.NONE);
        }
    }
}

