/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.celltable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.client.ui.Label;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import com.sap.sse.gwt.client.celltable.TableWrapper;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;

public abstract class TableWrapperWithFilter<T, S extends RefreshableSelectionModel<T>, SM extends StringMessages, TR extends CellTableWithCheckboxResources>
extends TableWrapper<T, S, SM, TR> {
    private final LabeledAbstractFilterablePanel<T> filterPanel;

    public TableWrapperWithFilter(SM stringMessages, ErrorReporter errorReporter, boolean multiSelection, boolean enablePager, Optional<EntityIdentityComparator<T>> entityIdentityComparator, Optional<Function<T, Boolean>> updatePermissionFilterForCheckbox, Optional<String> filterLabel, String filterCheckboxLabel) {
        this(stringMessages, errorReporter, multiSelection, enablePager, entityIdentityComparator, (CellTableWithCheckboxResources)GWT.create(CellTableWithCheckboxResources.class), updatePermissionFilterForCheckbox, filterLabel, filterCheckboxLabel);
    }

    public TableWrapperWithFilter(SM stringMessages, ErrorReporter errorReporter, boolean multiSelection, boolean enablePager, Optional<EntityIdentityComparator<T>> entityIdentityComparator, TR tableRes, Optional<Function<T, Boolean>> updatePermissionFilterForCheckbox, Optional<String> filterLabel, String filterCheckboxLabel) {
        super(stringMessages, errorReporter, multiSelection, enablePager, entityIdentityComparator.orElse(null), tableRes);
        this.filterPanel = new LabeledAbstractFilterablePanel<T>(new Label(filterLabel.orElse(stringMessages.filterBy())), Collections.emptySet(), this.dataProvider, (StringMessages)stringMessages, filterCheckboxLabel){

            @Override
            public Iterable<String> getSearchableStrings(T t) {
                return TableWrapperWithFilter.this.getSearchableStrings(t);
            }

            @Override
            public AbstractCellTable<T> getCellTable() {
                return TableWrapperWithFilter.this.getTable();
            }
        };
        this.registerSelectionModelOnNewDataProvider(this.filterPanel.getAllListDataProvider());
        updatePermissionFilterForCheckbox.ifPresent(this.getFilterPanel()::setUpdatePermissionFilterForCheckbox);
        this.mainPanel.insert(this.filterPanel, 0);
    }

    @Override
    public void refresh(Iterable<T> newItems) {
        this.getFilterPanel().updateAll(newItems);
    }

    @Override
    public void refresh() {
        this.getFilterPanel().filter();
    }

    @Override
    public void add(T t) {
        this.getFilterPanel().add(t);
    }

    @Override
    public void remove(T t) {
        this.getFilterPanel().remove(t);
    }

    @Override
    public void clear() {
        this.getFilterPanel().removeAll();
    }

    public LabeledAbstractFilterablePanel<T> getFilterPanel() {
        return this.filterPanel;
    }

    protected abstract Iterable<String> getSearchableStrings(T var1);
}

