/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.debug.client.DebugInfo;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.resources.client.TextResource;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.DefaultErrorReporter;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.JavaScriptInjector;
import com.sap.sse.gwt.client.PendingAjaxCallBundle;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.WindowSizeDetector;
import com.sap.sse.gwt.client.async.PendingAjaxCallMarker;
import com.sap.sse.gwt.client.useragent.UserAgentDetails;

public abstract class AbstractEntryPoint<S extends StringMessages>
implements EntryPoint,
ErrorReporter,
WindowSizeDetector {
    protected UserAgentDetails userAgent;
    private S stringMessages;
    private ErrorReporter errorReporter;

    public final void onModuleLoad() {
        this.stringMessages = this.createStringMessages();
        this.errorReporter = new DefaultErrorReporter<S>(this.stringMessages);
        this.userAgent = new UserAgentDetails(Window.Navigator.getUserAgent());
        if (DebugInfo.isDebugIdEnabled()) {
            PendingAjaxCallBundle bundle = (PendingAjaxCallBundle)GWT.create(PendingAjaxCallBundle.class);
            TextResource script = bundle.ajaxSemaphoreJS();
            JavaScriptInjector.inject(script.getText());
            DebugInfo.setDebugIdAttribute((String)"selenium-id", (boolean)false);
            DebugInfo.setDebugIdPrefix((String)"");
        }
        this.doOnModuleLoad();
        if (DebugInfo.isDebugIdEnabled()) {
            PendingAjaxCallMarker.decrementPendingAjaxCalls("");
        }
    }

    protected abstract S createStringMessages();

    protected abstract void doOnModuleLoad();

    public static void setTabPanelSize(final ResizeComposite tabPanel, final String width, final String height) {
        tabPanel.addAttachHandler(new AttachEvent.Handler(){

            public void onAttachOrDetach(AttachEvent event) {
                tabPanel.getElement().getParentElement().getStyle().setProperty("width", width);
                tabPanel.getElement().getParentElement().getStyle().setProperty("height", height);
            }
        });
    }

    @Override
    public void reportError(String message) {
        this.errorReporter.reportError(message);
    }

    @Override
    public void reportError(String title, String message) {
        this.errorReporter.reportError(title, message);
    }

    @Override
    public void reportError(String message, boolean silentMode) {
        this.errorReporter.reportError(message, silentMode);
    }

    @Override
    public void reportPersistentInformation(String message) {
        this.errorReporter.reportPersistentInformation(message);
    }

    @Override
    public Widget getPersistentInformationWidget() {
        return this.errorReporter.getPersistentInformationWidget();
    }

    @Override
    public boolean isSmallWidth() {
        int width = Window.getClientWidth();
        return width <= 720;
    }

    protected S getStringMessages() {
        return this.stringMessages;
    }
}

