/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.procedures;

import com.sap.sailing.landscape.SailingAnalyticsHost;
import com.sap.sailing.landscape.procedures.SailingAnalyticsHostSupplier;
import com.sap.sailing.landscape.procedures.StartFromSailingAnalyticsImage;
import com.sap.sse.common.Duration;
import com.sap.sse.landscape.aws.HostSupplier;
import com.sap.sse.landscape.aws.Tags;
import com.sap.sse.landscape.aws.orchestration.StartEmptyServer;
import com.sap.sse.shared.util.Wait;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.InstanceType;

public class StartMultiServer<ShardingKey>
extends StartEmptyServer<StartMultiServer<ShardingKey>, ShardingKey, SailingAnalyticsHost<ShardingKey>>
implements StartFromSailingAnalyticsImage {
    private Optional<Duration> optionalTimeout;

    public static <BuilderT extends Builder<BuilderT, ShardingKey>, ShardingKey> Builder<BuilderT, ShardingKey> builder() {
        return new BuilderImpl();
    }

    protected StartMultiServer(BuilderImpl<?, ShardingKey> builder) {
        super(builder);
        this.optionalTimeout = builder.getOptionalTimeout();
    }

    public void run() throws Exception {
        super.run();
        Wait.wait(() -> ((SailingAnalyticsHost)this.getHost()).getInstance().state().name().equals((Object)InstanceStateName.RUNNING), result -> result, (boolean)true, this.optionalTimeout, (Duration)Duration.ONE_SECOND.times(10L), null, null);
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, ShardingKey>, ShardingKey>
    extends StartEmptyServer.Builder<BuilderT, StartMultiServer<ShardingKey>, ShardingKey, SailingAnalyticsHost<ShardingKey>> {
    }

    protected static class BuilderImpl<BuilderT extends Builder<BuilderT, ShardingKey>, ShardingKey>
    extends StartEmptyServer.BuilderImpl<BuilderT, StartMultiServer<ShardingKey>, ShardingKey, SailingAnalyticsHost<ShardingKey>>
    implements Builder<BuilderT, ShardingKey> {
        protected BuilderImpl() {
        }

        public StartMultiServer<ShardingKey> build() {
            return new StartMultiServer(this);
        }

        protected String getImageType() {
            return super.getImageType() == null ? "sailing-analytics-server" : super.getImageType();
        }

        protected String getInstanceName() {
            String result = this.isInstanceNameSet() ? super.getInstanceName() : "SL Multi-Server";
            return result;
        }

        protected HostSupplier<ShardingKey, SailingAnalyticsHost<ShardingKey>> getHostSupplier() {
            SailingAnalyticsHostSupplier result = super.getHostSupplier() == null ? new SailingAnalyticsHostSupplier() : super.getHostSupplier();
            return result;
        }

        protected InstanceType getInstanceType() {
            InstanceType result = super.getInstanceType() == null ? InstanceType.I3_XLARGE : super.getInstanceType();
            return result;
        }

        protected Optional<Tags> getTags() {
            return Optional.of(super.getTags().orElse(Tags.empty()).and("sailing-analytics-server", "___multi___"));
        }

        protected Optional<Duration> getOptionalTimeout() {
            return super.getOptionalTimeout();
        }
    }
}

