/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.impl;

import com.sap.sailing.landscape.EligibleInstanceForReplicaSetFindingStrategy;
import com.sap.sailing.landscape.LandscapeService;
import com.sap.sailing.landscape.SailingAnalyticsHost;
import com.sap.sailing.landscape.SailingAnalyticsMetrics;
import com.sap.sailing.landscape.SailingAnalyticsProcess;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.AvailabilityZone;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.aws.AwsApplicationReplicaSet;
import com.sap.sse.landscape.aws.AwsAvailabilityZone;
import com.sap.sse.landscape.aws.impl.AwsRegion;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.services.ec2.model.InstanceType;

public class EligibleInstanceForReplicaSetFindingStrategyImpl
implements EligibleInstanceForReplicaSetFindingStrategy {
    private static final Logger logger = Logger.getLogger(EligibleInstanceForReplicaSetFindingStrategyImpl.class.getName());
    private final LandscapeService landscapeService;
    private final AwsRegion region;
    private final String optionalKeyName;
    private final byte[] privateKeyEncryptionPassphrase;
    private final boolean master;
    private final boolean mustBeDifferentAvailabilityZone;
    private final InstanceType instanceType;
    private final Optional<SailingAnalyticsHost<String>> optionalPreferredInstanceToDeployTo;

    public EligibleInstanceForReplicaSetFindingStrategyImpl(LandscapeService landscapeService, AwsRegion region, String optionalKeyName, byte[] privateKeyEncryptionPassphrase, boolean master, boolean mustBeDifferentAvailabilityZone, Optional<InstanceType> optionalInstanceType, Optional<SailingAnalyticsHost<String>> optionalPreferredInstanceToDeployTo) {
        this.landscapeService = landscapeService;
        this.region = region;
        this.optionalKeyName = optionalKeyName;
        this.privateKeyEncryptionPassphrase = privateKeyEncryptionPassphrase;
        this.master = master;
        this.mustBeDifferentAvailabilityZone = mustBeDifferentAvailabilityZone;
        this.instanceType = optionalInstanceType.orElse(InstanceType.valueOf((String)"I3_2_XLARGE"));
        this.optionalPreferredInstanceToDeployTo = optionalPreferredInstanceToDeployTo;
    }

    @Override
    public SailingAnalyticsHost<String> getInstanceToDeployTo(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet) throws Exception {
        Integer optionalIgtimiRiotPort = ((SailingAnalyticsProcess)replicaSet.getMaster()).getIgtimiRiotPort(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(this.optionalKeyName), this.privateKeyEncryptionPassphrase);
        return this.optionalPreferredInstanceToDeployTo.map(host -> {
            logger.info("Checking preferred instance " + host + " for eligibility");
            try {
                return this.landscapeService.isEligibleForDeployment(host, replicaSet.getServerName(), replicaSet.getPort(), optionalIgtimiRiotPort, Landscape.WAIT_FOR_PROCESS_TIMEOUT, this.optionalKeyName, this.privateKeyEncryptionPassphrase) && this.isAcceptableAvailabilityZone((AvailabilityZone)host.getAvailabilityZone(), replicaSet) ? host : null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).orElseGet(() -> {
            logger.info("Preferred instance not specified or not eligible. Computing default...");
            Optional<? super SailingAnalyticsHost<String>> bestExistingCandidate = Util.stream(this.landscapeService.getEligibleSharedHostsForReplicaSet(this.region, replicaSet, this.optionalKeyName, this.privateKeyEncryptionPassphrase)).filter(host -> {
                try {
                    return !this.isArchiveServer((SailingAnalyticsHost<String>)host) && this.isAcceptableAvailabilityZone((AvailabilityZone)host.getAvailabilityZone(), replicaSet);
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.log(Level.SEVERE, "Exception while trying to filter eligible hosts", e);
                    return false;
                }
            }).sorted(this.getEligibleHostRanking(replicaSet)).findFirst();
            bestExistingCandidate.ifPresent(bec -> logger.info("Found best existing candidate " + bec));
            return bestExistingCandidate.orElseGet(() -> {
                try {
                    logger.info("No existing candidate found. Launching new instance of type " + this.instanceType + " for replica set " + replicaSet.getName());
                    return this.landscapeService.createEmptyMultiServer(this.region, Optional.of(this.instanceType), this.getPreferredAvailabilityZone(replicaSet), Optional.of("SL Multi-Server"), Optional.ofNullable(this.optionalKeyName), this.privateKeyEncryptionPassphrase);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        });
    }

    private Optional<AwsAvailabilityZone> getPreferredAvailabilityZone(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet) {
        return Util.stream(Arrays.asList(this.region.getAvailabilityZones())).filter(az -> {
            try {
                return this.isAcceptableAvailabilityZone((AvailabilityZone)az, replicaSet);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }).findAny();
    }

    private Comparator<? super SailingAnalyticsHost<String>> getEligibleHostRanking(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet) {
        ConcurrentHashMap numberOfProcesses = new ConcurrentHashMap();
        return (h1, h2) -> {
            try {
                boolean h1AcceptableAvailabilityZoneIfStrict = this.isAcceptableAvailabilityZoneIfStrict((AvailabilityZone)h1.getAvailabilityZone(), replicaSet);
                boolean h2AcceptableAvailabilityZoneIfStrict = this.isAcceptableAvailabilityZoneIfStrict((AvailabilityZone)h2.getAvailabilityZone(), replicaSet);
                if (h1AcceptableAvailabilityZoneIfStrict != h2AcceptableAvailabilityZoneIfStrict) {
                    return h1AcceptableAvailabilityZoneIfStrict ? -1 : 1;
                }
                return numberOfProcesses.computeIfAbsent(h1, this::getNumberOfProcesses).compareTo(numberOfProcesses.computeIfAbsent(h2, this::getNumberOfProcesses));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private int getNumberOfProcesses(SailingAnalyticsHost<String> host) {
        try {
            return Util.size((Iterable)host.getApplicationProcesses(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(this.optionalKeyName), this.privateKeyEncryptionPassphrase));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception trying to obtain number of processes on host " + host, e);
            return Integer.MAX_VALUE;
        }
    }

    private boolean isAcceptableAvailabilityZone(AvailabilityZone availabilityZone, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet) throws InterruptedException, ExecutionException {
        return !this.mustBeDifferentAvailabilityZone || this.isAcceptableAvailabilityZoneIfStrict(availabilityZone, replicaSet);
    }

    private boolean isAcceptableAvailabilityZoneIfStrict(AvailabilityZone availabilityZone, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet) throws InterruptedException, ExecutionException {
        return this.master && this.isAcceptableAvailabilityZoneForMaster(availabilityZone, replicaSet) || !this.master && !((SailingAnalyticsProcess)replicaSet.getMaster()).getHost().getAvailabilityZone().equals(availabilityZone);
    }

    private boolean isAcceptableAvailabilityZoneForMaster(AvailabilityZone availabilityZone, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> replicaSet) throws InterruptedException, ExecutionException {
        boolean result;
        if (Util.isEmpty((Iterable)replicaSet.getReplicas())) {
            result = true;
        } else {
            boolean hasManagedReplicas = false;
            boolean hasManagedReplicaInDifferentAZ = false;
            boolean hasUnmanagedReplicaInDifferentAZ = false;
            for (SailingAnalyticsProcess replica : replicaSet.getReplicas()) {
                boolean isManaged = replica.getHost().isManagedByAutoScalingGroup(Collections.singleton(replicaSet.getAutoScalingGroup()));
                boolean isInDifferentAZ = !replica.getHost().getAvailabilityZone().equals(availabilityZone);
                hasManagedReplicas = hasManagedReplicas || isManaged;
                hasManagedReplicaInDifferentAZ = hasManagedReplicaInDifferentAZ || isManaged && isInDifferentAZ;
                boolean bl = hasUnmanagedReplicaInDifferentAZ = hasUnmanagedReplicaInDifferentAZ || !isManaged && isInDifferentAZ;
            }
            result = hasManagedReplicaInDifferentAZ || !hasManagedReplicas && hasUnmanagedReplicaInDifferentAZ;
        }
        return result;
    }

    private boolean isArchiveServer(SailingAnalyticsHost<String> host) {
        return host.getInstance().tags().stream().filter(tag -> tag.key().equals("sailing-analytics-server") && tag.value().equals("ARCHIVE")).findAny().isPresent();
    }
}

