/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.shared.tracking.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class PartialNavigableSetView<E>
implements NavigableSet<E> {
    private final NavigableSet<E> set;

    public PartialNavigableSetView(NavigableSet<E> set) {
        this.set = set;
    }

    protected abstract boolean isValid(E var1);

    @Override
    public Comparator<? super E> comparator() {
        return this.getSet().comparator();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new PartialNavigableSetViewWithSameValidityAsEnclosing(this.getSet().descendingSet());
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.descendingSet().iterator();
    }

    @Override
    public E first() {
        Object first = this.getSet().first();
        while (first != null && !this.isValid(first)) {
            first = this.getSet().higher(first);
        }
        if (first == null) {
            throw new NoSuchElementException();
        }
        return first;
    }

    @Override
    public E last() {
        Object last = this.getSet().last();
        while (last != null && !this.isValid(last)) {
            last = this.getSet().lower(last);
        }
        if (last == null) {
            throw new NoSuchElementException();
        }
        return last;
    }

    @Override
    public int size() {
        int size = 0;
        for (E e : this.getSet()) {
            if (!this.isValid(e)) continue;
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (E e : this.getSet()) {
            if (!this.isValid(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.getSet().contains(o) && this.isValid(o);
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> l = new ArrayList<E>();
        for (E e : this.getSet()) {
            if (!this.isValid(e)) continue;
            l.add(e);
        }
        return l.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<E> l = new ArrayList<E>();
        for (E e : this.getSet()) {
            if (!this.isValid(e)) continue;
            l.add(e);
        }
        return l.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.getSet().add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.getSet().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.isValid(o) && this.getSet().contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.getSet().addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getSet().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getSet().removeAll(c);
    }

    @Override
    public void clear() {
        this.getSet().clear();
    }

    @Override
    public E lower(E e) {
        E result = this.getSet().lower(e);
        while (result != null && !this.isValid(result)) {
            result = this.getSet().lower(result);
        }
        return result;
    }

    protected E lowerInternal(E e) {
        return this.getSet().lower(e);
    }

    protected E higherInternal(E e) {
        return this.getSet().higher(e);
    }

    @Override
    public E floor(E e) {
        E result = this.getSet().floor(e);
        while (result != null && !this.isValid(result)) {
            result = this.getSet().lower(result);
        }
        return result;
    }

    @Override
    public E ceiling(E e) {
        E result = this.getSet().ceiling(e);
        while (result != null && !this.isValid(result)) {
            result = this.getSet().higher(result);
        }
        return result;
    }

    @Override
    public E higher(E e) {
        E result = this.getSet().higher(e);
        while (result != null && !this.isValid(result)) {
            result = this.getSet().higher(result);
        }
        return result;
    }

    @Override
    public E pollFirst() {
        Object result = this.getSet().first();
        while (result != null && !this.isValid(result)) {
            this.getSet().remove(result);
            result = this.getSet().first();
        }
        return result;
    }

    @Override
    public E pollLast() {
        Object result = this.getSet().last();
        while (result != null && !this.isValid(result)) {
            this.getSet().remove(result);
            result = this.getSet().last();
        }
        return result;
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new PartialNavigableSetViewWithSameValidityAsEnclosing(this.getSet().subSet(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new PartialNavigableSetViewWithSameValidityAsEnclosing(this.getSet().headSet(toElement, inclusive));
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new PartialNavigableSetViewWithSameValidityAsEnclosing(this.getSet().tailSet(fromElement, inclusive));
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, E toElement) {
        SortedSet<E> subSet = this.set.subSet(fromElement, toElement);
        if (subSet instanceof NavigableSet) {
            return new PartialNavigableSetViewWithSameValidityAsEnclosing((NavigableSet)subSet);
        }
        TreeSet<E> result = new TreeSet<E>(subSet);
        return new PartialNavigableSetViewWithSameValidityAsEnclosing(result);
    }

    @Override
    public NavigableSet<E> headSet(E toElement) {
        SortedSet<E> headSet = this.set.headSet(toElement);
        if (headSet instanceof NavigableSet) {
            return new PartialNavigableSetViewWithSameValidityAsEnclosing((NavigableSet)headSet);
        }
        TreeSet<E> result = new TreeSet<E>(headSet);
        return new PartialNavigableSetViewWithSameValidityAsEnclosing(result);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement) {
        SortedSet<E> tailSet = this.set.tailSet(fromElement);
        if (tailSet instanceof NavigableSet) {
            return new PartialNavigableSetViewWithSameValidityAsEnclosing((NavigableSet)tailSet);
        }
        TreeSet<E> result = new TreeSet<E>(tailSet);
        return new PartialNavigableSetViewWithSameValidityAsEnclosing(result);
    }

    @Override
    public Iterator<E> iterator() {
        return new FilteringIterator();
    }

    public String toString() {
        return new ArrayList(this).toString();
    }

    protected NavigableSet<E> getSet() {
        return this.set;
    }

    private class FilteringIterator
    implements Iterator<E> {
        private Iterator<E> iter;
        private E nextValid;
        private boolean hasNext;
        private boolean hasLastNext;
        private E lastNext;

        public FilteringIterator() {
            this.iter = PartialNavigableSetView.this.getSet().iterator();
            this.hasLastNext = false;
            this.advance();
        }

        private void advance() {
            if (this.iter.hasNext()) {
                Object next = this.iter.next();
                while (!PartialNavigableSetView.this.isValid(next) && this.iter.hasNext()) {
                    next = this.iter.next();
                }
                if (PartialNavigableSetView.this.isValid(next)) {
                    this.nextValid = next;
                    this.hasNext = true;
                } else {
                    this.hasNext = false;
                }
            } else {
                this.hasNext = false;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public E next() {
            if (this.hasNext) {
                Object result = this.nextValid;
                this.advance();
                this.hasLastNext = true;
                this.lastNext = result;
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.hasLastNext) {
                throw new IllegalStateException("next() was not called before remove()");
            }
            PartialNavigableSetView.this.remove(this.lastNext);
            this.hasLastNext = false;
        }
    }

    private class PartialNavigableSetViewWithSameValidityAsEnclosing
    extends PartialNavigableSetView<E> {
        public PartialNavigableSetViewWithSameValidityAsEnclosing(NavigableSet<E> set) {
            super(set);
        }

        @Override
        protected boolean isValid(E e) {
            return PartialNavigableSetView.this.isValid(e);
        }
    }
}

