/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sse.common.Color;
import com.sap.sse.common.impl.NamedImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;

public class MarkImpl
extends NamedImpl
implements Mark {
    private static final long serialVersionUID = -4817053057647606900L;
    private final Color color;
    private final String shape;
    private final String pattern;
    private final MarkType type;
    private final String shortName;
    private final Serializable id;
    private final UUID originatingMarkTemplateId;
    private final UUID originatingMarkPropertiesId;

    public MarkImpl(String name) {
        this((Serializable)((Object)name), name);
    }

    public MarkImpl(Serializable id, String name) {
        this(id, name, MarkType.BUOY, null, null, null);
    }

    public MarkImpl(Serializable id, String name, MarkType type, Color color, String shape, String pattern) {
        this(id, name, name, type, color, shape, pattern, null, null);
    }

    public MarkImpl(Serializable id, String name, MarkType type, Color color, String shape, String pattern, UUID originatingMarkTemplateId, UUID originatingMarkPropertiesId) {
        this(id, name, name, type, color, shape, pattern, originatingMarkTemplateId, originatingMarkPropertiesId);
    }

    public MarkImpl(Serializable id, String name, String shortName, MarkType type, Color color, String shape, String pattern, UUID originatingMarkTemplateId, UUID originatingMarkPropertiesId) {
        super(name);
        this.shortName = shortName;
        this.id = id;
        this.type = type;
        this.color = color;
        this.shape = shape;
        this.pattern = pattern;
        this.originatingMarkTemplateId = originatingMarkTemplateId;
        this.originatingMarkPropertiesId = originatingMarkPropertiesId;
    }

    public Serializable getId() {
        return this.id;
    }

    @Override
    public Iterable<Mark> getMarks() {
        Set<Mark> result = Collections.singleton(this);
        return result;
    }

    public Mark resolve(SharedDomainFactory<?> domainFactory) {
        Mark result = domainFactory.getOrCreateMark(this.getId(), this.getName(), this.shortName, this.type, this.color, this.shape, this.pattern);
        return result;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public String getShape() {
        return this.shape;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public MarkType getType() {
        return this.type;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public UUID getOriginatingMarkTemplateIdOrNull() {
        return this.originatingMarkTemplateId;
    }

    @Override
    public UUID getOriginatingMarkPropertiesIdOrNull() {
        return this.originatingMarkPropertiesId;
    }

    public String toString() {
        return this.getId() + " " + (this.getColor() == null ? "" : this.getColor() + " ") + super.toString();
    }
}

