/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl;

import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogCloseOpenEndedDeviceMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogAnalyzer;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.racelogtracking.DeviceMappingWithRegattaLogEvent;
import com.sap.sailing.domain.racelogtracking.impl.DeviceMappingWithRegattaLogEventImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.WithID;
import com.sap.sse.common.impl.TimeRangeImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class RegattaLogDeviceMappingFinder<ItemT extends WithID>
extends RegattaLogAnalyzer<Map<ItemT, List<DeviceMappingWithRegattaLogEvent<ItemT>>>> {
    private static Logger logger = Logger.getLogger(RegattaLogDeviceMappingFinder.class.getName());

    public RegattaLogDeviceMappingFinder(RegattaLog log) {
        super(log);
    }

    protected boolean isValidMapping(RegattaLogDeviceMappingEvent<?> mapping) {
        return mapping instanceof RegattaLogDeviceMappingEvent;
    }

    protected DeviceMappingWithRegattaLogEvent<ItemT> createMapping(DeviceIdentifier device, ItemT item, TimePoint from, TimePoint toInclusive, Serializable originalEventId, RegattaLogDeviceMappingEvent<ItemT> event) {
        return new DeviceMappingWithRegattaLogEventImpl<ItemT>(item, device, (TimeRange)new TimeRangeImpl(from, toInclusive != null && toInclusive.before(from) ? from : toInclusive, true), Collections.singletonList(originalEventId), event);
    }

    private List<RegattaLogDeviceMappingEvent<ItemT>> getMappingEventsForItem(Map<ItemT, List<RegattaLogDeviceMappingEvent<ItemT>>> map, ItemT item) {
        List<RegattaLogDeviceMappingEvent<ItemT>> list = map.get(item);
        if (list == null) {
            list = new ArrayList<RegattaLogDeviceMappingEvent<ItemT>>();
            map.put(item, list);
        }
        return list;
    }

    @Override
    protected Map<ItemT, List<DeviceMappingWithRegattaLogEvent<ItemT>>> performAnalysis() {
        HashMap events = new HashMap();
        HashMap<Serializable, RegattaLogCloseOpenEndedDeviceMappingEvent> closingEvents = new HashMap<Serializable, RegattaLogCloseOpenEndedDeviceMappingEvent>();
        this.findUnrevokedMappingAndClosingEvents(events, closingEvents);
        HashMap<WithID, List<DeviceMappingWithRegattaLogEvent<WithID>>> mappings = new HashMap<WithID, List<DeviceMappingWithRegattaLogEvent<WithID>>>();
        for (WithID item : events.keySet()) {
            mappings.put(item, this.closeOpenRanges((List)events.get(item), item, closingEvents));
        }
        return mappings;
    }

    protected void findUnrevokedMappingAndClosingEvents(Map<ItemT, List<RegattaLogDeviceMappingEvent<ItemT>>> events, Map<Serializable, RegattaLogCloseOpenEndedDeviceMappingEvent> closingEvents) {
        RegattaLog regattaLog = (RegattaLog)this.getLog();
        regattaLog.lockForRead();
        try {
            for (RegattaLogEvent e : regattaLog.getUnrevokedEvents()) {
                if (e instanceof RegattaLogDeviceMappingEvent && this.isValidMapping((RegattaLogDeviceMappingEvent)e)) {
                    RegattaLogDeviceMappingEvent mappingEvent = (RegattaLogDeviceMappingEvent)e;
                    this.getMappingEventsForItem(events, mappingEvent.getMappedTo()).add(mappingEvent);
                    continue;
                }
                if (!(e instanceof RegattaLogCloseOpenEndedDeviceMappingEvent)) continue;
                RegattaLogCloseOpenEndedDeviceMappingEvent closingEvent = (RegattaLogCloseOpenEndedDeviceMappingEvent)e;
                closingEvents.put(closingEvent.getDeviceMappingEventId(), closingEvent);
            }
        }
        finally {
            regattaLog.unlockAfterRead();
        }
    }

    private List<DeviceMappingWithRegattaLogEvent<ItemT>> closeOpenRanges(List<RegattaLogDeviceMappingEvent<ItemT>> events, ItemT item, Map<Serializable, RegattaLogCloseOpenEndedDeviceMappingEvent> closingEvents) {
        ArrayList<DeviceMappingWithRegattaLogEvent<ItemT>> result = new ArrayList<DeviceMappingWithRegattaLogEvent<ItemT>>();
        for (RegattaLogDeviceMappingEvent<ItemT> event : events) {
            TimePoint closingTimePointInclusive;
            TimePoint from = event.getFrom();
            TimePoint toInclusive = event.getToInclusive();
            TimePoint timePoint = closingTimePointInclusive = closingEvents.containsKey(event.getId()) ? closingEvents.get(event.getId()).getClosingTimePointInclusive() : null;
            if (from == null) {
                logger.severe("No start time set for DeviceMappingEvent with ID: " + event.getId());
            }
            if (toInclusive == null) {
                toInclusive = closingTimePointInclusive;
            }
            result.add(this.createMapping(event.getDevice(), item, from, toInclusive, event.getId(), event));
        }
        return result;
    }
}

