/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.regatta.impl;

import com.sap.sailing.domain.abstractlog.BaseLogAnalyzer;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEventVisitor;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogDeviceMappingFinder;
import com.sap.sailing.domain.racelogtracking.DeviceMappingWithRegattaLogEvent;
import com.sap.sse.common.WithID;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class OpenEndedDeviceMappingFinder
extends BaseLogAnalyzer<RegattaLog, RegattaLogEvent, RegattaLogEventVisitor, Serializable> {
    private final WithID mappedTo;
    private final Serializable deviceUuidAsString;
    private final RegattaLogDeviceMappingFinder<WithID> mappingFinder;

    public OpenEndedDeviceMappingFinder(RegattaLog log, WithID mappedTo, String deviceUuidAsString) {
        super(log);
        this.mappingFinder = new RegattaLogDeviceMappingFinder(log);
        this.mappedTo = mappedTo;
        this.deviceUuidAsString = deviceUuidAsString;
    }

    @Override
    protected Serializable performAnalysis() {
        Serializable result;
        Map mappings = (Map)this.mappingFinder.analyze();
        List mappingsForObject = (List)mappings.get(this.mappedTo);
        if (mappingsForObject != null) {
            result = null;
            for (DeviceMappingWithRegattaLogEvent mappingEvent : mappingsForObject) {
                if (!mappingEvent.getDevice().getStringRepresentation().equals(this.deviceUuidAsString) || !mappingEvent.getTimeRange().hasOpenEnd()) continue;
                result = mappingEvent.getRegattaLogEvent().getId();
                break;
            }
        } else {
            result = null;
        }
        return result;
    }
}

