/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.sensordata.BravoSensorDataMetadata;
import com.sap.sailing.domain.common.tracking.BravoFix;
import com.sap.sailing.domain.common.tracking.DoubleVectorFix;
import com.sap.sailing.domain.common.tracking.impl.BravoFixImpl;
import com.sap.sailing.domain.common.tracking.impl.DoubleVectorFixImpl;
import com.sap.sailing.domain.tracking.DynamicBravoFixTrack;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.impl.CompetitorBravoFixTrackImpl;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.impl.AbstractReceiverWithQueue;
import com.sap.sailing.domain.tractracadapter.impl.Simulator;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.model.lib.api.event.IRaceCompetitor;
import com.tractrac.model.lib.api.sensor.ISensorData;
import com.tractrac.subscription.lib.api.IEventSubscriber;
import com.tractrac.subscription.lib.api.IRaceSubscriber;
import com.tractrac.subscription.lib.api.competitor.ICompetitorSensorDataListener;
import java.util.logging.Logger;

public class SensorDataReceiver
extends AbstractReceiverWithQueue<IRaceCompetitor, ISensorData, Void> {
    private static final Logger logger = Logger.getLogger(SensorDataReceiver.class.getName());
    private final ICompetitorSensorDataListener listener = new ICompetitorSensorDataListener(){

        public void gotSensorData(IRaceCompetitor raceCompetitor, ISensorData sensorData) {
            SensorDataReceiver.this.enqueue(new Util.Triple((Object)raceCompetitor, (Object)sensorData, null));
        }
    };
    private int received;

    public SensorDataReceiver(DynamicTrackedRegatta trackedRegatta, IEvent tractracEvent, Simulator simulator, DomainFactory domainFactory, IEventSubscriber eventSubscriber, IRaceSubscriber raceSubscriber, long timeoutInMilliseconds) {
        super(domainFactory, tractracEvent, trackedRegatta, simulator, eventSubscriber, raceSubscriber, timeoutInMilliseconds);
    }

    @Override
    public void subscribe() {
        this.getRaceSubscriber().subscribeCompetitorSensorData(this.listener);
        this.startThread();
    }

    @Override
    protected void unsubscribe() {
        this.getRaceSubscriber().unsubscribeCompetitorSensorData(this.listener);
    }

    @Override
    protected void handleEvent(Util.Triple<IRaceCompetitor, ISensorData, Void> event) {
        IRace race;
        DynamicTrackedRace trackedRace;
        if (this.received++ % 1000 == 0) {
            System.out.print("S");
            if ((this.received / 1000 + 1) % 80 == 0) {
                System.out.println();
            }
        }
        if ((trackedRace = this.getTrackedRace(race = ((IRaceCompetitor)event.getA()).getRace())) != null) {
            ISensorData sensorData = (ISensorData)event.getB();
            if (sensorData != null) {
                Float rideHeightPortInMeters = sensorData.getRideHeightPort();
                Float rideHeightStarboardInMeters = sensorData.getRideHeightStarboard();
                Float heelInDegrees = sensorData.getHeel();
                Float trimInDegrees = sensorData.getTrim();
                Double[] fixData = new Double[BravoSensorDataMetadata.getTrackColumnCount()];
                boolean create = false;
                if (rideHeightPortInMeters != null) {
                    fixData[BravoSensorDataMetadata.RIDE_HEIGHT_PORT_HULL.getColumnIndex()] = rideHeightPortInMeters.floatValue();
                    create = true;
                }
                if (rideHeightStarboardInMeters != null) {
                    fixData[BravoSensorDataMetadata.RIDE_HEIGHT_STBD_HULL.getColumnIndex()] = rideHeightStarboardInMeters.floatValue();
                    create = true;
                }
                if (heelInDegrees != null) {
                    fixData[BravoSensorDataMetadata.HEEL.getColumnIndex()] = heelInDegrees.floatValue();
                    create = true;
                }
                if (trimInDegrees != null) {
                    fixData[BravoSensorDataMetadata.PITCH.getColumnIndex()] = trimInDegrees.floatValue();
                    create = true;
                }
                if (create) {
                    BravoFixImpl fix = new BravoFixImpl((DoubleVectorFix)new DoubleVectorFixImpl((TimePoint)new MillisecondsTimePoint(sensorData.getTimestamp()), fixData));
                    Competitor competitor = this.getDomainFactory().resolveCompetitor(((IRaceCompetitor)event.getA()).getCompetitor());
                    DynamicBravoFixTrack bravoFixTrack = (DynamicBravoFixTrack)trackedRace.getOrCreateSensorTrack(competitor, "BravoFixTrack", () -> new CompetitorBravoFixTrackImpl(competitor, "BravoFixTrack", false, (GPSFixTrack)trackedRace.getTrack(competitor)));
                    if (this.getSimulator() != null) {
                        this.getSimulator().scheduleCompetitorSensorData((DynamicBravoFixTrack<Competitor>)bravoFixTrack, (BravoFix)fix);
                    } else {
                        bravoFixTrack.add((Timed)fix);
                    }
                }
            }
        } else {
            logger.warning("Couldn't find tracked race for race " + race.getName() + ". Dropping sensor event " + event);
        }
    }
}

