/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.mongodb.client.MongoDatabase;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.aws.orchestration.AbstractAwsProcedureImpl;
import com.sap.sse.landscape.mongodb.Database;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class CopyAndCompareMongoDatabase<ShardingKey>
extends AbstractAwsProcedureImpl<ShardingKey> {
    private static final Logger logger = Logger.getLogger(BuilderImpl.class.getName());
    private final Database sourceDatabase;
    private final Database targetDatabase;
    private final Iterable<Database> additionalDatabasesToDelete;
    private final boolean dropTargetFirst;
    private final boolean dropSourceAfterSuccessfulCopy;
    private String mongoDbArchivingErrorMessage;

    public static <BuilderT extends Builder<BuilderT, ShardingKey>, ShardingKey> Builder<BuilderT, ShardingKey> builder() {
        return new BuilderImpl();
    }

    protected CopyAndCompareMongoDatabase(BuilderImpl<?, ShardingKey> builder) {
        super(builder);
        this.sourceDatabase = builder.getSourceDatabase();
        this.targetDatabase = builder.getTargetDatabase();
        this.additionalDatabasesToDelete = builder.getAdditionalDatabasesToDelete() == null ? Collections.emptySet() : builder.getAdditionalDatabasesToDelete();
        this.dropTargetFirst = builder.isDropTargetFirst();
        this.dropSourceAfterSuccessfulCopy = builder.isDropSourceAfterSuccessfulCopy();
    }

    public String getMongoDbArchivingErrorMessage() {
        return this.mongoDbArchivingErrorMessage;
    }

    public void run() throws Exception {
        MongoDatabase result;
        if (this.targetDatabase.equals(this.sourceDatabase)) {
            throw new IllegalArgumentException("Source and target database must be different: " + this.sourceDatabase);
        }
        if (this.dropTargetFirst) {
            logger.info("Dropping target database " + this.targetDatabase + " before importing from " + this.sourceDatabase);
            this.targetDatabase.drop();
        }
        if ((result = this.targetDatabase.getEndpoint().importDatabase(this.sourceDatabase.getMongoDatabase())) == null) {
            this.mongoDbArchivingErrorMessage = "This didn't work. No database resulted from importing " + this.sourceDatabase + " into " + this.targetDatabase;
            throw new IllegalStateException(this.mongoDbArchivingErrorMessage);
        }
        ScheduledExecutorService executor = ThreadPoolUtil.INSTANCE.createBackgroundTaskThreadPoolExecutor(2, "MongoDB MD5 Hasher " + UUID.randomUUID(), true);
        Future<String> sourceMd5 = executor.submit(() -> this.sourceDatabase.getMD5Hash());
        Future<String> targetMd5 = executor.submit(() -> this.targetDatabase.getMD5Hash());
        if (sourceMd5.get(((Duration)Landscape.WAIT_FOR_HOST_TIMEOUT.get()).asMillis(), TimeUnit.MILLISECONDS).equals(targetMd5.get(((Duration)Landscape.WAIT_FOR_HOST_TIMEOUT.get()).asMillis(), TimeUnit.MILLISECONDS))) {
            logger.info("Databases " + this.sourceDatabase + " and " + this.targetDatabase + " have equal MD5 hash " + sourceMd5.get() + ".");
            if (this.dropSourceAfterSuccessfulCopy) {
                logger.info("Removing " + this.sourceDatabase + " and " + Util.joinStrings((String)", ", this.additionalDatabasesToDelete));
                this.sourceDatabase.drop();
                for (Database additionalDatabaseToDelete : this.additionalDatabasesToDelete) {
                    additionalDatabaseToDelete.drop();
                }
            }
        } else {
            this.mongoDbArchivingErrorMessage = "Import failed; hashes are different. " + this.sourceDatabase + " has " + sourceMd5.get() + ", " + this.targetDatabase + " has " + targetMd5.get();
            throw new IllegalStateException(this.mongoDbArchivingErrorMessage);
        }
        executor.shutdown();
    }

    public static interface Builder<BuilderT extends AbstractAwsProcedureImpl.Builder<BuilderT, CopyAndCompareMongoDatabase<ShardingKey>, ShardingKey>, ShardingKey>
    extends AbstractAwsProcedureImpl.Builder<BuilderT, CopyAndCompareMongoDatabase<ShardingKey>, ShardingKey> {
        public BuilderT setSourceDatabase(Database var1);

        public BuilderT setTargetDatabase(Database var1);

        public BuilderT setAdditionalDatabasesToDelete(Iterable<Database> var1);

        public BuilderT dropTargetFirst(boolean var1);

        public BuilderT dropSourceAfterSuccessfulCopy(boolean var1);
    }

    public static class BuilderImpl<BuilderT extends Builder<BuilderT, ShardingKey>, ShardingKey>
    extends AbstractAwsProcedureImpl.BuilderImpl<BuilderT, CopyAndCompareMongoDatabase<ShardingKey>, ShardingKey>
    implements Builder<BuilderT, ShardingKey> {
        private Database sourceDatabase;
        private Database targetDatabase;
        private Iterable<Database> additionalDatabasesToDelete;
        private boolean dropTargetFirst;
        private boolean dropSourceAfterSuccessfulCopy;

        public CopyAndCompareMongoDatabase<ShardingKey> build() throws Exception {
            return new CopyAndCompareMongoDatabase(this);
        }

        @Override
        public BuilderT setSourceDatabase(Database sourceDatabase) {
            this.sourceDatabase = sourceDatabase;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setTargetDatabase(Database targetDatabase) {
            this.targetDatabase = targetDatabase;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setAdditionalDatabasesToDelete(Iterable<Database> additionalDatabasesToDelete) {
            this.additionalDatabasesToDelete = additionalDatabasesToDelete;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT dropTargetFirst(boolean dropTargetFirst) {
            this.dropTargetFirst = dropTargetFirst;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT dropSourceAfterSuccessfulCopy(boolean dropSourceAfterSuccessfulCopy) {
            this.dropSourceAfterSuccessfulCopy = dropSourceAfterSuccessfulCopy;
            return (BuilderT)((Builder)this.self());
        }

        protected Database getSourceDatabase() {
            return this.sourceDatabase;
        }

        protected Database getTargetDatabase() {
            return this.targetDatabase;
        }

        protected Iterable<Database> getAdditionalDatabasesToDelete() {
            return this.additionalDatabasesToDelete;
        }

        protected boolean isDropTargetFirst() {
            return this.dropTargetFirst;
        }

        protected boolean isDropSourceAfterSuccessfulCopy() {
            return this.dropSourceAfterSuccessfulCopy;
        }
    }
}

