/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.racelog.tracking.impl;

import com.mongodb.ReadConcern;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.lang.Nullable;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.persistence.FieldNames;
import com.sap.sailing.domain.persistence.impl.DomainObjectFactoryImpl;
import com.sap.sailing.domain.persistence.racelog.tracking.FixMongoHandler;
import com.sap.sailing.domain.persistence.racelog.tracking.impl.MetadataUpdate;
import com.sap.sailing.domain.persistence.racelog.tracking.impl.MetadataUpdater;
import com.sap.sailing.domain.persistence.racelog.tracking.impl.MongoFixHandler;
import com.sap.sailing.shared.persistence.device.DeviceIdentifierMongoHandler;
import com.sap.sailing.shared.persistence.impl.MongoObjectFactoryImpl;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.TypeBasedServiceFinder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MetadataCollection
extends MongoFixHandler {
    private static final Logger logger = Logger.getLogger(MetadataCollection.class.getName());
    private final MongoCollection<Document> metadataCollection;
    private final ConcurrentMap<DeviceIdentifier, MetadataUpdater> metadataUpdaters;
    private final WriteConcern writeConcern;
    private final ReadConcern readConcern;
    @Nullable
    private final ClientSession clientSession;

    public MetadataCollection(com.sap.sailing.domain.persistence.impl.MongoObjectFactoryImpl mongoOF, TypeBasedServiceFinder<FixMongoHandler<?>> fixServiceFinder, TypeBasedServiceFinder<DeviceIdentifierMongoHandler> deviceServiceFinder, ReadConcern readConcern, WriteConcern writeConcern, ClientSession clientSession) {
        super(fixServiceFinder, deviceServiceFinder);
        this.metadataCollection = mongoOF.getGPSFixMetadataCollection();
        this.metadataUpdaters = new ConcurrentHashMap<DeviceIdentifier, MetadataUpdater>();
        this.readConcern = readConcern;
        this.writeConcern = writeConcern;
        this.clientSession = clientSession;
    }

    private Document findMetadataObject(DeviceIdentifier device) throws TransformationException, NoCorrespondingServiceRegisteredException {
        this.waitForPendingMetadataUpdates(device);
        return this.findMetadataObjectInternal(device);
    }

    private Document findMetadataObjectInternal(DeviceIdentifier device) throws TransformationException {
        Bson query = MongoObjectFactoryImpl.getDeviceQuery((TypeBasedServiceFinder)this.deviceServiceFinder, (DeviceIdentifier)device);
        MongoCollection metadataCollectionWithReadConcern = this.metadataCollection.withReadConcern(this.readConcern);
        Document result = (Document)(this.clientSession == null ? metadataCollectionWithReadConcern.find(query) : metadataCollectionWithReadConcern.find(this.clientSession, query)).first();
        return result;
    }

    TimeRange getTimeRangeCoveredByFixes(DeviceIdentifier device) throws TransformationException, NoCorrespondingServiceRegisteredException {
        Document resultDocument = this.findMetadataObject(device);
        return this.getTimeRangeCoveredByFixesInternal(resultDocument);
    }

    private TimeRange getTimeRangeCoveredByFixesInternal(DeviceIdentifier device) throws TransformationException {
        return this.getTimeRangeCoveredByFixesInternal(this.findMetadataObjectInternal(device));
    }

    private TimeRange getTimeRangeCoveredByFixesInternal(Document resultDocument) {
        TimeRange result = resultDocument == null ? null : DomainObjectFactoryImpl.loadTimeRange(resultDocument, FieldNames.TIMERANGE);
        return result;
    }

    protected long getNumberOfFixes(DeviceIdentifier device) throws TransformationException, NoCorrespondingServiceRegisteredException {
        Document resultDocument = this.findMetadataObject(device);
        long result = resultDocument == null ? 0L : ((Number)resultDocument.get((Object)FieldNames.NUM_FIXES.name())).longValue();
        return result;
    }

    <FixT extends Timed> Map<DeviceIdentifier, FixT> getFixLastReceived(Iterable<DeviceIdentifier> forDevices) throws TransformationException, NoCorrespondingServiceRegisteredException {
        HashMap result = new HashMap();
        for (DeviceIdentifier deviceIdentifier : forDevices) {
            Object lastFixForDevice;
            Document lastFixForDeviceDbObject;
            Document metadataDoc = this.findMetadataObject(deviceIdentifier);
            if (metadataDoc == null || (lastFixForDeviceDbObject = (Document)metadataDoc.get((Object)FieldNames.LAST_FIX_RECEIVED.name())) == null) continue;
            Object lastFixForDeviceTyped = lastFixForDevice = this.loadFix(lastFixForDeviceDbObject);
            result.put(deviceIdentifier, lastFixForDeviceTyped);
        }
        return result;
    }

    protected synchronized <FixT extends Timed> void enqueueMetadataUpdate(DeviceIdentifier device, Object dbDeviceId, int nrOfTotalFixes, TimeRange fixesTimeRange, FixT latestFix) throws TransformationException {
        MetadataUpdater metadataUpdaterForDevice = this.metadataUpdaters.computeIfAbsent(device, d -> new MetadataUpdater(this, device));
        metadataUpdaterForDevice.enqueueMetadataUpdate(device, dbDeviceId, nrOfTotalFixes, fixesTimeRange, latestFix);
    }

    private synchronized void waitForPendingMetadataUpdates(DeviceIdentifier device) {
        MetadataUpdater metadataUpdaterForDevice = (MetadataUpdater)this.metadataUpdaters.get(device);
        if (metadataUpdaterForDevice != null) {
            metadataUpdaterForDevice.waitForPendingUpdates();
        }
    }

    <FixT extends Timed> void update(MetadataUpdate<FixT> update) throws TransformationException, NoCorrespondingServiceRegisteredException {
        logger.fine(() -> "Updating sensor fix store metadata with " + update);
        TimeRange oldTimeRange = this.getTimeRangeCoveredByFixesInternal(update.getDevice());
        TimeRange newTimeRange = oldTimeRange == null ? update.getFixesTimeRange() : (update.getFixesTimeRange() == null ? oldTimeRange : oldTimeRange.extend(update.getFixesTimeRange()));
        Document updateOperation = new Document();
        Document newMetadata = new Document();
        newMetadata.put(FieldNames.DEVICE_ID.name(), update.getDbDeviceId());
        if (update.getLatestFix() != null) {
            newMetadata.put(FieldNames.LAST_FIX_RECEIVED.name(), (Object)this.storeFixToDocument(new Document(), update.getLatestFix()));
        }
        com.sap.sailing.domain.persistence.impl.MongoObjectFactoryImpl.storeTimeRange(newTimeRange, newMetadata, FieldNames.TIMERANGE);
        updateOperation.append("$set", (Object)newMetadata);
        updateOperation.append("$inc", (Object)new Document(FieldNames.NUM_FIXES.name(), (Object)update.getNrOfTotalFixes()));
        logger.fine(() -> "Updating sensor fix store metadata with update operation " + updateOperation);
        MongoCollection metadataCollectionWithWriteConcern = this.metadataCollection.withWriteConcern(this.writeConcern);
        Bson deviceQuery = MongoObjectFactoryImpl.getDeviceQuery((TypeBasedServiceFinder)this.deviceServiceFinder, (DeviceIdentifier)update.getDevice());
        UpdateOptions upsertOption = new UpdateOptions().upsert(true);
        if (this.clientSession == null) {
            metadataCollectionWithWriteConcern.updateOne(deviceQuery, (Bson)updateOperation, upsertOption);
        } else {
            metadataCollectionWithWriteConcern.updateOne(this.clientSession, deviceQuery, (Bson)updateOperation, upsertOption);
        }
    }
}

